/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.sysdef;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.workbench.shell.BNiagaraWbShell;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BICredentials;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.commands.InvokeActionCommand;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSubject;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

@NiagaraType
@NiagaraAction(name="updateDetails")
public class BSysDefNetwork
extends BWbView
implements Runnable {
    @Generated
    public static final Action updateDetails = BSysDefNetwork.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSysDefNetwork.class);
    BTextField startStation;
    BTextField targetStation;
    BTextEditorPane stationServices;
    static Lexicon lex = Lexicon.make(BSysDefNetwork.class);
    private BNiagaraNetwork network = null;
    private ProviderSession sysdef = null;
    BTree tree = new BTree();
    Model model;
    Node localNode;

    @Generated
    public void updateDetails() {
        this.invoke(updateDetails, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSysDefNetwork() {
        this.tree.setMultipleSelection(false);
        this.tree.setController((TreeController)new Controller());
        this.model = new Model();
        this.tree.setModel((TreeModel)this.model);
        this.linkTo((BComponent)this.tree, (Slot)BTree.actionPerformed, (Slot)updateDetails);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        this.network = (BNiagaraNetwork)value;
        this.sysdef = this.network.getSysDefProvider().createSession("SysDefNetwork", context);
        BEdgePane view = new BEdgePane();
        this.loadTree();
        view.setCenter((BWidget)new BBorderPane((BWidget)this.tree, BBorder.inset, BInsets.DEFAULT));
        BGridPane temp = new BGridPane(4);
        this.startStation = new BTextField("Start");
        this.targetStation = new BTextField("Target");
        temp.add(null, (BValue)new BButton((Command)new ConnectCommand()));
        temp.add(null, (BValue)this.startStation);
        temp.add(null, (BValue)this.targetStation);
        temp.add(null, (BValue)new BButton((Command)new FindCommand()));
        temp.add(null, (BValue)new BButton((Command)new EngageTestCommand()));
        BEdgePane bottom = new BEdgePane();
        bottom.setTop((BWidget)temp);
        this.stationServices = new BTextEditorPane("", 5, 80, false);
        bottom.setBottom((BWidget)this.stationServices);
        view.setBottom((BWidget)bottom);
        this.setContent((BWidget)view);
        this.network.getWorkers().register((Object)this, 1000L);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        if (this.network != null) {
            this.network.getWorkers().unregister((Object)this);
        }
        return super.doSaveValue(value, cx);
    }

    public void deactivated() {
        if (this.sysdef != null) {
            this.sysdef.close();
        }
        if (this.network != null) {
            this.network.getWorkers().unregister((Object)this);
        }
        super.deactivated();
    }

    public void stopped() throws Exception {
        if (this.sysdef != null) {
            this.sysdef.close();
        }
        if (this.network != null) {
            this.network.getWorkers().unregister((Object)this);
        }
        super.stopped();
    }

    @Override
    public void run() {
        this.tree.repaint();
        this.updateServices();
    }

    void updateServices() {
        Node selected = (Node)this.tree.getSelection().getNode();
        StringBuilder sb = new StringBuilder();
        if (selected != null) {
            BProviderStation ps = (BProviderStation)this.sysdef.getStation(selected.station);
            Object[] serviceTypes = ps.getServiceTypes().trim();
            SortUtil.sort((Object[])serviceTypes);
            int len = serviceTypes != null ? serviceTypes.length : 0;
            for (int i = 0; i < len; ++i) {
                sb.append(((BTypeSpec)serviceTypes[i]).getTypeName()).append("; ");
                if (i <= 0 || i % 4 != 0) continue;
                sb.append("\n");
            }
        }
        this.stationServices.setText(sb.toString());
    }

    private void loadTree() {
        BProviderStation local = (BProviderStation)this.sysdef.getLocalStation();
        BINiagaraStation[] supervisors = this.sysdef.getSupervisors((BINiagaraStation)local);
        for (int i = 0; i < supervisors.length; ++i) {
            this.model.addRoot(new SupervisorNode((TreeModel)this.model, null, (BProviderStation)supervisors[i]));
        }
        this.localNode = new Node(this.model, null, local.getStationName());
        this.model.addRoot(this.localNode);
    }

    public void doUpdateDetails() {
        Node selected = (Node)this.tree.getSelection().getNode();
        if (selected == null) {
            System.out.println("None selected.");
        } else {
            System.out.println("Selected: " + selected.station);
            this.updateServices();
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected BMenu makePopup(TreeSubject subject) {
            BMenu menu = super.makePopup(subject);
            if (menu == null) {
                menu = new BMenu();
            }
            menu.add(null, (Command)new ConnectCommand());
            return menu;
        }
    }

    class SupervisorNode
    extends Node {
        public SupervisorNode(TreeModel model, TreeNode parent, BProviderStation station) {
            super(model, parent, station.getStationName());
        }

        @Override
        public boolean hasChildren() {
            return false;
        }
    }

    class Node
    extends TreeNode {
        String station;
        TreeNode[] subordinates;

        public Node(TreeModel model, TreeNode parent, String station) {
            super(model, parent);
            this.station = station;
            this.subordinates = null;
        }

        public TreeNode getChild(int index) {
            this.load();
            return this.subordinates[index];
        }

        public int getChildCount() {
            this.load();
            return this.subordinates.length;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"device.png"));
        }

        public String getText() {
            return this.station;
        }

        public boolean hasChildren() {
            return true;
        }

        protected void load() {
            if (this.subordinates == null) {
                System.out.println("Load: " + this.station);
                BINiagaraStation[] subs = BSysDefNetwork.this.sysdef.getSubordinates(BSysDefNetwork.this.sysdef.getStation(this.station));
                this.subordinates = new TreeNode[subs.length];
                for (int i = 0; i < subs.length; ++i) {
                    this.subordinates[i] = new Node(this.getModel(), this, subs[i].getStationName());
                }
            }
        }
    }

    class Model
    extends TreeModel {
        Array<Node> roots = new Array(Node.class);

        Model() {
        }

        public TreeNode getRoot(int index) {
            return (TreeNode)this.roots.get(index);
        }

        public int getRootCount() {
            return this.roots.size();
        }

        public void addRoot(Node root) {
            this.roots.add((Object)root);
        }
    }

    class EngageTestCommand
    extends Command {
        public EngageTestCommand() {
            super((BWidget)BSysDefNetwork.this, "Engage/Disengage");
        }

        public CommandArtifact doInvoke() throws Exception {
            Node selected = (Node)BSysDefNetwork.this.tree.getSelection().getNode();
            if (selected != null) {
                BINiagaraStation nStation = BSysDefNetwork.this.sysdef.getStation(selected.station);
                nStation.engageNoRetry("test");
                System.out.println(nStation.getStationName() + " engaged " + nStation.isEngaged("test"));
                nStation.disengage("test");
            }
            return null;
        }
    }

    class LocalStationCommand
    extends Command {
        Action action;
        Node selection;

        public LocalStationCommand(TreeNode selection, Action action) {
            super((BWidget)BSysDefNetwork.this, action.getDefaultDisplayName(null));
            this.action = action;
            this.selection = (Node)selection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() throws Exception {
            BFoxSession sourceSession = BSysDefNetwork.this.sysdef.getFoxSession(BSysDefNetwork.this.sysdef.getStation(this.selection.station));
            BFoxClientConnection.StringInterest interest = null;
            BOrd ord = sourceSession.getNavOrd();
            BNiagaraWbShell shell = (BNiagaraWbShell)BSysDefNetwork.this.getWbShell();
            if (!sourceSession.isConnected()) {
                try {
                    if (shell.isAppletOrWebStart()) {
                        sourceSession.getConnection().setCheckBrandCompatibility(false);
                    }
                    BISession session = BSysDefNetwork.this.network.getSession();
                    BICredentials credentials = (BICredentials)((BComplex)((BFoxSession)session).getCredentials()).newCopy(true);
                    shell.resolve(ord, credentials);
                }
                catch (Throwable e) {
                    if (e instanceof UnresolvedException) {
                        e = e.getCause();
                    }
                    String msg = lex.getText("mgr.connect.cannotConnect", new Object[]{this.selection.station, ord});
                    BDialog.error((BWidget)BSysDefNetwork.this, (String)BDialog.TITLE_ERROR, (Object)msg, (Throwable)e);
                    return null;
                }
                if (!sourceSession.isConnected()) {
                    throw new IllegalStateException();
                }
                StringBuilder sb = new StringBuilder();
                sb.append("SysDefAction_").append(this.action.getName()).append("_");
                sb.append(this.selection.station).append("_");
                sb.append(BAbsTime.now().encodeToString());
                interest = new BFoxClientConnection.StringInterest(sb.toString());
                sourceSession.getConnection().engageNoRetry((BFoxClientConnection.Interest)interest);
            }
            try {
                BOrd networkOrd = BOrd.make((String)"service:niagaraDriver:NiagaraNetwork");
                BNiagaraNetwork network = (BNiagaraNetwork)networkOrd.get((BObject)sourceSession);
                BOrd compOrd = BOrd.make((BOrd)network.getSlotPathOrd(), (String)"slot:localStation");
                BComponent comp = (BComponent)compOrd.get((BObject)network);
                comp.lease();
                InvokeActionCommand cmd = new InvokeActionCommand((BWidget)BSysDefNetwork.this, comp, this.action);
                CommandArtifact commandArtifact = cmd.doInvoke();
                return commandArtifact;
            }
            finally {
                if (interest != null) {
                    sourceSession.getConnection().disengage(interest);
                }
            }
        }
    }

    class ConnectCommand
    extends Command {
        public ConnectCommand() {
            super((BWidget)BSysDefNetwork.this, "Connect");
        }

        public CommandArtifact doInvoke() throws Exception {
            Node selected = (Node)BSysDefNetwork.this.tree.getSelection().getNode();
            if (selected != null) {
                BFoxSession sourceSession = BSysDefNetwork.this.sysdef.getFoxSession(BSysDefNetwork.this.sysdef.getStation(selected.station));
                BOrd ord = sourceSession.getNavOrd();
                BNiagaraWbShell shell = (BNiagaraWbShell)BSysDefNetwork.this.getWbShell();
                if (!shell.isAppletOrWebStart() && !sourceSession.isConnected()) {
                    try {
                        BISession session = BSysDefNetwork.this.network.getSession();
                        BICredentials credentials = (BICredentials)((BComplex)((BFoxSession)session).getCredentials()).newCopy(true);
                        shell.resolve(ord, credentials);
                    }
                    catch (Throwable e) {
                        if (e instanceof UnresolvedException) {
                            e = e.getCause();
                        }
                        String msg = lex.getText("mgr.connect.cannotConnect", new Object[]{selected.station, ord});
                        BDialog.error((BWidget)BSysDefNetwork.this, (String)BDialog.TITLE_ERROR, (Object)msg, (Throwable)e);
                        return null;
                    }
                    if (!sourceSession.isConnected()) {
                        throw new IllegalStateException();
                    }
                }
                if (sourceSession != null) {
                    shell.hyperlink(new HyperlinkInfo(BOrd.make((BOrd)ord, (String)"station:|slot:/")));
                }
            }
            return null;
        }
    }

    class FindCommand
    extends Command {
        public FindCommand() {
            super((BWidget)BSysDefNetwork.this, "Find");
        }

        public CommandArtifact doInvoke() throws Exception {
            String start = BSysDefNetwork.this.startStation.getText().length() == 0 ? ((Node)BSysDefNetwork.this.model.getRoot((int)(BSysDefNetwork.this.model.getRootCount() - 1))).station : BSysDefNetwork.this.startStation.getText();
            String[][] routes = BSysDefNetwork.this.sysdef.getRoutes(start, BSysDefNetwork.this.targetStation.getText());
            System.out.println("Routes from: " + start + " to " + BSysDefNetwork.this.targetStation.getText());
            for (int i = 0; i < routes.length; ++i) {
                System.out.println("  Route " + i + ": " + TextUtil.join((String[])routes[i], (char)','));
            }
            return null;
        }
    }
}

