/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSerial.npsdk;

import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platSerial.BSerialPort;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSerialPortNpsdk
extends BSerialPort {
    @Generated
    public static final Type TYPE = Sys.loadType(BSerialPortNpsdk.class);
    private static final String STATION_PREFIX = "station:";
    private int fd = 0;
    private BBaudRate baudrate = BSerialBaudRate.baud9600;
    private BSerialDataBits databits = BSerialDataBits.dataBits8;
    private BSerialStopBits stopbits = BSerialStopBits.stopBit1;
    private BSerialParity parity = BSerialParity.none;
    private BSerialFlowControlMode flowControl = BSerialFlowControlMode.none;
    private int rcvThreshold = -1;
    private int rcvTimeout = -1;
    private static final String TEMP_DIRECTORY = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getTempDirPath());

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSerialPortNpsdk() {
    }

    public BSerialPortNpsdk(String osName, int portIndex) {
        this.setOsPortName(osName);
        this.setPortIndex(portIndex);
        this.initOwner();
    }

    private String getLockFileName() {
        return TEMP_DIRECTORY + File.separatorChar + "niagara-ser" + this.getPortIndex() + ".owner";
    }

    public synchronized void lock(String owner) throws PortNotFoundException, PortDeniedException {
        this.checkOwner();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Attempting to lock " + this.getName() + " for owner " + owner);
        }
        if (!"none".equalsIgnoreCase(this.getOwner())) {
            throw new PortDeniedException("Unable to create lock for " + this.getName() + " for owner " + owner + ", already owned by " + this.getOwner());
        }
        this.setOwner(owner);
        this.locked = true;
        FileOutputStream fos = null;
        try {
            try {
                fos = AccessController.doPrivileged(() -> new FileOutputStream(this.getLockFileName()));
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            fos.write((STATION_PREFIX + owner).getBytes());
        }
        catch (Exception e) {
            this.setOwner("none");
            this.locked = false;
            throw new PortDeniedException("Unable to create lock for " + this.getName() + " for owner " + owner + ": " + e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getName() + " locked for owner " + owner);
        }
    }

    public synchronized void unlock() throws PortDeniedException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Attempting to unlock " + this.getName() + " as " + this.getOwner());
        }
        if (!this.locked) {
            throw new PortDeniedException("Unable to unlock " + this.getName() + ", " + this.getOwner() + " does not have the port lock");
        }
        File file = new File(this.getLockFileName());
        boolean result = AccessController.doPrivileged(file::delete);
        if (!result) {
            throw new PortDeniedException("Unable to unlock " + this.getName() + ", failed to delete " + this.getLockFileName());
        }
        this.setOwner("none");
        this.locked = false;
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getName() + " unlocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getLockFileOwner(String lockFileName) throws Exception {
        FileInputStream fis = null;
        try {
            try {
                fis = AccessController.doPrivileged(() -> new FileInputStream(lockFileName));
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            StringBuilder buf = new StringBuilder();
            int c = fis.read();
            while (c != -1) {
                buf.append((char)c);
                c = fis.read();
            }
            String owner = buf.toString().trim();
            owner = TextUtil.replace((String)owner, (String)"\n", (String)"");
            String string = owner = TextUtil.replace((String)owner, (String)"\r", (String)"");
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void initOwner() {
        try {
            String owner = this.getLockFileOwner(this.getLockFileName());
            if (owner.startsWith(STATION_PREFIX)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Cleaning up old lock file " + this.getLockFileName() + ", old owner: " + owner);
                }
                AccessController.doPrivileged(() -> new File(this.getLockFileName()).delete());
                this.setOwner("none");
                this.locked = false;
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Can not initialize owner of " + this.getOsPortName() + ", port already owned by " + owner + ", lock file " + this.getLockFileName());
                }
                this.setOwner(owner);
                this.locked = true;
            }
            return;
        }
        catch (FileNotFoundException owner) {
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problem reading lock file for " + this.getOsPortName(), e);
        }
        this.locked = false;
        this.setOwner("none");
    }

    public synchronized void checkOwner() {
        try {
            String owner = this.getLockFileOwner(this.getLockFileName());
            if (owner.startsWith(STATION_PREFIX)) {
                owner = owner.substring(STATION_PREFIX.length());
            }
            this.locked = true;
            this.setOwner(owner);
            return;
        }
        catch (FileNotFoundException owner) {
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problem reading lock file " + this.getLockFileName() + " for " + this.getName() + " defaulting to no ownership", e);
        }
        this.locked = false;
        this.setOwner("none");
    }

    protected void openPort() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Opening " + this.getOsPortName() + "...");
        }
        this.fd = this.open0(this.getOsPortName());
        if (this.fd <= 0) {
            log.severe("Failed to open " + this.getOsPortName());
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Port " + this.getOsPortName() + " is open, file descriptor is " + this.fd);
        }
    }

    protected void closePort() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Closing " + this.getOsPortName() + ", file descriptor is " + this.fd + "...");
        }
        if (this.fd > 0) {
            this.close0(this.fd);
            this.fd = 0;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Port " + this.getOsPortName() + " is closed");
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Can not close port " + this.getOsPortName() + " invalid file descriptor");
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.fd <= 0) {
            throw new IOException("Can not obtain input stream, invalid file descriptor " + this.fd);
        }
        return new SerialInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.fd <= 0) {
            throw new IOException("Can not obtain output stream, invalid file descriptor " + this.fd);
        }
        return new SerialOutputStream();
    }

    public void enableReceiveThreshold(int i) throws UnsupportedOperationException {
        if (i <= 0) {
            throw new UnsupportedOperationException("Threshold must be >= 1");
        }
        this.rcvThreshold = i;
    }

    public void disableReceiveThreshold() {
        this.rcvThreshold = -1;
    }

    public boolean isReceiveThresholdEnabled() {
        return this.rcvThreshold >= 0;
    }

    public int getReceiveThreshold() {
        return this.rcvThreshold;
    }

    public void enableReceiveTimeout(int i) throws UnsupportedOperationException {
        this.rcvTimeout = i;
    }

    public void disableReceiveTimeout() {
        this.rcvTimeout = -1;
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.rcvTimeout >= 0;
    }

    public int getReceiveTimeout() {
        return this.rcvTimeout;
    }

    public BBaudRate getBaudRate() {
        return this.baudrate;
    }

    public BSerialDataBits getDataBits() {
        return this.databits;
    }

    public BSerialStopBits getStopBits() {
        return this.stopbits;
    }

    public BSerialParity getParity() {
        return this.parity;
    }

    public void sendBreak(int i) {
        if (this.fd <= 0) {
            return;
        }
        this.sendBreak0(this.fd, i);
    }

    public void setFlowControlMode(BSerialFlowControlMode mode) throws UnsupportedOperationException {
        if (this.fd <= 0) {
            return;
        }
        this.setFlowControlMode0(this.fd, mode.getBits());
        this.flowControl = mode;
    }

    public BSerialFlowControlMode getFlowControlMode() {
        return this.flowControl;
    }

    public void setSerialPortParams(BBaudRate baudRate, BSerialDataBits dataBits, BSerialStopBits stopBits, BSerialParity parity) throws UnsupportedOperationException {
        if (this.fd <= 0) {
            return;
        }
        this.setSerialPortParams0(this.fd, baudRate.getOrdinal(), dataBits.getOrdinal(), stopBits.getOrdinal(), parity.getOrdinal());
        this.baudrate = baudRate;
        this.databits = dataBits;
        this.stopbits = stopBits;
        this.parity = parity;
    }

    public void setDTR(boolean flag) {
        if (this.fd <= 0) {
            return;
        }
        this.setDTR0(this.fd, flag);
    }

    public boolean isDTR() {
        return this.fd > 0 && this.isDTR0(this.fd);
    }

    public void setRTS(boolean flag) {
        if (this.fd <= 0) {
            return;
        }
        this.setRTS0(this.fd, flag);
    }

    public boolean isRTS() {
        return this.fd > 0 && this.isRTS0(this.fd);
    }

    public boolean isCTS() {
        return this.fd > 0 && this.isCTS0(this.fd);
    }

    public boolean isDSR() {
        return this.fd > 0 && this.isDSR0(this.fd);
    }

    public boolean isRI() {
        return this.fd > 0 && this.isRI0(this.fd);
    }

    public boolean isCD() {
        return this.fd > 0 && this.isCD0(this.fd);
    }

    private native int open0(String var1);

    private native int available0(int var1);

    private native void close0(int var1);

    private native int read0(int var1, int var2);

    private native int read0(int var1, int var2, int var3, byte[] var4, int var5, int var6);

    private native void write0(int var1, int var2);

    private native void write0(int var1, byte[] var2, int var3, int var4);

    private native void flush0(int var1);

    private native void setSerialPortParams0(int var1, int var2, int var3, int var4, int var5);

    private native boolean isCD0(int var1);

    private native boolean isCTS0(int var1);

    private native boolean isDSR0(int var1);

    private native boolean isDTR0(int var1);

    private native boolean isRI0(int var1);

    private native boolean isRTS0(int var1);

    private native void setFlowControlMode0(int var1, int var2);

    private native void setRTS0(int var1, boolean var2);

    private native void setDTR0(int var1, boolean var2);

    private native void sendBreak0(int var1, int var2);

    class SerialOutputStream
    extends OutputStream {
        boolean closed = false;

        SerialOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Output stream has been closed.");
            }
            BSerialPortNpsdk.this.write0(BSerialPortNpsdk.this.fd, b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            if (this.closed) {
                throw new IOException("Output stream has been closed.");
            }
            if (length + offset > b.length) {
                throw new IOException("write length(" + length + ") + offset(" + offset + ") exceeds array length(" + b.length + ")");
            }
            BSerialPortNpsdk.this.write0(BSerialPortNpsdk.this.fd, b, offset, length);
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Output stream has been closed.");
            }
            BSerialPortNpsdk.this.flush0(BSerialPortNpsdk.this.fd);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }
    }

    class SerialInputStream
    extends InputStream {
        boolean closed = false;

        SerialInputStream() {
        }

        @Override
        public int available() throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed.");
            }
            int bytes = BSerialPortNpsdk.this.available0(BSerialPortNpsdk.this.fd);
            if (bytes < 0) {
                throw new IOException("Unable to read available bytes");
            }
            return bytes;
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed.");
            }
            return BSerialPortNpsdk.this.read0(BSerialPortNpsdk.this.fd, BSerialPortNpsdk.this.rcvTimeout);
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }

        @Override
        public int read(byte[] bytes, int offset, int length) throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed.");
            }
            if (length + offset > bytes.length) {
                throw new IOException("read length(" + length + ") + offset(" + offset + ") exceeds array length(" + bytes.length + ")");
            }
            return BSerialPortNpsdk.this.read0(BSerialPortNpsdk.this.fd, BSerialPortNpsdk.this.rcvTimeout, BSerialPortNpsdk.this.rcvThreshold, bytes, offset, length);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }
    }
}

