/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import javax.baja.agent.AgentInfo;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class MgrTypeInfo {
    public static MgrTypeInfo[] makeArray(TypeInfo[] typeInfo) {
        MgrTypeInfo[] r = new MgrTypeInfo[typeInfo.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = MgrTypeInfo.make(typeInfo[i]);
        }
        return MgrTypeInfo.sort(r);
    }

    public static MgrTypeInfo[] makeArray(TypeInfo baseType) {
        return MgrTypeInfo.makeArray(Sys.getRegistry().getConcreteTypes(baseType));
    }

    public static MgrTypeInfo[] makeArray(Type baseType) {
        return MgrTypeInfo.makeArray(baseType.getTypeInfo());
    }

    public static MgrTypeInfo[] makeArray(AgentInfo[] agentInfo) {
        MgrTypeInfo[] r = new MgrTypeInfo[agentInfo.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = MgrTypeInfo.make(agentInfo[i]);
        }
        return MgrTypeInfo.sort(r);
    }

    public static MgrTypeInfo make(TypeInfo typeInfo) {
        return new TypeInfoImpl(typeInfo);
    }

    public static MgrTypeInfo make(AgentInfo agentInfo) {
        return new AgentInfoImpl(agentInfo);
    }

    public static MgrTypeInfo make(Type type) {
        return MgrTypeInfo.make(type.getTypeInfo());
    }

    public static MgrTypeInfo make(BComponent proto) {
        return new ProtoImpl(proto);
    }

    public abstract String getDisplayName();

    public abstract BImage getIcon();

    public abstract BComponent newInstance() throws Exception;

    public abstract boolean isMatchable(BComponent var1);

    public boolean equals(Object o) {
        if (o instanceof MgrTypeInfo) {
            MgrTypeInfo x = (MgrTypeInfo)o;
            return this.getCompareString().equals(x.getCompareString());
        }
        return false;
    }

    protected String getCompareString() {
        return this.getDisplayName();
    }

    public String toSlotName() {
        return SlotPath.escape((String)TextUtil.replace((String)this.getDisplayName(), (String)" ", (String)""));
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static void markDuplicates(MgrTypeInfo[] types) {
        int i;
        if (types == null || types.length == 0) {
            return;
        }
        String[] tags = new String[types.length];
        for (i = 0; i < tags.length; ++i) {
            tags[i] = types[i].getDisplayName();
        }
        for (i = 0; i < tags.length; ++i) {
            String tnam = tags[i];
            for (int n = i + 1; n < tags.length; ++n) {
                if (!tnam.equals(tags[n])) continue;
                if (types[i] instanceof TypeInfoImpl) {
                    ((TypeInfoImpl)types[i]).duplicate = true;
                }
                if (!(types[n] instanceof TypeInfoImpl)) continue;
                ((TypeInfoImpl)types[n]).duplicate = true;
            }
        }
    }

    static MgrTypeInfo[] sort(MgrTypeInfo[] v) {
        if (v.length == 0) {
            return v;
        }
        int n = v.length;
        String[] k = new String[n];
        for (int i = 0; i < n; ++i) {
            k[i] = v[i].getDisplayName();
        }
        for (int incr = n / 2; incr >= 1; incr /= 2) {
            for (int i = incr; i < n; ++i) {
                String tempKey = k[i];
                MgrTypeInfo tempValue = v[i];
                for (int j = i; j >= incr && tempKey.compareTo(k[j - incr]) < 0; j -= incr) {
                    k[j] = k[j - incr];
                    v[j] = v[j - incr];
                }
                k[j] = tempKey;
                v[j] = tempValue;
            }
        }
        return v;
    }

    static class ProtoImpl
    extends MgrTypeInfo {
        BComponent proto;

        ProtoImpl(BComponent proto) {
            this.proto = proto;
        }

        @Override
        public String getDisplayName() {
            return this.proto.getType().getDisplayName(null);
        }

        @Override
        public BImage getIcon() {
            return BImage.make((BIcon)this.proto.getIcon());
        }

        @Override
        public BComponent newInstance() {
            return (BComponent)this.proto.newCopy(true);
        }

        @Override
        public boolean isMatchable(BComponent db) {
            return db.getType().is(this.proto.getType());
        }

        @Override
        protected String getCompareString() {
            return this.proto.getType().getTypeInfo().toString();
        }
    }

    static class AgentInfoImpl
    extends MgrTypeInfo {
        AgentInfo ai;

        AgentInfoImpl(AgentInfo ai) {
            this.ai = ai;
        }

        @Override
        public String getDisplayName() {
            return this.ai.getDisplayName(null);
        }

        @Override
        public BImage getIcon() {
            return BImage.make((BIcon)this.ai.getIcon(null));
        }

        @Override
        public BComponent newInstance() {
            return (BComponent)this.ai.getInstance();
        }

        @Override
        public boolean isMatchable(BComponent db) {
            return db.getType().is(this.ai.getAgentType());
        }

        @Override
        protected String getCompareString() {
            return this.ai.getAgentType().toString();
        }
    }

    static class TypeInfoImpl
    extends MgrTypeInfo {
        boolean duplicate = false;
        TypeInfo ti;

        TypeInfoImpl(TypeInfo ti) {
            this.ti = ti;
        }

        @Override
        public String toSlotName() {
            return SlotPath.escape((String)TextUtil.replace((String)this.ti.getDisplayName(null), (String)" ", (String)""));
        }

        @Override
        public String getDisplayName() {
            if (!this.duplicate) {
                return this.ti.getDisplayName(null);
            }
            return this.ti.getDisplayName(null) + "(" + this.ti.getModuleName() + ")";
        }

        @Override
        public BImage getIcon() {
            return BImage.make((BIcon)this.ti.getIcon(null));
        }

        @Override
        public BComponent newInstance() {
            return (BComponent)this.ti.getInstance();
        }

        @Override
        public boolean isMatchable(BComponent db) {
            return db.getType().is(this.ti);
        }

        @Override
        protected String getCompareString() {
            return this.ti.toString();
        }
    }
}

