/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.commands;

import com.tridium.workbench.util.BRelatePad;
import javax.baja.nre.util.Array;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.tag.Id;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;

public class RelateCommand
extends Command {
    private static Lexicon bajaLex = Lexicon.make((String)"baja");
    private static final Lexicon lex = Lexicon.make(RelateCommand.class);
    BComponent[] sources;
    BComponent[] targets;
    String relateId;

    public RelateCommand(BWidgetShell shell, BComponent endpoint, BComponent target, String relateId) {
        super((BWidget)shell, "relate");
        this.sources = new BComponent[]{endpoint};
        this.targets = new BComponent[]{target};
        this.relateId = relateId;
    }

    public RelateCommand(BWidgetShell shell, BComponent[] endpoints, BComponent[] targets) {
        super((BWidget)shell, "relate");
        this.sources = endpoints;
        this.targets = targets;
    }

    public CommandArtifact doInvoke() throws Exception {
        if (this.relateId == null || this.relateId == "") {
            try {
                if (!this.queryUser()) {
                    return null;
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("relateCommand.noTagService.error.message"));
                return null;
            }
        }
        Array relateArray = new Array(RelateInfo.class, this.sources.length * this.targets.length);
        for (int i = 0; i < this.sources.length; ++i) {
            for (int j = 0; j < this.targets.length; ++j) {
                BRelation addRelation = this.sources[i].makeRelation(Id.newId((String)this.relateId), this.targets[j], null);
                if (this.hasRelation(this.sources[i], addRelation)) {
                    BDialog.error((BWidget)this.getOwner(), (Object)bajaLex.getText("relationcheck.relationAlreadyExists"));
                    continue;
                }
                relateArray.add((Object)new RelateInfo(this.sources[i], this.sources[i].makeRelation(Id.newId((String)this.relateId), this.targets[j], null)));
            }
        }
        Artifact art = new Artifact((RelateInfo[])relateArray.trim());
        art.redo();
        return art;
    }

    private boolean hasRelation(BComponent target, BRelation relation) {
        for (BRelation bRelation : (BRelation[])target.getChildren(BRelation.class)) {
            if (!bRelation.getRelationId().equals(relation.getRelationId()) || !bRelation.getEndpointOrd().equals((Object)relation.getEndpointOrd())) continue;
            return true;
        }
        return false;
    }

    private boolean queryUser() {
        BRelatePad pad = new BRelatePad(this.sources, this.targets);
        if (pad.openInDialog(this.getOwner())) {
            this.relateId = pad.getRelationId();
            return true;
        }
        return false;
    }

    private static class RelateInfo {
        BComponent source;
        BRelation relation;
        String slotName = "";

        RelateInfo(BComponent source, BRelation relation) {
            this.source = source;
            this.relation = relation;
        }

        void add() {
            this.source.add("relation?", (BValue)this.relation);
        }

        void remove(Context cx) {
            this.source.remove(this.slotName, cx);
        }
    }

    static class Artifact
    implements CommandArtifact {
        RelateInfo[] relations;

        Artifact(RelateInfo[] relations) {
            this.relations = relations;
        }

        public void redo() throws Exception {
            for (int i = 0; i < this.relations.length; ++i) {
                this.relations[i].add();
            }
        }

        public void undo() throws Exception {
            if (this.relations.length == 0) {
                return;
            }
            Context tx = Transaction.start((BComponent)this.relations[0].source, null);
            for (int i = 0; i < this.relations.length; ++i) {
                this.relations[i].remove(tx);
            }
            Transaction.end((BComponent)this.relations[0].source, (Context)tx);
        }
    }
}

