/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.commands;

import com.tridium.util.HtmlUtils;
import com.tridium.workbench.web.browser.BWebBrowser;
import javax.baja.gx.BImage;
import javax.baja.gx.BSize;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class HtmlHelpCommand
extends Command {
    private final BWidget parent;
    private final String title;
    private final String helpText;
    private final BSize size;
    private final Context context;
    private static final Lexicon LEX = UiLexicon.bajaui();
    private static final BImage ICON = BImage.make((BIcon)BIcon.std((String)"questionMark.png"));
    private static final String HELP_LABEL = LEX.getText("menu.help.label");

    public HtmlHelpCommand(BWidget parent, String title, String helpText, BSize size, Context context) {
        this(parent, null, title, helpText, size, context);
    }

    public HtmlHelpCommand(BWidget parent, String label, String title, String helpText, BSize size, Context context) {
        super(parent, label);
        this.icon = ICON;
        this.parent = parent;
        this.title = title;
        this.helpText = HtmlUtils.getLimitedHtml((String)helpText);
        this.size = size;
        this.context = context;
    }

    public void withDefaultLabel() {
        this.label = HELP_LABEL;
    }

    public CommandArtifact doInvoke() throws Exception {
        BWebBrowser browser = new BWebBrowser();
        browser.load((BObject)BString.make((String)HtmlHelpCommand.formatHtmlDescription(this.helpText)), this.context);
        BConstrainedPane cons = new BConstrainedPane((BWidget)browser);
        cons.setMinSize(this.size.width(), this.size.height());
        cons.setMaxSize(this.size.width(), this.size.height());
        BDialog.open((BWidget)this.parent, (String)this.title, (Object)cons, (int)1);
        return null;
    }

    private static String formatHtmlDescription(String description) {
        return String.format("<html><head><link rel='stylesheet' href='module://bajaui/doc/style.css' type='text/css'/></head><body>%s</body></html>", description);
    }
}

