/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.celleditor;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.celleditor.BWbCellEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraAction(name="buttonMouseEvent", parameterType="BMouseEvent", defaultValue="new BMouseEvent()")
public abstract class BButtonCE
extends BWbCellEditor {
    @Generated
    public static final Action buttonMouseEvent = BButtonCE.newAction((int)0, (BValue)new BMouseEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BButtonCE.class);
    private static Lexicon lexicon = Lexicon.make((String)"wbutil");
    private static BFont FONT = Theme.widget().getTextFont();
    private BButton button = new BButton();
    private boolean isPressed = false;
    private RectGeom textClip;

    @Generated
    public void buttonMouseEvent(BMouseEvent parameter) {
        this.invoke(buttonMouseEvent, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BButtonCE() {
        this.add("btn", (BValue)this.button);
        this.linkTo("lk1", (BComponent)this.button, (Slot)BButton.mouseEvent, (Slot)buttonMouseEvent);
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.button.setEnabled(!readonly);
        this.relayout();
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        return this.value;
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintButton(g);
        if (this.value != null) {
            this.drawString(g, this.value.toString());
        }
    }

    @Override
    public void doLayout(BWidget[] children) {
        double w = this.getWidth();
        double h = this.getHeight();
        if (this.isReadonly()) {
            this.button.setBounds(0.0, 0.0, 0.0, 0.0);
            this.textClip = new RectGeom(0.0, 0.0, w - 1.0, h);
        } else {
            this.button.setBounds(w - h - 2.0, 2.0, h, h - 4.0);
            this.textClip = new RectGeom(0.0, 0.0, w - h - 5.0, h);
        }
    }

    public final void mousePressed(BMouseEvent event) {
        this.requestFocus();
        this.cellSelected();
        if (this.button.isEnabled()) {
            if (event.isButton1Down()) {
                this.buttonPressed();
            } else if (event.isButton3Down()) {
                this.cellPopup(event);
            }
        }
    }

    public final void buttonPressed() {
        if (this.isReadonly()) {
            return;
        }
        try {
            BObject obj = this.dialog();
            if (obj != null) {
                this.value = obj;
                this.setModified();
            }
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)BButtonCE.text("buttonCE.dialogError"), (Throwable)e);
        }
    }

    protected final void drawString(Graphics g, String text) {
        g.push();
        try {
            g.clip((IGeom)this.textClip);
            g.setBrush(Theme.widget().getTextBrush());
            g.setFont(FONT);
            g.drawString(text, 3.0, FONT.getAscent() + 3.0);
        }
        finally {
            g.pop();
        }
    }

    protected void paintButton(Graphics g) {
        if (this.isReadonly()) {
            return;
        }
        this.paintChild(g, (BWidget)this.button);
        double x = this.button.getX() + 8.0;
        double y = this.button.getY() + 15.0;
        if (this.isPressed) {
            Point offset = new Point(1.0, 1.0);
            x += offset.x;
            y += offset.y;
        }
        if (this.button.getEnabled()) {
            g.setBrush(Theme.widget().getControlForeground());
        } else {
            g.setBrush(Theme.widget().getControlShadow());
        }
        for (int i = 0; i < 3; ++i) {
            g.fillRect(x + (double)(i * 4), y, 2.0, 2.0);
        }
    }

    protected BObject dialog() throws Exception {
        return BWbFieldEditor.dialog(this, this.getPropertyName(), this.value, this.getCurrentContext());
    }

    public void doButtonMouseEvent(BMouseEvent event) {
        if (event.getId() == 501) {
            this.mousePressed(event);
            this.isPressed = true;
        } else if (event.getId() == 502) {
            this.isPressed = false;
        }
    }

    public static String text(String s) {
        return lexicon.getText(s);
    }
}

