/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser.pdf;

import com.tridium.pdf.BIPdfAsyncWidget;
import com.tridium.ui.UiEnv;
import com.tridium.workbench.web.browser.BWebWidget;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.baja.gx.Graphics;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

@NiagaraType(agent={@AgentOn(types={"workbench:WebWidget"})})
public final class BPdfWebWidget
extends BWidget
implements BIPdfAsyncWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BPdfWebWidget.class);
    private BWebWidget webWidget;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void fromWidget(BWidget widget, PdfOp op) {
        this.webWidget = (BWebWidget)widget;
        BWebWidget temp = (BWebWidget)this.webWidget.newCopy(true);
        this.webWidget.getParent().asComponent().set(this.webWidget.getPropertyInParent(), (BValue)temp);
        this.webWidget.setCachedOrdTarget((OrdTarget)op);
        this.setLayout(widget.getLayout());
    }

    public CompletableFuture<Void> initializeAsync() {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        UiEnv.get().invokeWaitAndProcess(() -> {
            this.webWidget.setSize(this.getWidth(), this.getHeight());
            if (this.webWidget.get("forceInitialize") == null) {
                this.webWidget.add("forceInitialize", (BValue)BBoolean.TRUE);
            }
            if (this.webWidget.get("exporting") == null) {
                this.webWidget.add("exporting", (BValue)BBoolean.TRUE, 0x40000007);
            }
            this.webWidget.setCloseOnStop(true);
            BObject value = this.webWidget.getCurrentValue();
            if (value != null) {
                this.webWidget.loadValue(value);
            }
            this.webWidget.start();
            this.webWidget.relayout();
            this.webWidget.layout();
            for (BWidget w : this.webWidget.getChildWidgets()) {
                w.relayout();
                w.layout();
            }
            Optional<CompletableFuture<Void>> loaded = this.webWidget.getLoadedFuture();
            if (loaded.isPresent()) {
                loaded.get().whenComplete((arg, err) -> {
                    if (err != null) {
                        completableFuture.completeExceptionally((Throwable)err);
                    } else {
                        this.webWidget.relayout();
                        this.webWidget.layout();
                        completableFuture.complete(null);
                    }
                });
            } else {
                completableFuture.cancel(false);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Void> cleanupAsync() {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        UiEnv.get().invokeWaitAndProcess(() -> {
            this.webWidget.deactivated();
            this.webWidget.stop();
            completableFuture.complete(null);
        });
        return completableFuture;
    }

    public void paint(Graphics g) {
        UiEnv.get().invokeWaitAndProcess(() -> this.webWidget.paint(g));
    }

    public void computePreferredSize() {
        UiEnv.get().invokeWaitAndProcess(() -> {
            this.webWidget.computePreferredSize();
            this.setPreferredSize(this.webWidget.getPreferredWidth(), this.webWidget.getPreferredHeight());
        });
    }

    public void doLayout(BWidget[] children) {
        UiEnv.get().invokeWaitAndProcess(() -> this.webWidget.setBounds(0.0, 0.0, this.getWidth(), this.getHeight()));
    }

    public BWebWidget getWebWidget() {
        return this.webWidget;
    }
}

