/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser.fx.interop;

import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.fx.BFxWebBrowserImpl;
import com.tridium.workbench.web.browser.interop.ConsoleEventHandler;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import netscape.javascript.JSObject;

public class Console {
    private final Set<ConsoleEventHandler> consoleEventHandlers = new HashSet<ConsoleEventHandler>();
    private static final boolean WEBBROWSER_CONSOLE = AccessController.doPrivileged(() -> Boolean.getBoolean("webBrowser.console"));

    private Console() {
    }

    public static Console init(BFxWebBrowserImpl impl) {
        Console c = new Console();
        c.bind(impl);
        return c;
    }

    private void bind(BFxWebBrowserImpl impl) {
        impl.registerConsumer("console_log", o -> this.onConsoleEvent(new FxConsoleEvent(o, false)));
        impl.registerConsumer("console_error", o -> this.onConsoleEvent(new FxConsoleEvent(o, true)));
        impl.executeScriptAsync("(function () {  window.console = {    log: function (msg) {       window.console_log(msg);    },    error: function (msg) {       window.console_error(msg);    }  };}());");
    }

    public void registerConsoleEventHandler(ConsoleEventHandler eventHandler) {
        this.consoleEventHandlers.add(eventHandler);
    }

    public void removeConsoleEventHandler(ConsoleEventHandler eventHandler) {
        this.consoleEventHandlers.remove(eventHandler);
    }

    private void onConsoleEvent(ConsoleEventHandler.ConsoleEvent event) {
        if (WEBBROWSER_CONSOLE) {
            Level level = event.isError() ? Level.SEVERE : Level.INFO;
            BWebBrowser.consoleLog.log(level, event.getMessage());
        }
        for (ConsoleEventHandler eventHandler : this.consoleEventHandlers) {
            eventHandler.onEvent(event);
        }
    }

    private static String jsObjectToString(Object o) {
        if (o instanceof JSObject) {
            JSObject js = (JSObject)o;
            if (((Boolean)js.eval("this instanceof Error")).booleanValue()) {
                return Console.jsErrorToString(js);
            }
            return Console.jsonStringify(js);
        }
        return o == null ? "null" : o.toString();
    }

    private static String jsErrorToString(JSObject error) {
        Object message = error.getMember("message");
        Object stack = error.getMember("stack");
        if (!Console.isDefined(stack)) {
            stack = error.getMember("javaStackTrace");
        }
        if (Console.isDefined(stack)) {
            return message + "\nStack trace: " + stack;
        }
        return Console.jsonStringify(error);
    }

    private static String jsonStringify(JSObject js) {
        return js.eval("JSON.stringify(this, null, 2)").toString();
    }

    private static boolean isDefined(Object o) {
        return o != null && !"undefined".equals(o);
    }

    private static class FxConsoleEvent
    implements ConsoleEventHandler.ConsoleEvent {
        private final String message;
        private final boolean isError;

        private FxConsoleEvent(Object jsObject, boolean isError) {
            this.message = Console.jsObjectToString(jsObject);
            this.isError = isError;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public boolean isError() {
            return this.isError;
        }
    }
}

