/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.sys.Nre;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.workbench.CannotSaveException;

public class FloatingPointHelper {
    private final boolean isFloat;
    private boolean forceSign;
    private final DecimalFormat format;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private BUnit realUnits;
    private BUnit displayUnits;
    private static final long MAX_LONG_PREC = 0x20000000000000L;
    private static final HashMap<String, DecimalFormat> formatters = new HashMap();
    private final DecimalFormat fSN = new DecimalFormat("0.###############E0");

    public static FloatingPointHelper makeFor(BObject number, Context cx) {
        if (number.getType().is(BDouble.TYPE)) {
            return FloatingPointHelper.makeDouble(cx);
        }
        if (number.getType().is(BFloat.TYPE)) {
            return FloatingPointHelper.makeFloat(cx);
        }
        throw new IllegalArgumentException("Only supports BDouble/BFloat");
    }

    public static FloatingPointHelper makeFloat(Context cx) {
        return new FloatingPointHelper(cx, true);
    }

    public static FloatingPointHelper makeDouble(Context cx) {
        return new FloatingPointHelper(cx, false);
    }

    private FloatingPointHelper(Context cx, boolean isFloat) {
        this.isFloat = isFloat;
        int convert = Nre.unitConversion;
        int prec = 2;
        boolean showSeparators = false;
        if (cx != null) {
            BNumber maxFacet;
            BFacets facets = cx.getFacets();
            BNumber minFacet = (BNumber)cx.getFacet("min");
            if (minFacet != null) {
                double d = this.min = isFloat ? (double)minFacet.getFloat() : minFacet.getDouble();
            }
            if ((maxFacet = (BNumber)cx.getFacet("max")) != null) {
                this.max = isFloat ? (double)maxFacet.getFloat() : maxFacet.getDouble();
            }
            this.realUnits = (BUnit)facets.get("units");
            if (this.realUnits != null && this.realUnits.isNull()) {
                this.realUnits = null;
            }
            this.forceSign = facets.getb("forceSign", this.forceSign);
            convert = facets.geti("unitConversion", convert);
            prec = facets.geti("precision", prec);
            showSeparators = facets.getb("showSeparators", showSeparators);
        }
        this.format = FloatingPointHelper.getFormat(prec, showSeparators);
        this.displayUnits = this.realUnits;
        if (convert != 0 && this.realUnits != null) {
            BUnitConversion c = BUnitConversion.make((int)convert);
            this.displayUnits = c.getDesiredUnit(this.realUnits);
        }
    }

    public double parse(String text) throws CannotSaveException {
        double d = this.decodeDouble(text);
        return this.isFloat ? (double)((float)d) : d;
    }

    public double parseAndValidate(String text) throws CannotSaveException {
        return this.validate(this.parse(text));
    }

    private double decodeDouble(String text) throws CannotSaveException {
        double v;
        try {
            text = TextUtil.toLowerCase((String)text);
            if ("-inf".equals(text)) {
                v = Double.NEGATIVE_INFINITY;
            } else if ("+inf".equals(text)) {
                v = Double.POSITIVE_INFINITY;
            } else if ("nan".equals(text)) {
                v = Double.NaN;
            } else {
                String stripped = text.startsWith("+") ? text.substring(1) : text;
                ParsePosition pos = new ParsePosition(0);
                v = stripped.indexOf(101) != -1 ? this.fSN.parse(TextUtil.toUpperCase((String)stripped), pos).doubleValue() : this.format.parse(stripped, pos).doubleValue();
                if (pos.getIndex() != stripped.length()) {
                    throw new CannotSaveException("Invalid format: " + text);
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new CannotSaveException("Invalid format: " + nfe.getMessage());
        }
        catch (Exception e) {
            throw new CannotSaveException("Invalid format: " + text);
        }
        v = this.toRealUnits(v);
        return v;
    }

    public String format(double d) {
        String prefix;
        if (d == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "+inf";
        }
        if (Double.isNaN(d)) {
            return "nan";
        }
        d = this.toDisplayUnits(d);
        String string = prefix = this.forceSign && d > 0.0 ? "+" : "";
        if (Math.IEEEremainder(d, 1.0) == 0.0) {
            if ((long)Math.abs(d) >= 0x20000000000000L) {
                return prefix + this.fSN.format(d);
            }
            return prefix + this.format.format(d);
        }
        return d == 0.0 ? this.format.format(d) : prefix + this.format.format(d);
    }

    public double validate(double d) throws CannotSaveException {
        this.validateRange(d);
        return d;
    }

    private void validateRange(double d) throws CannotSaveException {
        if (d < this.min) {
            throw new CannotSaveException(this.format(d) + " < " + this.format(this.min) + ' ' + this.getRangeDisplay());
        }
        if (d > this.max) {
            throw new CannotSaveException(this.format(d) + " > " + this.format(this.max) + ' ' + this.getRangeDisplay());
        }
    }

    private static DecimalFormat getFormat(int precision, boolean showSeparators) {
        String key = String.valueOf(precision) + showSeparators;
        DecimalFormat formatter = formatters.get(key);
        if (formatter == null) {
            StringBuilder pattern = new StringBuilder(16);
            pattern.append(showSeparators ? "#,##0" : "#0");
            if (precision > 0) {
                pattern.append('.');
                for (int i = 0; i < precision; ++i) {
                    pattern.append('0');
                }
            }
            formatter = new DecimalFormat(pattern.toString());
            formatters.put(key, formatter);
        }
        return formatter;
    }

    public String getRangeDisplay() {
        if (this.min == Double.NEGATIVE_INFINITY && this.max == Double.POSITIVE_INFINITY) {
            return "";
        }
        return '[' + this.format(this.min) + " - " + this.format(this.max) + ']';
    }

    public BUnit getDisplayUnits() {
        return this.displayUnits;
    }

    private double toRealUnits(double d) {
        if (this.displayUnits == this.realUnits) {
            return d;
        }
        return this.displayUnits.convertTo(this.realUnits, d);
    }

    private double toDisplayUnits(double d) {
        if (this.displayUnits == this.realUnits) {
            return d;
        }
        return this.realUnits.convertTo(this.displayUnits, d);
    }
}

