/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import java.util.ArrayList;
import java.util.Comparator;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BWsAnnotation;

@NiagaraType
public class BReorderPad
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BReorderPad.class);
    Comparator<BWsAnnotation> ByPosComparator = new Comparator<BWsAnnotation>(){

        @Override
        public int compare(BWsAnnotation obj1, BWsAnnotation obj2) {
            BWsAnnotation a = obj1;
            BWsAnnotation b = obj2;
            if (!BReorderPad.this.byPosAscending) {
                a = obj2;
                b = obj1;
            }
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a.p < b.p) {
                return -1;
            }
            if (a.p > b.p) {
                return 1;
            }
            if (a.q < b.q) {
                return -1;
            }
            if (a.q > b.q) {
                return 1;
            }
            return 0;
        }
    };
    static final BImage defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    BIPropertyContainer target;
    PropertyFilter filter;
    Row[] oldOrder;
    Row[] newOrder;
    BTable table;
    Model model;
    BButton up;
    BButton down;
    BButton byName;
    BButton byType;
    BButton byPos;
    BButton reset;
    boolean byNameAscending;
    boolean byTypeAscending;
    boolean byPosAscending;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BReorderPad() {
        throw new IllegalStateException();
    }

    public BReorderPad(BIPropertyContainer target) {
        this(target, new PropertyFilter());
    }

    public BReorderPad(BIPropertyContainer target, PropertyFilter filter) {
        this.target = target;
        this.filter = filter;
        this.oldOrder = this.getDynamicRows();
        this.newOrder = new Row[this.oldOrder.length];
        System.arraycopy(this.oldOrder, 0, this.newOrder, 0, this.newOrder.length);
        this.model = new Model();
        this.table = new BTable((TableModel)this.model);
        this.table.setHeaderVisible(false);
        this.table.setMultipleSelection(true);
        this.table.setHgridVisible(false);
        BGridPane buttons = new BGridPane(1);
        buttons.setValign(BValign.top);
        buttons.setColumnAlign(BHalign.fill);
        this.up = BReorderPad.newButton(new UpCommand((BWidget)this));
        buttons.add("up", (BValue)this.up);
        this.down = BReorderPad.newButton(new DownCommand((BWidget)this));
        buttons.add("down", (BValue)this.down);
        this.byName = BReorderPad.newButton(new ByNameCommand((BWidget)this));
        buttons.add("byName", (BValue)this.byName);
        this.byType = BReorderPad.newButton(new ByTypeCommand((BWidget)this));
        buttons.add("byType", (BValue)this.byType);
        this.byPos = BReorderPad.newButton(new ByPosCommand((BWidget)this));
        buttons.add("byPos", (BValue)this.byPos);
        this.reset = BReorderPad.newButton(new ResetCommand((BWidget)this));
        buttons.add("reset", (BValue)this.reset);
        if (this.oldOrder.length == 0) {
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            this.byName.setEnabled(false);
            this.byType.setEnabled(false);
            this.byPos.setEnabled(false);
            this.reset.setEnabled(false);
        } else {
            this.table.getSelection().select(0);
        }
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        edge.setRight((BWidget)new BBorderPane((BWidget)buttons, 0.0, 0.0, 0.0, 10.0));
        this.setCenter((BWidget)new BBorderPane((BWidget)edge));
    }

    Row[] getDynamicRows() {
        ArrayList<Row> v = new ArrayList<Row>();
        this.target.loadSlots();
        SlotCursor c = this.target.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (p.isFrozen() || !this.filter.include(this.target, p)) continue;
            v.add(new Row(this.target, p, (BObject)c.get()));
        }
        return v.toArray(new Row[0]);
    }

    static BButton newButton(Command cmd) {
        BButton b = new BButton(cmd, true, true);
        b.setHalign(BHalign.left);
        return b;
    }

    public void computePreferredSize() {
        this.setPreferredSize(300.0, 280.0);
    }

    void up() {
        int[] rows = this.table.getSelection().getRows();
        if (rows.length == 0) {
            return;
        }
        this.table.getSelection().deselectAll();
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] == i) {
                this.table.getSelection().select(rows[i]);
                this.table.ensureRowIsVisible(rows[i]);
                continue;
            }
            this.swap(rows[i], rows[i] - 1);
            this.table.getSelection().select(rows[i] - 1);
            this.table.ensureRowIsVisible(rows[i] - 1);
        }
        this.table.repaint();
    }

    void down() {
        int[] rows = this.table.getSelection().getRows();
        if (rows.length == 0) {
            return;
        }
        this.table.getSelection().deselectAll();
        int n = this.newOrder.length - 1;
        for (int i = 0; i < rows.length; ++i) {
            int r = rows.length - 1 - i;
            if (rows[r] == n - i) {
                this.table.getSelection().select(rows[r]);
                this.table.ensureRowIsVisible(rows[r]);
                continue;
            }
            this.swap(rows[r], rows[r] + 1);
            this.table.getSelection().select(rows[r] + 1);
            this.table.ensureRowIsVisible(rows[r] + 1);
        }
        this.table.repaint();
    }

    void byName() {
        Object[] keys = new String[this.newOrder.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.newOrder[i].name;
        }
        this.byNameAscending = !this.byNameAscending;
        SortUtil.sort((Object[])keys, (Object[])this.newOrder, (boolean)this.byNameAscending);
        this.reset(false);
    }

    void byType() {
        Object[] keys = new String[this.newOrder.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.newOrder[i].type;
        }
        this.byTypeAscending = !this.byTypeAscending;
        SortUtil.sort((Object[])keys, (Object[])this.newOrder, (boolean)this.byTypeAscending);
        this.reset(false);
    }

    void byPos() {
        Object[] keys = new BWsAnnotation[this.newOrder.length];
        for (int i = 0; i < keys.length; ++i) {
            BWsAnnotation ws = null;
            BValue obj = this.target.get(this.newOrder[i].property);
            if (obj instanceof BComplex) {
                ws = (BWsAnnotation)((BComplex)obj).get("wsAnnotation");
            }
            keys[i] = ws;
        }
        this.byPosAscending = !this.byPosAscending;
        SortUtil.sort((Object[])keys, (Object[])this.newOrder, this.ByPosComparator);
        this.reset(false);
    }

    void reset(boolean backToOld) {
        if (backToOld) {
            System.arraycopy(this.oldOrder, 0, this.newOrder, 0, this.oldOrder.length);
        }
        this.table.getSelection().deselectAll();
        this.table.getSelection().select(0);
        this.table.ensureRowIsVisible(0);
        this.table.repaint();
    }

    int swap(int i1, int i2) {
        Row temp = this.newOrder[i1];
        this.newOrder[i1] = this.newOrder[i2];
        this.newOrder[i2] = temp;
        return i2;
    }

    public Property[] newOrder() {
        Property[] p = new Property[this.newOrder.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = this.newOrder[i].property;
        }
        return p;
    }

    public Property[] oldOrder() {
        Property[] p = new Property[this.oldOrder.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = this.oldOrder[i].property;
        }
        return p;
    }

    public static class PropertyFilter {
        public boolean include(BIPropertyContainer comp, Property prop) {
            return true;
        }
    }

    static class Row {
        Property property;
        String name;
        BImage icon;
        String type;

        Row(BIPropertyContainer t, Property p, BObject v) {
            this.property = p;
            this.name = t.getDisplayName((Slot)p, null);
            this.type = v.getType().getTypeName();
            this.icon = BImage.make((BIcon)v.getIcon());
            if (this.icon == null) {
                this.icon = defaultIcon;
            }
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BReorderPad.this.newOrder.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col) {
            return "";
        }

        public Object getValueAt(int row, int col) {
            return BReorderPad.this.newOrder[row].name;
        }

        public Object getSubject(int row) {
            return BReorderPad.this.newOrder[row];
        }

        public BImage getRowIcon(int row) {
            return BReorderPad.this.newOrder[row].icon;
        }
    }

    public class ResetCommand
    extends Command {
        ResetCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "reorder.reset");
        }

        public CommandArtifact doInvoke() {
            BReorderPad.this.reset(true);
            return null;
        }
    }

    public class ByPosCommand
    extends Command {
        ByPosCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "reorder.byPos");
        }

        public CommandArtifact doInvoke() {
            BReorderPad.this.byPos();
            return null;
        }
    }

    public class ByTypeCommand
    extends Command {
        ByTypeCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "reorder.byType");
        }

        public CommandArtifact doInvoke() {
            BReorderPad.this.byType();
            return null;
        }
    }

    public class ByNameCommand
    extends Command {
        ByNameCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "reorder.byName");
        }

        public CommandArtifact doInvoke() {
            BReorderPad.this.byName();
            return null;
        }
    }

    public class DownCommand
    extends Command {
        DownCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "reorder.down");
        }

        public CommandArtifact doInvoke() {
            BReorderPad.this.down();
            return null;
        }
    }

    public class UpCommand
    extends Command {
        UpCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "reorder.up");
        }

        public CommandArtifact doInvoke() {
            BReorderPad.this.up();
            return null;
        }
    }
}

