/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.util.LinkUtil;
import com.tridium.workbench.ord.RefFilter;
import com.tridium.workbench.ord.RefNode;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.BCompositeAction;
import javax.baja.util.BCompositeTopic;
import javax.baja.util.Lexicon;

@NiagaraType
public class BCompositeEditor
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BCompositeEditor.class);
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static BModule module = Sys.getModuleForClass(BCompositeEditor.class);
    private static BImage inIcon = BImage.make((String)"module://icons/x16/arrowLeft.png");
    private static BImage outIcon = BImage.make((String)"module://icons/x16/arrowRight.png");
    private static BBrush colorProperty = BColor.make((int)13816554).toBrush();
    private static BBrush colorAction = BColor.make((int)0xB8F8B8).toBrush();
    private static BBrush colorTopic = BColor.make((int)14934976).toBrush();
    private BComponent composite;
    private BTree tree;
    private BTable table;
    private ArrayList<CompositeSlot> removed = new ArrayList();
    private BWidget owner;
    private Add add;
    private Reverse reverse;
    private Rename rename;
    private Remove remove;
    private MoveUp moveUp;
    private MoveDown moveDown;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static void openInDialog(BWidget owner, BComponent composite) {
        BCompositeEditor w = new BCompositeEditor(owner, composite);
        if (1 == BDialog.open((BWidget)owner, (String)lex.getText("compositeEditor.title"), (Object)((Object)w), (int)3)) {
            composite = w.createComposite();
            composite.lease(Integer.MAX_VALUE);
        }
    }

    public BCompositeEditor() {
        throw new IllegalStateException();
    }

    public BCompositeEditor(BWidget owner, BComponent composite) {
        this.owner = owner;
        this.composite = composite;
        composite.lease();
        this.tree = new BTree((TreeModel)new Model(composite));
        this.tree.setMultipleSelection(true);
        this.tree.setController((TreeController)new Controller());
        this.tree.setSelection((TreeSelection)new Selection());
        CompositeModel model = new CompositeModel();
        this.table = new BTable((TableModel)model);
        this.table.setController((TableController)new CompositeController());
        this.table.setSelection((TableSelection)new CompositeSelection());
        this.table.setCellRenderer((TableCellRenderer)new CompositeRenderer());
        BLink[] links = composite.getLinks();
        BOrd handle = composite.getHandleOrd();
        for (int i = 0; i < links.length; ++i) {
            boolean readonly;
            String b;
            BComponent child;
            String a;
            if (!LinkUtil.isCompositeLink((BLink)links[i]) || !(a = (child = (BComponent)links[i].getSourceOrd().resolve((BObject)composite).get()).getSlotPath().toString()).startsWith(b = composite.getSlotPath().toString()) || a.equals(b)) continue;
            String target = links[i].getTargetSlotName();
            String sourceSlot = links[i].getSourceSlotName();
            child.lease();
            Slot s = child.getSlot(sourceSlot);
            boolean bl = readonly = s.isTopic() || Flags.isReadonly((BComplex)child, (Slot)s);
            if (composite.getProperty(target) == null) {
                composite.remove(links[i].getName());
                continue;
            }
            Property targetProperty = composite.getProperty(target);
            model.add(1, target, a, sourceSlot, targetProperty.getType(), readonly, true, composite.getFlags((Slot)targetProperty));
        }
        Knob[] knobs = composite.getKnobs();
        for (int i = 0; i < knobs.length; ++i) {
            if (!LinkUtil.isCompositeKnob((Knob)knobs[i])) continue;
            BComponent c = (BComponent)knobs[i].getTargetOrd().resolve((BObject)composite).get();
            c.lease();
            String a = c.getSlotPath().toString();
            String b = composite.getSlotPath().toString();
            if (!a.startsWith(b) || a.equals(b)) continue;
            String source = knobs[i].getSourceSlotName();
            String target = knobs[i].getTargetSlotName();
            if (composite.getProperty(source) == null) {
                c.remove(knobs[i].getLink().getName());
                continue;
            }
            Property sourceProperty = composite.getProperty(source);
            model.add(0, source, a, target, sourceProperty.getType(), false, true, composite.getFlags((Slot)sourceProperty));
        }
        Property[] props = composite.getPropertiesArray();
        int offset = 0;
        for (int i = 0; i < props.length; ++i) {
            for (int j = 0; j < model.getRowCount(); ++j) {
                if (!props[i].getName().equals(model.get((int)j).name)) continue;
                model.move(j, offset++);
            }
        }
        BSplitPane split = new BSplitPane();
        split.setDividerPosition(25.0);
        split.setWidget1(this.buildLeftPane());
        split.setWidget2(this.buildRightPane());
        String title = lex.getText("compositeEditor.title");
        String subtitle = lex.getText("compositeEditor.subtitle");
        BImage icon = BImage.make((String)"module://icons/x32/composite.png");
        BWizardHeader wizard = new BWizardHeader(icon, title, subtitle);
        this.setTop((BWidget)wizard);
        this.setCenter((BWidget)split);
    }

    private BWidget buildLeftPane() {
        this.add = new Add((BWidget)this);
        this.add.setEnabled(false);
        BButton a = new BButton((Command)this.add);
        a.setButtonStyle(BButtonStyle.toolBar);
        BGridPane top = new BGridPane(1);
        top.setHalign(BHalign.left);
        top.add(null, (BValue)a);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)top, 5.0, 0.0, 5.0, 0.0));
        pane.setCenter((BWidget)new BBorderPane((BWidget)new BTreePane(this.tree), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return pane;
    }

    private BWidget buildRightPane() {
        this.reverse = new Reverse((BWidget)this);
        this.rename = new Rename((BWidget)this);
        this.remove = new Remove((BWidget)this);
        this.moveUp = new MoveUp((BWidget)this);
        this.moveDown = new MoveDown((BWidget)this);
        this.reverse.setEnabled(false);
        this.rename.setEnabled(false);
        this.remove.setEnabled(false);
        this.moveUp.setEnabled(false);
        this.moveDown.setEnabled(false);
        BButton a = new BButton((Command)this.reverse);
        BButton b = new BButton((Command)this.rename);
        BButton c = new BButton((Command)this.remove);
        BButton d = new BButton((Command)this.moveUp);
        BButton e = new BButton((Command)this.moveDown);
        a.setButtonStyle(BButtonStyle.toolBar);
        b.setButtonStyle(BButtonStyle.toolBar);
        c.setButtonStyle(BButtonStyle.toolBar);
        d.setButtonStyle(BButtonStyle.toolBar);
        e.setButtonStyle(BButtonStyle.toolBar);
        BGridPane topLeft = new BGridPane(3);
        topLeft.add(null, (BValue)a);
        topLeft.add(null, (BValue)b);
        topLeft.add(null, (BValue)c);
        BGridPane topRight = new BGridPane(2);
        topRight.add(null, (BValue)d);
        topRight.add(null, (BValue)e);
        BEdgePane top = new BEdgePane();
        top.setLeft((BWidget)topLeft);
        top.setRight((BWidget)topRight);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)top, 5.0, 0.0, 5.0, 0.0));
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return pane;
    }

    public BComponent createComposite() {
        CompositeSlot slot;
        int i;
        Context tx = Transaction.start((BComponent)this.composite, null);
        CompositeModel model = (CompositeModel)this.table.getModel();
        for (i = 0; i < model.getRowCount(); ++i) {
            slot = model.get(i);
            slot.name = SlotPath.escape((String)slot.name);
            if (slot.backup == null) {
                this.addCompositeSlot(tx, slot);
                continue;
            }
            if (slot.dir == slot.backup.dir) {
                this.renameCompositeSlot(tx, slot);
                continue;
            }
            slot.backup.backup = slot.backup;
            this.removeCompositeSlot(tx, slot.backup);
            this.addCompositeSlot(tx, slot);
        }
        for (i = 0; i < this.removed.size(); ++i) {
            slot = this.removed.get(i);
            this.removeCompositeSlot(tx, slot);
        }
        try {
            Transaction.end((BComponent)this.composite, (Context)tx);
        }
        catch (Exception e) {
            BDialog.error((BWidget)this.getShell(), (String)"Error", (Object)"createComposite failed.", (Throwable)e);
        }
        this.reorderCompositeSlots();
        return this.composite;
    }

    private void addCompositeSlot(Context tx, CompositeSlot slot) {
        Slot check;
        BComponent child = (BComponent)BOrd.make((String)slot.ord).resolve((BObject)this.composite).get();
        BFacets facets = child.getSlotFacets(check = child.getSlot(slot.slot));
        if (facets == null) {
            facets = BFacets.NULL;
        }
        Object value = check.isAction() || check.isTopic() ? (slot.dir == 0 ? new BCompositeAction() : new BCompositeTopic()) : (BValue)slot.type.getInstance();
        int flags = slot.dir == 1 ? 1 : 0;
        this.composite.add(slot.name, (BValue)value, flags |= slot.flags, facets, tx);
        if (slot.dir == 1) {
            BLink link = new BLink(child.getHandleOrd(), slot.slot, slot.name, true);
            this.composite.add(null, (BValue)link, 4096, BFacets.NULL, tx);
        } else {
            BLink link = new BLink(this.composite.getHandleOrd(), slot.name, slot.slot, true);
            child.add(null, (BValue)link, 4096, BFacets.NULL, tx);
        }
    }

    private void renameCompositeSlot(Context tx, CompositeSlot slot) {
        if (slot.backup.name.equals(slot.name)) {
            return;
        }
        BComponent c = this.composite;
        Property prop = c.getProperty(slot.backup.name);
        BString newName = BString.make((String)slot.name);
        c.rename(prop, slot.name, tx);
        BLink[] links = c.getLinks((Slot)prop);
        for (int i = 0; i < links.length; ++i) {
            BLink link = links[i];
            link.set(BLink.targetSlotName, (BValue)newName, tx);
        }
        Knob[] knobs = c.getKnobs((Slot)prop);
        block1: for (int i = 0; i < knobs.length; ++i) {
            Knob knob = knobs[i];
            BComponent target = (BComponent)knob.getTargetOrd().get((BObject)c);
            target.lease();
            Property targetProp = target.getProperty(knob.getTargetSlotName());
            BLink[] targetLinks = target.getLinks((Slot)targetProp);
            for (int j = 0; j < targetLinks.length; ++j) {
                BLink link = targetLinks[j];
                if (!this.isMatch(knob, link)) continue;
                link.set(BLink.sourceSlotName, (BValue)newName, tx);
                continue block1;
            }
        }
    }

    private boolean isMatch(Knob knob, BLink link) {
        return link.getSourceOrd().equals((Object)knob.getSourceOrd()) && link.getSourceSlotName().equals(knob.getSourceSlotName());
    }

    private void removeCompositeSlot(Context tx, CompositeSlot slot) {
        if (slot.dir == 1) {
            BLink[] links = this.composite.getLinks();
            for (int i = 0; i < links.length; ++i) {
                if (!links[i].getTargetSlotName().equals(slot.backup.name)) continue;
                this.composite.remove(links[i].getPropertyInParent(), tx);
                this.composite.remove(this.composite.getProperty(slot.backup.name), tx);
                return;
            }
        } else {
            BComponent child = (BComponent)BOrd.make((String)slot.ord).resolve((BObject)this.composite).get();
            child.lease();
            BLink[] links = child.getLinks();
            for (int i = 0; i < links.length; ++i) {
                if (!links[i].getSourceSlotName().equals(slot.backup.name)) continue;
                child.remove(links[i].getPropertyInParent(), null);
                this.composite.remove(this.composite.getProperty(slot.backup.name), null);
                return;
            }
        }
        throw new RuntimeException("Could not find link for " + slot.backup.name);
    }

    public void reorderCompositeSlots() {
        this.composite.lease();
        CompositeModel model = (CompositeModel)this.table.getModel();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            list.add(model.get((int)i).name);
        }
        this.composite.loadSlots();
        SlotCursor c = this.composite.getProperties();
        while (c.next()) {
            Property p = c.property();
            String propName = p.getName();
            if (p.isFrozen()) {
                list.remove(propName);
                continue;
            }
            if (list.contains(propName)) continue;
            list.add(propName);
        }
        Property[] newProps = new Property[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            newProps[i] = this.composite.getProperty((String)list.get(i));
        }
        this.composite.reorder(newProps);
    }

    public void computePreferredSize() {
        this.setPreferredSize(650.0, 450.0);
    }

    private String getUniqueName(String name) {
        CompositeModel model = (CompositeModel)this.table.getModel();
        this.composite.loadSlots();
        Slot[] s = this.composite.getSlotsArray();
        int count = 1;
        String tempName = name;
        for (int i = 0; i < s.length; ++i) {
            if (s[i].getName().equals(tempName)) {
                tempName = name + count;
                ++count;
                i = -1;
                continue;
            }
            for (int j = 0; j < model.getRowCount(); ++j) {
                CompositeSlot cs = model.get(j);
                if (!cs.name.equals(tempName)) continue;
                tempName = name + count;
                ++count;
                j = model.getRowCount();
                i = -1;
            }
        }
        return tempName;
    }

    class Selection
    extends TreeSelection {
        Selection() {
        }

        public void updateTree() {
            super.updateTree();
            TreeNode[] nodes = this.getNodes();
            boolean b = false;
            if (nodes != null) {
                for (int i = 0; i < nodes.length; ++i) {
                    b = !(((Node)nodes[i]).ref.object instanceof BComponent);
                }
            }
            BCompositeEditor.this.add.setEnabled(b);
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void doSelectAction(TreeNode target, double x, double y) {
            if (BCompositeEditor.this.add.isEnabled()) {
                BCompositeEditor.this.add.invoke();
            }
        }
    }

    class Node
    extends TreeNode {
        RefNode ref;
        Node[] kids;

        public Node(TreeModel model, RefNode ref) {
            super(model);
            this.ref = ref;
        }

        public Node(TreeNode parent, RefNode ref) {
            super(parent);
            this.ref = ref;
        }

        public Object getSubject() {
            return this.ref;
        }

        public String getText() {
            return this.ref.text;
        }

        public BImage getIcon() {
            return this.ref.icon;
        }

        public boolean hasChildren() {
            if (!(this.ref.object instanceof BComponent)) {
                return false;
            }
            if (this.kids == null) {
                return true;
            }
            return this.kids.length > 0;
        }

        public int getChildCount() {
            if (this.kids == null) {
                this.getChild(-1);
            }
            return this.kids.length;
        }

        public TreeNode getChild(int index) {
            if (this.kids == null) {
                this.load();
            }
            return index == -1 ? null : this.kids[index];
        }

        public TreeNode getChild(String name) {
            if (this.kids == null) {
                this.load();
            }
            for (int i = 0; i < this.kids.length; ++i) {
                if (!this.kids[i].ref.name.equals(name)) continue;
                return this.kids[i];
            }
            return null;
        }

        private void load() {
            if (this.kids == null) {
                RefNode[] refs = this.ref.getChildren(this.ref.object == BCompositeEditor.this.composite ? RefFilter.components : RefFilter.all);
                ArrayList<Node> list = new ArrayList<Node>();
                for (int i = 0; i < refs.length; ++i) {
                    if (refs[i].object instanceof BLink) continue;
                    list.add(new Node(this, refs[i]));
                }
                this.kids = list.toArray(new Node[0]);
            }
        }
    }

    class Model
    extends TreeModel {
        Node root;

        public Model(BComponent rootNode) {
            this.root = new Node(this, new RefNode((BComplex)rootNode));
        }

        public int getRootCount() {
            return 1;
        }

        public TreeNode getRoot(int index) {
            return this.root;
        }
    }

    class CompositeRenderer
    extends TableCellRenderer {
        CompositeRenderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            CompositeModel model = (CompositeModel)this.getTable().getModel();
            CompositeSlot slot = model.get(cell.row);
            if (slot.type.is(BCompositeAction.TYPE)) {
                return colorAction;
            }
            if (slot.type.is(BCompositeTopic.TYPE)) {
                return colorTopic;
            }
            return colorProperty;
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                return this.getForeground(cell);
            }
            return super.getSelectionForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                return this.getBackground(cell);
            }
            return super.getSelectionBackground(cell);
        }
    }

    class CompositeSelection
    extends TableSelection {
        CompositeSelection() {
        }

        public void updateTable() {
            super.updateTable();
            CompositeModel model = (CompositeModel)this.getTable().getModel();
            int[] rows = this.getRows();
            BCompositeEditor.this.rename.setEnabled(rows.length > 0);
            BCompositeEditor.this.remove.setEnabled(rows.length > 0);
            BCompositeEditor.this.moveUp.setEnabled(rows.length > 0);
            BCompositeEditor.this.moveDown.setEnabled(rows.length > 0);
            for (int i = 0; i < rows.length; ++i) {
                CompositeSlot slot = ((CompositeModel)BCompositeEditor.this.table.getModel()).get(rows[i]);
                if (slot.readonly) {
                    BCompositeEditor.this.reverse.setEnabled(false);
                    return;
                }
                for (int j = 0; j < model.getRowCount(); ++j) {
                    CompositeSlot temp = model.get(j);
                    if (!(temp.ord + temp.slot).equals(slot.ord + slot.slot) || temp.name.equals(slot.name)) continue;
                    BCompositeEditor.this.reverse.setEnabled(false);
                    return;
                }
            }
            BCompositeEditor.this.reverse.setEnabled(rows.length > 0);
        }
    }

    class CompositeController
    extends TableController {
        CompositeController() {
        }

        public void keyPressed(BKeyEvent event) {
            super.keyPressed(event);
            if (event.getKeyCode() == 127 && BCompositeEditor.this.remove.isEnabled()) {
                BCompositeEditor.this.remove.invoke();
            }
        }

        protected void handleEnter(BKeyEvent event) {
            event.consume();
            if (BCompositeEditor.this.rename.isEnabled()) {
                BCompositeEditor.this.rename.invoke();
            }
            BCompositeEditor.this.table.repaint();
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            if (column == 0) {
                if (BCompositeEditor.this.reverse.isEnabled()) {
                    BCompositeEditor.this.reverse.invoke();
                }
            } else if (BCompositeEditor.this.rename.isEnabled()) {
                BCompositeEditor.this.rename.invoke();
            }
            BCompositeEditor.this.table.repaint();
        }
    }

    class CompositeSlot {
        public String name;
        public String ord;
        public String slot;
        public Object handle;
        public Type type;
        public int dir;
        public boolean readonly = false;
        public static final int IN = 0;
        public static final int OUT = 1;
        public CompositeSlot backup = null;
        public int flags = 0;

        CompositeSlot() {
        }
    }

    class CompositeModel
    extends TableModel {
        ArrayList<CompositeSlot> kids = new ArrayList();

        CompositeModel() {
        }

        public int getRowCount() {
            return this.kids.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("compositeEditor.dir");
                }
                case 1: {
                    return lex.getText("compositeEditor.slot");
                }
                case 2: {
                    return lex.getText("compositeEditor.ord");
                }
            }
            return "";
        }

        public Object getValueAt(int row, int col) {
            CompositeSlot slot = this.kids.get(row);
            switch (col) {
                case 0: {
                    return slot.dir == 0 ? lex.getText("compositeEditor.in") : lex.getText("compositeEditor.out");
                }
                case 1: {
                    return slot.name;
                }
                case 2: {
                    String a = BCompositeEditor.this.composite.getSlotPath().toString();
                    String b = slot.ord + "/" + slot.slot;
                    return b.substring(a.length() + 1);
                }
            }
            return "";
        }

        public Object getSubject(int row) {
            return this.kids.get(row);
        }

        public BImage getRowIcon(int row) {
            CompositeSlot slot = this.kids.get(row);
            return slot.dir == 0 ? inIcon : outIcon;
        }

        public void add(int dir, String name, String ord, String slotName, Type type, boolean readonly, boolean backup, int flags) {
            CompositeSlot slot = new CompositeSlot();
            slot.name = SlotPath.unescape((String)name);
            slot.ord = ord;
            slot.slot = slotName;
            slot.dir = dir;
            slot.type = type;
            slot.readonly = readonly;
            slot.flags = flags;
            if (backup) {
                slot.backup = new CompositeSlot();
                slot.backup.name = name;
                slot.backup.ord = ord;
                slot.backup.slot = slotName;
                slot.backup.dir = dir;
                slot.backup.type = type;
                slot.backup.readonly = readonly;
                slot.backup.flags = flags;
            }
            this.kids.add(slot);
        }

        public void remove(int row) {
            this.kids.remove(row);
        }

        public CompositeSlot get(int row) {
            if (row > this.kids.size()) {
                return null;
            }
            return this.kids.get(row);
        }

        public void move(int row, int newRow) {
            CompositeSlot obj = this.kids.remove(row);
            this.kids.add(newRow, obj);
        }
    }

    public class MoveDown
    extends Command {
        public MoveDown(BWidget owner) {
            super(owner, module, "compositeEditor.moveDown");
        }

        public CommandArtifact doInvoke() {
            CompositeModel model = (CompositeModel)BCompositeEditor.this.table.getModel();
            int[] rows = model.getSelection().getRows();
            if (rows.length == 0 || rows[rows.length - 1] == model.getRowCount() - 1) {
                return null;
            }
            for (int i = rows.length - 1; i >= 0; --i) {
                model.getSelection().deselect(rows[i]);
                model.move(rows[i], rows[i] + 1);
                model.getSelection().select(rows[i] + 1);
            }
            BCompositeEditor.this.table.relayout();
            return null;
        }
    }

    public class MoveUp
    extends Command {
        public MoveUp(BWidget owner) {
            super(owner, module, "compositeEditor.moveUp");
        }

        public CommandArtifact doInvoke() {
            CompositeModel model = (CompositeModel)BCompositeEditor.this.table.getModel();
            int[] rows = model.getSelection().getRows();
            if (rows.length == 0 || rows[0] == 0) {
                return null;
            }
            for (int i = 0; i < rows.length; ++i) {
                model.getSelection().deselect(rows[i]);
                model.move(rows[i], rows[i] - 1);
                model.getSelection().select(rows[i] - 1);
            }
            BCompositeEditor.this.table.relayout();
            return null;
        }
    }

    public class Remove
    extends Command {
        public Remove(BWidget owner) {
            super(owner, module, "compositeEditor.remove");
        }

        public CommandArtifact doInvoke() {
            CompositeModel model = (CompositeModel)BCompositeEditor.this.table.getModel();
            int[] rows = model.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                CompositeSlot slot = model.get(rows[i] - i);
                if (slot.backup != null) {
                    BCompositeEditor.this.removed.add(slot);
                }
                model.remove(rows[i] - i);
            }
            BCompositeEditor.this.table.getSelection().deselectAll();
            BCompositeEditor.this.table.relayout();
            return null;
        }
    }

    public class Rename
    extends Command {
        public Rename(BWidget owner) {
            super(owner, module, "compositeEditor.rename");
        }

        public CommandArtifact doInvoke() {
            int[] rows = BCompositeEditor.this.table.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                int j;
                CompositeSlot slot = ((CompositeModel)BCompositeEditor.this.table.getModel()).get(rows[i]);
                BTextField field = new BTextField(slot.name, 25);
                BGridPane grid = new BGridPane(1);
                grid.add(null, (BValue)field);
                BBorderPane pane = new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0);
                if (1 != BDialog.open((BWidget)this.getOwner(), (String)lex.getText("compositeEditor.rename.label"), (Object)pane, (int)3)) break;
                if (slot.name.equals(field.getText())) continue;
                BCompositeEditor.this.composite.loadSlots();
                Slot[] s = BCompositeEditor.this.composite.getSlotsArray();
                for (j = 0; j < s.length; ++j) {
                    if (!s[j].getName().equals(field.getText())) continue;
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("compositeEditor.rename.label"), (Object)lex.getText("compositeEditor.rename.exists"));
                    return null;
                }
                for (j = 0; j < BCompositeEditor.this.table.getModel().getRowCount(); ++j) {
                    CompositeSlot cs = ((CompositeModel)BCompositeEditor.this.table.getModel()).get(j);
                    if (!cs.name.equals(field.getText())) continue;
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("compositeEditor.rename.label"), (Object)lex.getText("compositeEditor.rename.exists"));
                    return null;
                }
                slot.name = field.getText();
                BCompositeEditor.this.table.repaint();
            }
            return null;
        }
    }

    public class Reverse
    extends Command {
        public Reverse(BWidget owner) {
            super(owner, module, "compositeEditor.reverse");
        }

        public CommandArtifact doInvoke() {
            CompositeModel model = (CompositeModel)BCompositeEditor.this.table.getModel();
            int[] rows = BCompositeEditor.this.table.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                CompositeSlot slot = model.get(rows[i]);
                if (slot.readonly) continue;
                int n = slot.dir = slot.dir == 0 ? 1 : 0;
                if (slot.type.is(BCompositeAction.TYPE)) {
                    slot.type = BCompositeTopic.TYPE;
                    continue;
                }
                if (slot.readonly || !slot.type.is(BCompositeTopic.TYPE)) continue;
                slot.type = BCompositeAction.TYPE;
            }
            BCompositeEditor.this.table.repaint();
            return null;
        }
    }

    public class Add
    extends Command {
        public Add(BWidget owner) {
            super(owner, module, "compositeEditor.add");
        }

        public CommandArtifact doInvoke() {
            int i;
            CompositeModel model = (CompositeModel)BCompositeEditor.this.table.getModel();
            TreeNode[] nodes = BCompositeEditor.this.tree.getSelection().getNodes();
            ArrayList<Integer> newRows = new ArrayList<Integer>();
            for (i = 0; i < nodes.length; ++i) {
                int dir;
                boolean readonly;
                Node n = (Node)nodes[i];
                if (n.ref.object instanceof BComponent) continue;
                BComponent parent = (BComponent)((Node)n.getParent()).ref.object;
                String name = n.ref.name;
                String ord = parent.getSlotPath().toString();
                Slot slot = parent.getSlot(n.ref.name);
                boolean inExists = false;
                boolean outExists = false;
                for (int j = 0; j < model.getRowCount(); ++j) {
                    CompositeSlot temp = model.get(j);
                    if (!(temp.ord + temp.slot).equals(ord + slot.getName())) continue;
                    if (temp.dir == 1) {
                        outExists = true;
                    }
                    if (temp.dir != 0) continue;
                    inExists = true;
                }
                if (inExists && outExists) continue;
                boolean bl = readonly = slot.isTopic() || Flags.isReadonly((BComplex)parent, (Slot)slot);
                if (outExists && readonly) continue;
                int n2 = dir = readonly ? 1 : 0;
                if (outExists) {
                    dir = 0;
                } else if (inExists) {
                    dir = 1;
                }
                Type type = slot.isTopic() ? BCompositeTopic.TYPE : (slot.isAction() ? (dir == 0 ? BCompositeAction.TYPE : BCompositeTopic.TYPE) : n.ref.object.getType());
                model.add(dir, BCompositeEditor.this.getUniqueName(name), ord, n.ref.name, type, readonly, false, 4096);
                newRows.add(model.getRowCount() - 1);
            }
            BCompositeEditor.this.table.relayout();
            if (newRows.size() > 0) {
                BCompositeEditor.this.table.requestFocus();
                BCompositeEditor.this.table.getSelection().deselectAll();
                for (i = 0; i < newRows.size(); ++i) {
                    BCompositeEditor.this.table.getSelection().select(((Integer)newRows.get(i)).intValue());
                }
            }
            return null;
        }
    }
}

