/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.transfer;

import com.tridium.sys.transfer.DeployToComp;
import com.tridium.sys.transfer.TransferListener;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import javax.baja.gx.BImage;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.util.UiLexicon;

public class TransferArtifact
implements CommandArtifact {
    static final BImage clockIcon = BImage.make((String)"module://icons/x32/clock.png");
    final UiLexicon lex = UiLexicon.bajaui();
    final String lexPleaseWait = this.lex.getText("pleaseWait");
    BWidget owner;
    int action;
    Mark mark;
    BObject target;
    BComponent params;
    Context context;
    TransferResult result;

    public TransferArtifact(BWidget owner, int action, Mark mark, BObject target, BComponent params, Context cx) {
        this.owner = owner;
        this.action = action;
        this.mark = mark;
        this.target = target;
        this.params = params;
        this.context = cx;
    }

    public TransferResult getResult() {
        return this.result;
    }

    public String[] getInsertNames() {
        return this.getResult().getInsertNames();
    }

    public void redo() throws Exception {
        TransferStrategy strategy = TransferStrategy.make((int)this.action, (Mark)this.mark, (BObject)this.target, (BComponent)this.params, (Context)this.context);
        if (strategy == null) {
            throw new LocalizableException("bajaui", "transfer.noStrategy");
        }
        new Worker().transfer(strategy);
    }

    public void undo() throws Exception {
        this.result.undo();
    }

    class Worker
    extends Thread
    implements TransferListener {
        TransferStrategy strategy;
        Exception exception;
        BDialog dialog;
        BLabel status;
        Object lock = new Object();
        boolean done;
        boolean isDeploy = false;
        boolean isPostDeploy = false;
        boolean isDialogOpen = false;

        Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transfer(TransferStrategy strategy) throws Exception {
            this.strategy = strategy;
            strategy.setListener((TransferListener)this);
            this.status = new BLabel(clockIcon, TransferArtifact.this.lexPleaseWait);
            this.status.setHalign(BHalign.left);
            BConstrainedPane pane = new BConstrainedPane((BWidget)this.status);
            pane.setMinHeight(20.0);
            pane.setMinWidth(450.0);
            this.dialog = new BDialog(TransferArtifact.this.owner, TransferArtifact.this.lexPleaseWait, true, (BWidget)new BBorderPane((BWidget)pane));
            if (strategy instanceof DeployToComp) {
                this.deploy((DeployToComp)strategy);
                return;
            }
            this.start();
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(2000L);
            }
            if (!this.done) {
                this.dialog.setBoundsCenteredOnOwner();
                this.isDialogOpen = true;
                this.dialog.open();
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }

        public void deploy(DeployToComp strategy) throws Exception {
            if (!strategy.getSteps((Object)TransferArtifact.this.owner)) {
                return;
            }
            strategy.setContext(TransferArtifact.this.context);
            this.isDeploy = true;
            this.start();
            if (!this.done && !this.isPostDeploy) {
                this.dialog.setBoundsCenteredOnOwner();
                this.isDialogOpen = true;
                this.dialog.open();
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }

        public void updateStatus(String msg) {
            if (this.status == null) {
                return;
            }
            this.status.setText(msg);
            this.status.relayout();
            if (!this.isDeploy) {
                return;
            }
            if (msg.equals("postDeploy")) {
                this.isPostDeploy = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                TransferArtifact.this.result = this.strategy.transfer();
            }
            catch (Exception e) {
                this.exception = e;
            }
            Object object = this.lock;
            synchronized (object) {
                this.done = true;
                this.lock.notifyAll();
            }
            this.dialog.close();
        }
    }
}

