/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.fox.session.Fox;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.license.NodeLockedLicenseManager;
import com.tridium.sys.registry.NAgentInfo;
import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.util.CommandLineArguments;
import com.tridium.util.CustomThemeModuleManager;
import com.tridium.workbench.job.JobMonitor;
import com.tridium.workbench.nav.BSessionAgent;
import com.tridium.workbench.nav.NavMonitor;
import com.tridium.workbench.security.BChangeSystemPassphraseDialog;
import com.tridium.workbench.service.BWbServiceManager;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BSaveAllDialog;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BWbApplication;
import com.tridium.workbench.shell.WbState;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BImage;
import javax.baja.gx.BPoint;
import javax.baja.gx.BSize;
import javax.baja.gx.IRectGeom;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.license.LicenseException;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.nav.BNavFolder;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BICredentials;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.options.BFipsOptions;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public class WbMain {
    public static BICredentials kioskCredentials;
    public static final AgentFilter licenseFilter;
    private static String defaultBrandTitle;
    private static String defaultBrandSplash;
    private static String defaultBrandIcon;
    private static String defaultBrandFIPSBadge;
    private static String defaultBrandLogoImage;
    private static String defaultBrandLogoText;
    private static String defaultBrandTitleImage;
    private static String defaultBrandTitleText;
    private static String defaultBrandCss;
    public static String defaultThemeCss;
    public static String brandTitle;
    public static String brandSplash;
    public static String brandIcon;
    public static String brandCss;
    public static String brandFIPSBadge;
    public static String brandLogoImage;
    public static String brandLogoText;
    public static String brandTitleImage;
    public static String brandTitleText;
    private static boolean brandLoaded;
    public static final String FIPS_TITLE_SUFFIX;
    public static Type defaultProfileType;
    static boolean licenseAdmin;
    static String licenseName;
    static String licenseCompany;
    static String licenseEmail;
    static String licenseInfo;
    static String commandLineTheme;
    private static int frameCount;
    private static String[] args;
    private static final Logger logger;
    private static final String ATTR_NAV_DISPLAY_FORMAT = "navDisplayFormat";
    private static final String ATTR_NAV_DESCRIPTION = "description";
    private static final File NAVTREE_FILE;

    public static boolean isKiosk() {
        return Sys.getStation() != null;
    }

    public static boolean isKioskAccessible(BOrd ord) {
        if (!WbMain.isKiosk()) {
            return true;
        }
        String ordStr = ord.toString();
        return !ordStr.startsWith("local:") || ordStr.startsWith("local:|fox:") || ordStr.startsWith("local:|foxs:") || ordStr.startsWith("local:|platform:") || ordStr.startsWith("local:|platformssl:") || ordStr.startsWith("local:|sox:");
    }

    public static void open(BWbShell shell, BOrd ord, String target) {
        switch (target) {
            case "_help": {
                WbMain.openHelp(shell, ord);
                break;
            }
            case "_main": {
                WbMain.openReuse(shell, ord, defaultProfileType);
                break;
            }
            default: {
                shell.hyperlink(ord);
            }
        }
    }

    public static void openHelp(BWbShell shell, BOrd ord) {
        if (WbMain.isKiosk()) {
            shell.hyperlink(ord);
            return;
        }
        Type helpProfile = shell.getProfile().getType();
        try {
            helpProfile = Sys.getType((String)"help:HelpProfile");
        }
        catch (Exception e) {
            System.out.println("WARNING:  Missing help:HelpProfile");
        }
        WbMain.openReuse(shell, ord, helpProfile);
    }

    public static void openReuse(BWbShell shell, BOrd ord, Type targetProfile) {
        AwtShellManager mgr = (AwtShellManager)shell.widgetSupport(null);
        mgr.clearTempFocus();
        for (BWidgetShell shell1 : BWidget.getApplication().getShells()) {
            BWbShell wbShell;
            if (!(shell1 instanceof BWbShell) || !(wbShell = (BWbShell)shell1).getProfile().getType().is(targetProfile)) continue;
            wbShell.hyperlink(ord);
            mgr = (AwtShellManager)wbShell.widgetSupport(null);
            Frame frame = (Frame)mgr.getWindow();
            ((AwtUiEnv)AwtUiEnv.get()).setIconified(frame, false);
            frame.toFront();
            return;
        }
        BNiagaraWbFrame frame = null;
        if (shell instanceof BNiagaraWbFrame) {
            frame = (BNiagaraWbFrame)shell;
        }
        WbMain.openFrame(frame, ord, targetProfile);
    }

    public static BNiagaraWbFrame openFrame(BNiagaraWbFrame launcher, BOrd ord, Type profileType) {
        return WbMain.openFrame(launcher, BOrdList.make((BOrd)ord), profileType, null, null);
    }

    public static BNiagaraWbFrame openFrame(BNiagaraWbFrame launcher, BOrdList ord, Type profileType) {
        return WbMain.openFrame(launcher, ord, profileType, null, null);
    }

    public static BNiagaraWbFrame openFrame(BNiagaraWbFrame launcher, BOrd ord, Type profileType, BPoint position, BSize size) {
        return WbMain.openFrame(launcher, BOrdList.make((BOrd)ord), profileType, position, size);
    }

    public static BNiagaraWbFrame openFrame(BNiagaraWbFrame launcher, BOrdList ord, Type profileType, BPoint position, BSize size) {
        BNiagaraWbFrame shell = new BNiagaraWbFrame(profileType);
        if (launcher != null) {
            AwtShellManager mgr = (AwtShellManager)launcher.widgetSupport(null);
            mgr.clearTempFocus();
        }
        if (launcher != null) {
            WbState.save(launcher);
        }
        WbState.load(shell);
        if (position != null && size != null) {
            shell.frame.setBounds((int)position.x(), (int)position.y(), (int)size.width(), (int)size.height());
        } else if (launcher != null) {
            Rectangle a = launcher.frame.getBounds();
            Rectangle b = shell.frame.getBounds();
            if (a.x == b.x && a.y == b.y) {
                shell.frame.setBounds(b.x + 15, b.y + 15, b.width, b.height);
            }
        }
        if (WbMain.isKiosk()) {
            UiEnv.get().setKiosk((BWidgetShell)shell);
        }
        WbMain.validateBounds(shell);
        ++frameCount;
        if (ord == null) {
            ord = BOrdList.make((BOrd)shell.profile.getStartOrd());
        }
        shell.hyperlink(ord.get(0));
        int tabIndex = 0;
        for (int i = 1; i < ord.size(); ++i) {
            if (ord.get(i).toString().startsWith("tab:")) {
                tabIndex = Integer.parseInt(ord.get(i).toString().substring(4));
                continue;
            }
            shell.pane.views.addTab();
            shell.hyperlink(ord.get(i));
        }
        BViewTab[] tabs = shell.pane.views.getTabs();
        if (tabIndex < tabs.length && tabIndex > 0) {
            shell.pane.views.selectLabelPane(tabs[tabIndex]);
        }
        shell.open();
        shell.frame.toFront();
        return shell;
    }

    private static void validateBounds(BNiagaraWbFrame frame) {
        Rectangle frameBounds = frame.frame.getBounds();
        IRectGeom screen = UiEnv.get().getScreenBounds((BWidget)frame);
        if ((double)frameBounds.x - screen.x() > screen.width() || (double)frameBounds.x - screen.x() + (double)frameBounds.width > screen.width()) {
            frameBounds.x = (int)screen.x() + (int)screen.width() - frameBounds.width - 10;
        }
        if (frameBounds.x < 0) {
            frameBounds.x = 10;
            frameBounds.width = Math.min(frameBounds.width, (int)screen.width() - 20);
        }
        if ((double)frameBounds.y - screen.y() > screen.height() || (double)frameBounds.y - screen.y() + (double)frameBounds.height > screen.height()) {
            frameBounds.y = (int)screen.y() + (int)screen.height() - frameBounds.height - 10;
        }
        if ((double)frameBounds.y < screen.y()) {
            frameBounds.y = 10;
            frameBounds.height = Math.min(frameBounds.height, (int)screen.height() - 20);
        }
        frame.frame.setBounds(frameBounds);
    }

    public static void closeFrame(BNiagaraWbFrame shell) {
        if (frameCount == 1 && Sys.getStation() != null) {
            if (shell.getProfile().getType() == defaultProfileType) {
                return;
            }
            if (!shell.confirmClose()) {
                return;
            }
            shell.close();
            --frameCount;
            WbMain.openFrame(null, (BOrdList)null, defaultProfileType);
            return;
        }
        WbState.save(shell);
        if (frameCount <= 1) {
            WbMain.exit(shell);
            --frameCount;
        } else {
            if (!shell.confirmClose()) {
                return;
            }
            shell.close();
            --frameCount;
        }
    }

    public static void exit(BNiagaraWbFrame shell) {
        BWbApplication app = (BWbApplication)BWidget.getApplication();
        try {
            String title = UiLexicon.bajaui().getText("saveBeforeExit");
            int result = BSaveAllDialog.saveAll((BWidget)shell, title);
            if (result == 2) {
                return;
            }
            AccessController.doPrivileged(() -> {
                for (BWidgetShell shell1 : app.getShells()) {
                    if (!(shell1 instanceof BNiagaraWbFrame)) continue;
                    BNiagaraWbFrame s = (BNiagaraWbFrame)shell1;
                    s.shutdownShell();
                }
                return null;
            });
            BWbServiceManager.make().shutdown();
            if (shell != null) {
                WbState.save(shell);
            }
            BNiagaraWbShell.history.save();
            WbMain.saveNavTree();
            WbMain.saveOptions();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!app.isApplet()) {
            AccessController.doPrivileged(() -> {
                System.exit(0);
                return null;
            });
        }
    }

    public static void initApplet() {
        if (frameCount <= 0) {
            frameCount = 1;
        }
    }

    public static void loadOptions() {
        BGeneralOptions options = BGeneralOptions.make();
        options.apply();
        if (commandLineTheme != null && !Flags.isHidden((BComplex)options, (Slot)BGeneralOptions.activeTheme)) {
            options.setFlags((Slot)BGeneralOptions.activeTheme, 4);
            Theme.installFromEnum((BDynamicEnum)CustomThemeModuleManager.getModuleEnumForTag((String)commandLineTheme));
        } else {
            Theme.installFromEnum((BDynamicEnum)options.getActiveTheme());
        }
    }

    public static void saveOptions() {
        BOptions.getOptionsManager().saveAll();
    }

    public static void loadBrand() {
        if (brandLoaded) {
            return;
        }
        File f = new File(Nre.getNiagaraHome(), "etc" + File.separator + "brand.properties");
        try {
            Properties props = new Properties();
            try (FileInputStream in = new FileInputStream(f);){
                props.load(in);
            }
            brandTitle = props.getProperty("workbench.title");
            brandSplash = props.getProperty("workbench.splash");
            brandIcon = props.getProperty("workbench.icon");
            brandCss = props.getProperty("workbench.css");
            brandFIPSBadge = props.getProperty("workbench.fipsBadge");
            brandLogoImage = props.getProperty("workbench.splashLogo");
            brandLogoText = props.getProperty("workbench.splashLogoText");
            brandTitleImage = props.getProperty("workbench.splashTitleImage");
            brandTitleText = props.getProperty("workbench.splashTitleText");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (brandTitle == null) {
            brandTitle = defaultBrandTitle;
        }
        if (brandSplash == null) {
            brandSplash = defaultBrandSplash;
        }
        if (brandIcon == null) {
            brandIcon = defaultBrandIcon;
        }
        if (brandCss == null) {
            brandCss = defaultBrandCss;
        }
        if (brandFIPSBadge == null) {
            brandFIPSBadge = defaultBrandFIPSBadge;
        }
        if (brandLogoImage == null) {
            brandLogoImage = defaultBrandLogoImage;
        }
        if (brandLogoText == null) {
            brandLogoText = defaultBrandLogoText;
        }
        if (brandTitleImage == null) {
            brandTitleImage = defaultBrandTitleImage;
        }
        if (brandTitleText == null) {
            brandTitleText = defaultBrandTitleText;
        }
        brandLoaded = true;
    }

    public static void loadNavTree() {
        AccessController.doPrivileged(new LoadNavTreePrivilegedAction());
    }

    public static void saveNavTree() {
        AccessController.doPrivileged(new SaveNavTreePrivilegedAction());
    }

    private static void saveXml(XElem xml, BINavNode navNode) {
        if (navNode instanceof BNavFolder) {
            BNavFolder navFolder = (BNavFolder)navNode;
            XElem folderElem = new XElem("folder");
            xml.addContent((XContent)folderElem);
            folderElem.addAttr("name", navFolder.getNavName());
            folderElem.addAttr(ATTR_NAV_DESCRIPTION, navFolder.getNavDescriptionFormat());
            folderElem.addAttr("icon", String.valueOf(navFolder.getNavIcon()));
            folderElem.addAttr(ATTR_NAV_DISPLAY_FORMAT, navFolder.getNavDisplayFormat());
            Arrays.stream(navFolder.getNavChildren()).filter(childNavNode -> childNavNode instanceof BHost || childNavNode instanceof BNavFolder).forEach(childNavNode -> WbMain.saveXml(folderElem, childNavNode));
        } else if (navNode instanceof BHost) {
            BHost host = (BHost)navNode;
            XElem xhost = new XElem("host");
            xml.addContent((XContent)xhost);
            xhost.addAttr("ord", "" + host.getAbsoluteOrd());
            xhost.addAttr(ATTR_NAV_DISPLAY_FORMAT, host.getNavDisplayFormat());
            for (BISession session : host.getChildSessions()) {
                XElem xsession = new XElem("session");
                xhost.addContent((XContent)xsession);
                BSessionAgent agent = BSessionAgent.makeFor(session);
                if (agent == null) continue;
                xsession.addAttr("agent", agent.getType().toString());
                agent.pickle(session, xsession);
            }
        }
    }

    public static boolean isRemoved(NavEvent event, BOrd activeOrd) {
        if (event.getId() != 2 && event.getId() != 5) {
            return false;
        }
        if (activeOrd == null) {
            return false;
        }
        String activeOrdStr = activeOrd.toString();
        String removedOrdStr = event.getOldChildOrd().toString();
        return (activeOrdStr = TextUtil.toLowerCase((String)activeOrdStr)).equals(removedOrdStr = TextUtil.toLowerCase((String)removedOrdStr)) || activeOrdStr.startsWith(removedOrdStr + "/") || activeOrdStr.startsWith(removedOrdStr + "|");
    }

    public static boolean getLicenseAdmin() {
        return licenseAdmin;
    }

    public static String getLicenseName() {
        return licenseName;
    }

    public static String getLicenseCompany() {
        return licenseCompany;
    }

    public static String getLicenseEmail() {
        return licenseEmail;
    }

    public static String getLicenseInfo() {
        return licenseInfo;
    }

    public static void checkWorkbenchLicense() {
        WbMain.checkLicense(true);
    }

    public static void checkLicense() {
        WbMain.checkLicense(false);
    }

    private static void checkLicense(boolean workbenchOnly) {
        Throwable ex = null;
        try {
            if (workbenchOnly) {
                Sys.getLicenseManager().checkFeature("tridium", "workbenchAzul");
                Sys.getLicenseManager().checkFeature("tridium", "nre");
            } else {
                WbMain.doCheckLicense();
            }
            return;
        }
        catch (LicenseDatabaseException e) {
            e.printStackTrace();
            AccessController.doPrivileged(() -> Nre.getLicenseManager()).dump();
            ex = e;
        }
        catch (LicenseException e) {
            e.printStackTrace();
            AccessController.doPrivileged(() -> Nre.getLicenseManager()).dump();
        }
        catch (Throwable e) {
            e.printStackTrace();
            ex = e;
        }
        if (ex == null) {
            try {
                WbMain.getLicenseFromPortal();
                if (workbenchOnly) {
                    Sys.getLicenseManager().checkFeature("tridium", "workbenchAzul");
                    Sys.getLicenseManager().checkFeature("tridium", "nre");
                } else {
                    WbMain.doCheckLicense();
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                ex = e;
            }
        }
        String hostid = NreLib.getHostId();
        String title = UiLexicon.bajaui().getText("dialog.error");
        String msg = UiLexicon.bajaui().getText("license.error", new Object[]{hostid});
        BFrame frame = WbMain.makeLicenseFrame();
        frame.setContent((BWidget)new BLabel(defaultBrandTitle));
        frame.open();
        if (Sys.getLicenseManager() instanceof NodeLockedLicenseManager && ((NodeLockedLicenseManager)Sys.getLicenseManager()).isOldTridiumLicense()) {
            msg = UiLexicon.bajaui().getText("license.oldVersion.error", new Object[]{hostid});
        }
        BDialog.error((BWidget)frame, (String)title, (Object)msg, (Throwable)ex);
        System.exit(0);
    }

    private static void getLicenseFromPortal() {
        try {
            BModule module = Sys.loadModule((String)"portalApi");
            Class cls = module.loadClass("com.tridium.portal.wb.LicenseProcedure");
            Method m = cls.getMethod("licenseMe", new Class[0]);
            m.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static BFrame makeLicenseFrame() {
        int fw = 10;
        int fh = 10;
        BFrame frame = new BFrame(defaultBrandTitle);
        frame.setIconImage(BImage.make((String)defaultBrandIcon));
        frame.setScreenBounds(0.0, 0.0, (double)fw, (double)fh);
        frame.setBoundsCenteredOnScreen();
        return frame;
    }

    public static void doCheckLicense() throws Exception {
        PatternFilter[] profiles;
        Sys.getLicenseManager().checkFeature("tridium", "nre");
        Feature wb = Sys.getLicenseManager().checkFeature("tridium", "workbenchAzul");
        boolean profileLicensed = false;
        for (PatternFilter profile : profiles = PatternFilter.parseList((String)wb.get("profiles", "*"), (String)";")) {
            if (!profile.accept(defaultProfileType.toString())) continue;
            profileLicensed = true;
            break;
        }
        if (!profileLicensed) {
            throw new LocalizableException("workbench", "profileNotLicensed", new Object[]{defaultProfileType});
        }
        licenseAdmin = wb.getb("admin", false);
        Feature about = Sys.getLicenseManager().getFeature("tridium", "about");
        licenseName = about.get("project");
        licenseCompany = about.get("owner");
        licenseInfo = licenseName != null && licenseCompany != null ? licenseName + ", " + licenseCompany : (licenseName != null ? licenseName : (licenseCompany != null ? licenseCompany : null));
    }

    public static PatternFilter[] getLicensedProfiles() {
        Feature wb = Sys.getLicenseManager().checkFeature("tridium", "workbenchAzul");
        return PatternFilter.parseList((String)wb.get("profiles", "*"), (String)";");
    }

    public static void usage() {
        System.out.println("usage:");
        System.out.println("  wb [options] <ord>");
        System.out.println("parameters:");
        System.out.println("  ord              ; delimited list of initial ords to display");
        System.out.println("options:");
        System.out.println("  -profile:<type>  workbench:WbProfile to use");
        System.out.println("  -file:ord        initial file to display");
        System.out.println("  -locale:<x>      set the default locale (en_US)");
        System.out.println("  -theme:<string>  override the theme name for this instance of workbench");
        System.out.println("  -@<option>       pass option to Java VM");
    }

    public static void main(String[] strArgs) throws Exception {
        PatternFilter[] licensedProfiles;
        args = strArgs;
        CommandLineArguments args = new CommandLineArguments(strArgs);
        if (args.hasHelpOption()) {
            WbMain.usage();
            return;
        }
        WbMain.checkWorkbenchLicense();
        String profile = args.getOption("profile");
        String theme = args.getOption("theme");
        if (theme != null) {
            commandLineTheme = theme;
        }
        if (profile == null && (licensedProfiles = WbMain.getLicensedProfiles()).length == 1 && !licensedProfiles[0].hasWildChars()) {
            profile = licensedProfiles[0].getPattern();
        }
        if (profile != null) {
            try {
                defaultProfileType = Sys.getType((String)profile);
                System.out.println("-- Default profile: " + profile);
            }
            catch (Exception e) {
                System.out.println("ERROR: Invalid profile: " + profile);
                e.printStackTrace();
            }
        }
        WbMain.checkLicense();
        BOrdList[] ords = new BOrdList[args.parameters.length];
        if (args.parameters.length > 0) {
            for (int i = 0; i < args.parameters.length; ++i) {
                ords[i] = BOrdList.make((String)args.parameters[i].replace(';', '\n'));
            }
        } else if (args.hasOption("file")) {
            ords = new BOrdList[]{BOrdList.make((BOrd)BFileSystem.INSTANCE.localFileToOrd(new File(args.getOption("file"))))};
        }
        WbMain.boot();
        WbMain.checkSystemPassphraseForFIPS();
        WbMain.checkWbFipsMode(args);
        KeyRing kr = SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing();
        kr.checkRollKeyMaterial(KeyRing.KEY_MATERIAL_ROLL_INTERVAL);
        if (ords.length > 0) {
            for (BOrdList ord : ords) {
                WbMain.openFrame(null, ord, defaultProfileType);
            }
        } else {
            WbMain.openFrame(null, (BOrdList)null, defaultProfileType);
        }
        logger.info("startup complete (" + (System.currentTimeMillis() - Nre.bootTime) + "ms)");
    }

    private static void checkSystemPassphraseForFIPS() {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "fips140-2");
            int minPasswordLength = SecurityInitializer.getInstance().getSecurityInfoProvider().getDefaultMinimumPasswordLength();
            try (SecretChars systemPassword = PlatformUtil.getPlatformProvider().getSystemPassword();){
                if (systemPassword.size() < minPasswordLength) {
                    BChangeSystemPassphraseDialog.prompt(null);
                }
            }
        }
        catch (FeatureNotLicensedException featureNotLicensedException) {
            // empty catch block
        }
    }

    private static void checkWbFipsMode(CommandLineArguments args) {
        block5: {
            try {
                Sys.getLicenseManager().checkFeature("tridium", "fips140-2");
                if (!SecurityInitializer.getInstance().isFips()) {
                    if (!BFipsOptions.getOptions().getStartWorkbenchInFipsMode() || args.hasOption("fips=false")) {
                        Lexicon lex = Lexicon.make((String)"workbench");
                        String title = lex.getText("fips.warning.licensedButDisabled.title");
                        String msg = lex.getText("fips.warning.licensedButDisabled");
                        BDialog.warning(null, (String)title, (Object)msg);
                    } else {
                        logger.info("FIPS feature detected, restarting Workbench in FIPS mode");
                        WbMain.restart(true, null);
                    }
                }
            }
            catch (FeatureNotLicensedException e) {
                if (!args.hasOption("fips=true")) break block5;
                Lexicon lex = Lexicon.make((String)"workbench");
                String title = lex.getText("fips.warning.enabledButNotLicensed.title");
                String msg = lex.getText("fips.warning.enabledButNotLicensed");
                BDialog.warning(null, (String)title, (Object)msg);
                System.exit(0);
            }
        }
    }

    public static void boot() {
        if (!WbMain.isKiosk()) {
            WbMain.loadOptions();
            BNiagaraWbShell.history.load();
            WbMain.loadNavTree();
        }
        WbMain.loadBrand();
        Fox.hostName = Sys.getHostName();
        Fox.hostAddress = Sys.getLocalHost(null).getHostAddress();
        Fox.appName = "Workbench";
        Fox.appVersion = "" + Sys.getBajaVersion();
        JobMonitor.init();
        NavMonitor.init();
        BWbServiceManager.make().boot();
    }

    static void restart(boolean fips, BNiagaraWbFrame shell) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("wb");
        List arguments = AccessController.doPrivileged(() -> {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            return runtimeMxBean.getInputArguments();
        });
        for (String arg : arguments) {
            if (arg.startsWith("-D")) {
                if (!arg.startsWith("-Dcmdline::")) continue;
                cmd.add("-@D" + arg.substring("-Dcmdline::".length()));
                continue;
            }
            if (!arg.startsWith("-")) continue;
            cmd.add("-@" + arg.substring(1));
        }
        for (String arg : args) {
            if (arg.startsWith("-fips")) continue;
            cmd.add(arg);
        }
        try {
            if (fips) {
                cmd.add("-fips=true");
            } else {
                cmd.add("-fips=false");
            }
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.inheritIO();
            pb.start();
            System.out.flush();
            WbMain.exit(shell);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    static {
        licenseFilter = new AgentFilter(){

            public boolean include(AgentInfo agent) {
                if (licenseAdmin) {
                    return true;
                }
                return !NAgentInfo.isAdmin((AgentInfo)agent);
            }
        };
        Spy.ROOT.add("workbench", (Spy)new Page());
        defaultBrandTitle = "Niagara Workbench";
        defaultBrandSplash = "module://workbench/com/tridium/workbench/media/assets/images/splash-image.jpg";
        defaultBrandIcon = "module://icons/x32/workbench.png";
        defaultBrandFIPSBadge = "module://icons/x32/badges/fips.png";
        defaultBrandLogoImage = "module://workbench/com/tridium/workbench/media/assets/images/Tridium.png";
        defaultBrandLogoText = "Tridium";
        defaultBrandTitleImage = "module://workbench/com/tridium/workbench/media/assets/images/Niagara_Workbench.png";
        defaultBrandTitleText = "Niagara Workbench";
        defaultBrandCss = "module://workbench/com/tridium/workbench/media/blank.css";
        defaultThemeCss = "module://workbench/com/tridium/workbench/media/blank.css";
        FIPS_TITLE_SUFFIX = Lexicon.make((String)"workbench").get("fips.workbenchTitle.default");
        defaultProfileType = BWbProfile.TYPE;
        frameCount = 0;
        logger = Logger.getLogger("com.tridium.workbench.shell");
        NAVTREE_FILE = new File(Sys.getNiagaraUserHome(), "etc" + File.separator + "navTree.xml");
    }

    static class Page
    extends Spy {
        Page() {
        }

        public void write(SpyWriter out) throws Exception {
            out.startProps("Workbench");
            out.prop((Object)"brandTitle", (Object)brandTitle);
            out.prop((Object)"brandSplash", (Object)brandSplash);
            out.prop((Object)"brandIcon", (Object)brandIcon);
            out.prop((Object)"brandCss", (Object)brandCss);
            out.prop((Object)"brandLogoImage", (Object)brandLogoImage);
            out.prop((Object)"brandLogoText", (Object)brandLogoText);
            out.prop((Object)"brandTitleImage", (Object)brandTitleImage);
            out.prop((Object)"brandTitleText", (Object)brandTitleText);
            out.prop((Object)"defaultProfileType", (Object)defaultProfileType);
            out.prop((Object)"licenseAdmin", licenseAdmin);
            out.prop((Object)"licenseName", (Object)licenseName);
            out.prop((Object)"licenseCompany", (Object)licenseCompany);
            out.prop((Object)"licenseEmail", (Object)licenseEmail);
            out.prop((Object)"licenseInfo", (Object)licenseInfo);
            out.prop((Object)"frameCount", frameCount);
            out.endProps();
        }
    }

    private static class SaveNavTreePrivilegedAction
    implements PrivilegedAction<Void> {
        private SaveNavTreePrivilegedAction() {
        }

        @Override
        public Void run() {
            try {
                XElem xml = new XElem("navTree");
                Arrays.stream(BNavRoot.INSTANCE.getNavChildren()).filter(navNode -> navNode instanceof BHost || navNode instanceof BNavFolder).forEach(navNode -> WbMain.saveXml(xml, navNode));
                xml.write(NAVTREE_FILE);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot save navTree", e);
            }
            return null;
        }
    }

    private static class LoadNavTreePrivilegedAction
    implements PrivilegedAction<Void> {
        private LoadNavTreePrivilegedAction() {
        }

        @Override
        public Void run() {
            try {
                File file = NAVTREE_FILE;
                if (!file.exists()) {
                    return null;
                }
                XElem xml = XParser.make((File)file).parse();
                LoadNavTreePrivilegedAction.loadXml(xml, (BNavContainer)BNavRoot.INSTANCE);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot load navTree", e);
            }
            return null;
        }

        private static void loadXml(XElem xml, BNavContainer navContainer) {
            ArrayList<Object> orderedChildren = new ArrayList<Object>();
            for (XElem xhost : xml.elems()) {
                if (xhost.name().equals("folder")) {
                    String name = xhost.get("name");
                    BIcon icon = null;
                    String iconStr = xhost.get("icon", null);
                    if (iconStr != null) {
                        icon = BIcon.make((BOrd)BOrd.make((String)iconStr));
                    }
                    String navDisplayName = xhost.get(WbMain.ATTR_NAV_DISPLAY_FORMAT, null);
                    String description = xhost.get(WbMain.ATTR_NAV_DESCRIPTION, null);
                    BNavFolder navFolder = new BNavFolder(name, description, icon, navDisplayName);
                    navContainer.addNavChild((BINavNode)navFolder);
                    orderedChildren.add(navFolder);
                    LoadNavTreePrivilegedAction.loadXml(xhost, (BNavContainer)navFolder);
                }
                if (!xhost.name().equals("host")) continue;
                BOrd ord = BOrd.make((String)xhost.get("ord"));
                BHost host = (BHost)ord.get();
                BHost.move((BHost)host, (BNavContainer)navContainer);
                orderedChildren.add(host);
                try {
                    String navDisplayName = xhost.get(WbMain.ATTR_NAV_DISPLAY_FORMAT);
                    host.setNavDisplayName(navDisplayName);
                }
                catch (XException xException) {
                    // empty catch block
                }
                for (XElem xsession : xhost.elems("session")) {
                    String sessionAgent = xsession.get("agent");
                    try {
                        Type type = Sys.getType((String)sessionAgent);
                        if (type == null) continue;
                        BSessionAgent agent = (BSessionAgent)type.getInstance();
                        agent.unpickle(host, xsession);
                    }
                    catch (ModuleNotFoundException e) {
                        logger.warning("Missing Module for session agent: " + sessionAgent);
                    }
                    catch (TypeNotFoundException e) {
                        logger.warning("Missing Type for session agent: " + sessionAgent);
                    }
                }
            }
            if (navContainer.getNavChildren().length == orderedChildren.size()) {
                navContainer.reorderNavChildren(orderedChildren.toArray(new BINavNode[0]));
            }
        }
    }
}

