/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.util.regex.Pattern;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class OpenUtil {
    static Lexicon lex = Lexicon.make((String)"workbench");
    private static final Pattern colonsPattern = Pattern.compile(".*\\:.*");
    private static final Pattern dotLocalHostPattern = Pattern.compile(".*\\..*|http(s)?\\:\\/\\/localhost", 2);

    public static void openOrd(BNiagaraWbShell shell) throws Exception {
        String ord = shell.getActiveOrd().toString();
        ord = BDialog.prompt((BWidget)shell, (String)UiLexicon.bajaui().getText("commands.open.ord.label"), (String)ord, (int)70);
        if (ord != null) {
            if (!colonsPattern.matcher(ord).matches() && !dotLocalHostPattern.matcher(ord = "http://" + ord).matches()) {
                ord = ord + ".com";
            }
            shell.hyperlink(BOrd.make((String)ord));
        }
    }

    public static void openFile(BNiagaraWbShell shell) throws Exception {
        BOrd file;
        if (shell.fileChooser == null) {
            shell.fileChooser = BFileChooser.makeOpen((BWidget)shell);
        }
        if ((file = shell.fileChooser.show()) == null) {
            return;
        }
        shell.hyperlink(file);
    }

    public static void openDir(BNiagaraWbShell shell) throws Exception {
        BOrd file;
        if (shell.dirChooser == null) {
            shell.dirChooser = BDirectoryChooser.make((BWidget)shell);
        }
        if ((file = shell.dirChooser.show()) == null) {
            return;
        }
        shell.hyperlink(file);
    }

    public static void openQuery(BNiagaraWbShell shell) throws Exception {
        BOrd query;
        BObject base = null;
        try {
            OrdTarget target = shell.getActiveOrdTarget();
            if (target == null) {
                OpenUtil.makeErrorDisplay(shell);
                return;
            }
            base = target.get();
            base = BOrd.make((BOrd)shell.getActiveOrd(), (String)"station:|slot:/").resolve().get();
        }
        catch (Exception e) {
            if (!(e instanceof InvalidOrdBaseException)) {
                e.printStackTrace();
            }
            OpenUtil.makeErrorDisplay(shell);
            return;
        }
        if (shell.bqlBuilder == null) {
            shell.bqlBuilder = new BBqlQueryBuilder(base, BOrd.NULL);
        }
        if ((query = shell.bqlBuilder.open((BWidget)shell)) == null) {
            return;
        }
        shell.hyperlink(query);
    }

    public static void makeErrorDisplay(BNiagaraWbShell shell) {
        BGridPane text = new BGridPane(1);
        text.setRowGap(2.0);
        text.add(null, (BValue)new BLabel(lex.getText("open.query.line1"), Theme.widget().getBoldText()));
        text.add(null, (BValue)new BLabel(lex.getText("open.query.line2")));
        BGridPane pane = new BGridPane(2);
        pane.setColumnGap(5.0);
        pane.add(null, (BValue)new BLabel(BImage.make((String)"module://icons/x32/error.png")));
        pane.add(null, (BValue)text);
        BDialog.open((BWidget)shell, (String)"Error", (Object)new BBorderPane((BWidget)pane), (int)1);
        shell.bqlBuilder = null;
    }
}

