/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.theme.Theme;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;

@NiagaraType
public class BScrollingWidgetPane
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BScrollingWidgetPane.class);
    private ScrollThread scrollThread;
    private static final int FRAMES = 7;
    private static final int TICK_INTERVAL = 7;
    private double leftEdge;
    private double rightEdge;
    private double scrollSpeed;
    private BAbstractButton leftButton;
    private BAbstractButton rightButton;
    protected BGridPane gridPane;
    private int scroll;
    private BWidget widget;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BScrollingWidgetPane() {
        throw new IllegalStateException();
    }

    public BScrollingWidgetPane(BWidget widget) {
        this(1, widget);
    }

    public BScrollingWidgetPane(BWidget widget, double scrollSpeed) {
        this(widget);
        this.setScrollSpeed(scrollSpeed);
    }

    protected BScrollingWidgetPane(int size, BWidget widget) {
        this.widget = widget;
        this.leftButton = BAbstractButton.make((Command)new MoveLeftCommand(), (boolean)false, (boolean)true);
        this.leftButton.setButtonStyle(BButtonStyle.toolBar);
        this.rightButton = BAbstractButton.make((Command)new MoveRightCommand(), (boolean)false, (boolean)true);
        this.rightButton.setButtonStyle(BButtonStyle.toolBar);
        this.gridPane = new BGridPane(size);
        this.gridPane.setHalign(BHalign.center);
        this.gridPane.setColumnGap(0.0);
        this.gridPane.setRowAlign(BValign.fill);
        this.gridPane.add("fixed", (BValue)widget);
        this.setCenter((BWidget)this.gridPane);
        this.showHide();
        this.scrollSpeed = Theme.toolBar().getScrollSpeed();
    }

    public BWidget getWidget() {
        return this.widget;
    }

    public void doLayout(BWidget[] children) {
        this.gridPane.doLayout(this.gridPane.getChildWidgets());
        super.doLayout(children);
        this.reset();
        this.showHide();
    }

    private void showHide() {
        boolean changed = false;
        if (this.rightEdge > this.getWidth()) {
            if (this.getLeft().isNull()) {
                this.setLeft((BWidget)this.leftButton);
                changed = true;
            }
            if (this.getRight().isNull()) {
                this.setRight((BWidget)this.rightButton);
                changed = true;
            }
        } else {
            if (!this.getLeft().isNull()) {
                this.setLeft((BWidget)new BNullWidget());
                changed = true;
            }
            if (!this.getRight().isNull()) {
                this.setRight((BWidget)new BNullWidget());
                changed = true;
            }
        }
        if (changed) {
            this.doLayout(this.getChildWidgets());
        }
    }

    private void reset() {
        this.leftEdge = 0.0;
        this.rightEdge = this.getMaxX();
        this.updateButtonStatus();
    }

    public void setScrollSpeed(double scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    private void startScroll() {
        if (this.scrollThread == null && this.scroll != 0) {
            this.scrollThread = new ScrollThread(this.gridPane.getChildWidgets());
            this.scrollThread.start();
        }
    }

    public void scrollLeft() {
        --this.scroll;
        this.startScroll();
    }

    public void scrollRight() {
        ++this.scroll;
        this.startScroll();
    }

    public void mouseWheel(BMouseWheelEvent event) {
        int rot = event.getWheelRotation();
        if (rot > 0) {
            this.scrollLeft();
        } else {
            this.scrollRight();
        }
    }

    private boolean canScrollLeft() {
        return this.rightEdge > this.gridPane.getWidth();
    }

    private boolean canScrollRight() {
        return this.leftEdge < 0.0;
    }

    private void updateButtonStatus() {
        this.leftButton.setEnabled(this.canScrollRight());
        this.rightButton.setEnabled(this.canScrollLeft());
    }

    private double getMaxX() {
        double max = 0.0;
        BWidget[] kids = this.gridPane.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            BWidget kid = kids[i];
            double x = kid.getX() + kid.getWidth();
            if (!(x > max)) continue;
            max = x;
        }
        return max;
    }

    private class MoveRightCommand
    extends Command {
        public MoveRightCommand() {
            super((BWidget)BScrollingWidgetPane.this, UiLexicon.bajaui().module, "commands.moveRight");
        }

        public CommandArtifact doInvoke() {
            BScrollingWidgetPane.this.scrollLeft();
            return null;
        }
    }

    private class MoveLeftCommand
    extends Command {
        public MoveLeftCommand() {
            super((BWidget)BScrollingWidgetPane.this, UiLexicon.bajaui().module, "commands.moveLeft");
        }

        public CommandArtifact doInvoke() {
            BScrollingWidgetPane.this.scrollRight();
            return null;
        }
    }

    private class ScrollThread
    extends Thread {
        private BWidget[] widgets;

        public ScrollThread(BWidget[] widgets) {
            super("Ui:BScrollingToolbarPane.ScrollThread");
            this.widgets = widgets;
        }

        private double getLeftScroll() {
            double maxScroll = BScrollingWidgetPane.this.rightEdge - BScrollingWidgetPane.this.gridPane.getWidth();
            return -Math.min(maxScroll, BScrollingWidgetPane.this.scrollSpeed);
        }

        private double getRightScroll() {
            return Math.min(Math.abs(BScrollingWidgetPane.this.leftEdge), BScrollingWidgetPane.this.scrollSpeed);
        }

        private int[][] makeIntervals(double distance) {
            int i;
            int[][] intervals = new int[this.widgets.length][];
            double[] xdeltas = new double[7];
            for (i = 0; i < 7; ++i) {
                xdeltas[i] = distance * (double)(i + 1) / 7.0;
            }
            for (i = 0; i < this.widgets.length; ++i) {
                int[] ints = new int[7];
                for (int j = 0; j < 7; ++j) {
                    ints[j] = (int)(this.widgets[i].getX() + xdeltas[j]);
                }
                intervals[i] = ints;
            }
            return intervals;
        }

        private void doScroll(int[][] intervals) {
            for (int j = 0; j < 7; ++j) {
                for (int i = 0; i < this.widgets.length; ++i) {
                    BWidget widget = this.widgets[i];
                    widget.setBounds((double)intervals[i][j], widget.getY(), widget.getWidth(), widget.getHeight());
                }
                BScrollingWidgetPane.this.repaint();
                try {
                    Thread.sleep(7L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            BScrollingWidgetPane.this.updateButtonStatus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (BScrollingWidgetPane.this.scroll != 0) {
                    int inc;
                    double distance;
                    if (BScrollingWidgetPane.this.scroll < 0 && BScrollingWidgetPane.this.canScrollLeft()) {
                        distance = this.getLeftScroll();
                        inc = 1;
                    } else {
                        if (BScrollingWidgetPane.this.scroll <= 0 || !BScrollingWidgetPane.this.canScrollRight()) {
                            BScrollingWidgetPane.this.scroll = 0;
                            break;
                        }
                        distance = this.getRightScroll();
                        inc = -1;
                    }
                    BScrollingWidgetPane.this.leftEdge = BScrollingWidgetPane.this.leftEdge + distance;
                    BScrollingWidgetPane.this.rightEdge = BScrollingWidgetPane.this.rightEdge + distance;
                    BScrollingWidgetPane.this.scroll = BScrollingWidgetPane.this.scroll + inc;
                    this.doScroll(this.makeIntervals(distance));
                }
            }
            finally {
                BScrollingWidgetPane.this.scroll = 0;
                BScrollingWidgetPane.this.scrollThread = null;
            }
        }
    }
}

