/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.px;

import com.tridium.ui.util.ValidationUtil;
import com.tridium.workbench.px.BOnMediaMigrationError;
import com.tridium.workbench.px.PxFileMediaMigrator;
import com.tridium.workbench.px.PxFileMigrator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BPxView;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.ui.px.BPxMedia;
import javax.baja.util.BTypeSpec;
import javax.baja.util.CannotValidateException;
import javax.baja.util.LexiconModule;

public class PxViewMediaMigrator {
    private BTypeSpec media;
    private boolean dryRun = true;
    private BOnMediaMigrationError onValidationError = BOnMediaMigrationError.abort;
    protected static final Logger LOG = Logger.getLogger(PxFileMigrator.class.getName());
    private static final LexiconModule LEX = LexiconModule.make((String)"workbench");

    public static CompletableFuture<Void> migrateToMedia(PxViewMediaMigrator migrator, BOrd rootComponentOrd, boolean skipFrozenViews, Context cx) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        Runnable r = () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CASE], 7[SWITCH]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
        new Thread(r, "PxViewMediaMigrator.migrateToMedia").start();
        return promise;
    }

    public void migratePxView(BAbstractPxView view, boolean skipFrozenViews, Context cx) throws Exception {
        if (!PxViewMediaMigrator.isMigratable(view, skipFrozenViews)) {
            return;
        }
        if (view instanceof BPxView) {
            OrdTarget target = ((BPxView)view).getPxFile().resolve((BObject)BLocalHost.INSTANCE, cx);
            this.processTarget(target, view, cx);
        } else {
            BComponent parent = view.getParentComponent();
            if (parent == null) {
                return;
            }
            this.processTarget(OrdTarget.unmounted((BObject)parent, (Context)cx), view, cx);
        }
    }

    private static boolean isMigratable(BAbstractPxView view, boolean skipFrozenViews) {
        if (view == null) {
            return false;
        }
        try {
            if (view.getType().is(Sys.getType((String)"niagaraDriver:AbstractSubstitutePxView"))) {
                return false;
            }
            Property p = view.getPropertyInParent();
            if (skipFrozenViews && p != null && p.isFrozen()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !Flags.isReadonly((BComplex)view, (Slot)view.getSlot(BAbstractPxView.media.getName()));
    }

    public PxViewMediaMigrator inDryRunMode(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public PxViewMediaMigrator onValidationError(String onValidationError) {
        return this.onValidationError(BOnMediaMigrationError.make(onValidationError));
    }

    public PxViewMediaMigrator onValidationError(BOnMediaMigrationError onValidationError) {
        this.onValidationError = onValidationError;
        return this;
    }

    public PxViewMediaMigrator toMedia(BTypeSpec media) {
        this.media = media;
        return this;
    }

    private static BOrd getNavOrd(BAbstractPxView pxView) {
        BComponent parent = pxView.getParentComponent();
        return parent == null ? null : parent.getNavOrd();
    }

    private void processTarget(OrdTarget target, BAbstractPxView view, Context cx) throws Exception {
        BOrd pxViewOrd = PxViewMediaMigrator.getNavOrd(view);
        Map warnings = ValidationUtil.getValidationWarnings((BPxMedia)((BPxMedia)this.media.getInstance()), (OrdTarget)target, (BAbstractPxView)view, (Context)cx);
        if (warnings.isEmpty()) {
            PxViewMediaMigrator.logSuccess(view.getName(), pxViewOrd, cx);
            if (!this.dryRun) {
                view.setMedia(this.media);
            }
        } else {
            String warningString = PxFileMediaMigrator.warningsToString(warnings);
            this.logViewError(view.getName(), pxViewOrd, warningString, cx);
            switch (this.onValidationError.getOrdinal()) {
                case 0: {
                    if (this.dryRun) break;
                    view.setMedia(this.media);
                    break;
                }
                case 1: {
                    return;
                }
                case 2: {
                    throw new CannotValidateException(warningString);
                }
            }
        }
    }

    private static void logSuccess(String viewName, BOrd pxViewOrd, Context cx) {
        LOG.log(Level.INFO, LEX.getText("pxViewMediaMigration.validationSuccessful.write", cx, new Object[]{viewName, pxViewOrd}));
    }

    public void logViewError(String viewName, BOrd pxViewOrd, String validationWarnings, Context cx) {
        LOG.log(Level.SEVERE, LEX.getText(this.getViewKey(), cx, new Object[]{viewName, pxViewOrd, validationWarnings}));
    }

    private String getViewKey() {
        switch (this.onValidationError.getOrdinal()) {
            case 0: {
                return "pxViewMediaMigration.validationError.write";
            }
            case 1: {
                return "pxViewMediaMigration.validationError.skip";
            }
            case 2: {
                return "pxViewMediaMigration.validationError.abort";
            }
        }
        throw new RuntimeException("unrecognized enum");
    }
}

