/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav.editor;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.nav.editor.BNavTable;
import com.tridium.workbench.nav.editor.BSourceTable;
import com.tridium.workbench.nav.editor.Node;
import com.tridium.workbench.nav.editor.TransferSupport;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.WbCommands;
import java.io.InputStream;
import java.util.ArrayList;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSelection;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

@NiagaraType(agent={@AgentOn(types={"file:NavFile"}, requiredPermissions="W")})
public class BNavFileEditor
extends BWbView {
    @Generated
    public static final Type TYPE = Sys.loadType(BNavFileEditor.class);
    static BModule module = Sys.getModuleForClass(BNavFileEditor.class);
    static Lexicon lex = Lexicon.make((String)"workbench");
    static String lexErrBig = BNavFileEditor.text("error.big");
    static String lexErrSmall = BNavFileEditor.text("error.small");
    static String lexOpenText = BNavFileEditor.text("openTextEditor");
    static String lexName = BNavFileEditor.text("displayName");
    static String lexOrd = BNavFileEditor.text("targetOrd");
    static String lexIcon = BNavFileEditor.text("icon");
    static BImage warning = BImage.make((String)"module://icons/x32/warning.png");
    static String defaultName = BNavFileEditor.text("defaultName");
    static BOrd defaultOrd = BOrd.make((String)"station:|slot:/");
    static BImage defaultIcon = BImage.make((String)"module://icons/x16/folder.png");
    BWidget sourceParent;
    BWidget resultParent;
    BSplitPane split;
    BSourceTable source;
    Model model;
    Node[] dragNodes;
    TransferSupport txSupport;
    WbCommands commands;
    NewCommand newCommand;
    EditCommand editCommand;
    MoveUpCommand moveUpCommand;
    MoveDownCommand moveDownCommand;
    ShowComponentsCommand showComponents;
    ShowFilesCommand showFiles;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    private void buildInterface() {
        this.commands = ((BNiagaraWbShell)this.getWbShell()).commands;
        this.txSupport = new TransferSupport(this);
        this.source = new BSourceTable(this);
        BNavTable table = new BNavTable(this);
        this.model = new Model();
        table.setModel((TableModel)this.model);
        table.setSelection((TableSelection)new Selection());
        table.setController((TableController)new Controller());
        BGridPane botCmds = new BGridPane(8);
        this.newCommand = new NewCommand(this, null);
        botCmds.add(null, (BValue)new BButton((Command)this.newCommand));
        this.editCommand = new EditCommand(this);
        botCmds.add(null, (BValue)new BButton((Command)this.editCommand));
        botCmds.add(null, (BValue)new BButton(this.commands.delete));
        this.moveUpCommand = new MoveUpCommand(this);
        botCmds.add(null, (BValue)new BButton((Command)this.moveUpCommand));
        this.moveDownCommand = new MoveDownCommand(this);
        botCmds.add(null, (BValue)new BButton((Command)this.moveDownCommand));
        botCmds.add(null, (BValue)new BBorderPane((BWidget)new BNullWidget(), 0.0, 0.0, 0.0, 10.0));
        this.showComponents = new ShowComponentsCommand(this);
        botCmds.add(null, (BValue)new BToggleButton((Command)this.showComponents));
        this.showFiles = new ShowFilesCommand(this);
        botCmds.add(null, (BValue)new BToggleButton((Command)this.showFiles));
        this.sourceParent = BTitlePane.makePane((String)BNavFileEditor.text("source"), (BTable)this.source);
        this.resultParent = BTitlePane.makePane((String)BNavFileEditor.text("result"), (BTable)table);
        this.split = new BSplitPane(BOrientation.vertical, 50.0);
        this.split.setWidget1(this.sourceParent);
        BEdgePane content = new BEdgePane();
        content.setCenter(this.resultParent);
        content.setBottom((BWidget)new BBorderPane((BWidget)botCmds, 5.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)content);
    }

    BEdgePane content() {
        return (BEdgePane)this.getContent();
    }

    void toggleSource() {
        if (this.resultParent.getParentWidget() == this.split) {
            this.split.setWidget2((BWidget)new BNullWidget());
            this.content().setCenter(this.resultParent);
            this.relayout();
        } else {
            this.content().setCenter((BWidget)new BNullWidget());
            this.split.setWidget2(this.resultParent);
            this.content().setCenter((BWidget)this.split);
            this.relayout();
        }
    }

    void computeSourceVisible() {
        if (this.showComponents.isSelected() || this.showFiles.isSelected()) {
            if (this.resultParent.getParentWidget() != this.split) {
                this.toggleSource();
            }
        } else if (this.resultParent.getParentWidget() == this.split) {
            this.toggleSource();
        }
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BIFile file = (BIFile)value;
        if (file.getFileSpace() == BFileSystem.INSTANCE) {
            BLabel i = new BLabel(warning);
            BLabel a = new BLabel(lexErrBig, Theme.widget().getLargeBoldFont());
            BLabel b = new BLabel(lexErrSmall);
            BButton button = new BButton((Command)new OpenTextEditor(this));
            BGridPane g = new BGridPane(1);
            g.setRowGap(0.0);
            g.add(null, (BValue)a);
            g.add(null, (BValue)b);
            BGridPane g2 = new BGridPane(2);
            g2.setColumnGap(5.0);
            g2.add(null, (BValue)i);
            g2.add(null, (BValue)g);
            BGridPane g3 = new BGridPane(1);
            g3.setRowGap(10.0);
            g3.setColumnAlign(BHalign.center);
            g3.add(null, (BValue)g2);
            g3.add(null, (BValue)button);
            this.setContent((BWidget)g3);
        } else {
            this.buildInterface();
            XParser parser = XParser.make((InputStream)file.getInputStream());
            XElem root = parser.parse();
            XElem[] kids = root.elems();
            if (kids.length > 0) {
                this.model.root = this.parseNode(null, kids[0]);
            }
            new ExpandAllCommand(this, this.model.root).invoke();
            this.model.getSelection().updateTable();
            this.setTransferWidget((BTransferWidget)this.model.getTreeTable());
        }
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BIFile file = (BIFile)value;
        XWriter out = new XWriter(file.getOutputStream());
        out.prolog();
        out.w((Object)"<nav version='1.0'>\n");
        if (this.model.root != null) {
            this.writeNode(out, this.model.root, 0);
        }
        out.w((Object)"</nav>\n");
        out.close();
        return value;
    }

    private Node parseNode(Node parent, XElem elem) {
        String name = elem.get("name", "");
        String ord = elem.get("ord", "null");
        String icon = elem.get("icon", "module://icons/x16/folder.png");
        Node node = null;
        node = parent == null ? new Node(this.model, name, BOrd.make((String)ord), BImage.make((String)icon)) : new Node(parent, name, BOrd.make((String)ord), BImage.make((String)icon));
        XElem[] kids = elem.elems();
        for (int i = 0; i < kids.length; ++i) {
            node.kids.add(this.parseNode(node, kids[i]));
        }
        return node;
    }

    private void writeNode(XWriter out, Node node, int indent) {
        out.indent(indent).w((Object)"<node");
        out.w((Object)" name='").safe(node.name).w((Object)"'");
        out.w((Object)" ord='").safe(node.ord.toString()).w((Object)"'");
        out.w((Object)" icon='").safe(node.icon.getOrdList().get(0).toString()).w((Object)"'");
        if (node.kids.size() > 0) {
            out.w((Object)">\n");
            for (int i = 0; i < node.kids.size(); ++i) {
                this.writeNode(out, node.kids.get(i), indent + 2);
            }
            out.indent(indent).w((Object)"</node>\n");
        } else {
            out.w((Object)"/>\n");
        }
    }

    Node findNode(String[] path) {
        Node node = this.model.root;
        block0: for (int i = 1; i < path.length; ++i) {
            for (int j = 0; j < node.kids.size(); ++j) {
                Node n = node.kids.get(j);
                if (!n.name.equals(path[i])) continue;
                node = n;
                continue block0;
            }
        }
        return node;
    }

    String[] toPath(Node node) {
        ArrayList<String> list = new ArrayList<String>();
        while (node != null) {
            list.add(0, node.name);
            node = (Node)node.getParent();
        }
        return list.toArray(new String[0]);
    }

    boolean sameParent(int[] rows) {
        if (rows.length == 0) {
            return false;
        }
        Node node = (Node)this.model.rowToNode(rows[0]);
        Node parent = (Node)node.getParent();
        for (int i = 1; i < rows.length; ++i) {
            node = (Node)this.model.rowToNode(rows[i]);
            if (parent == node.getParent()) continue;
            return false;
        }
        return true;
    }

    boolean isValidName(Node parent, String name) {
        for (int i = 0; i < parent.kids.size(); ++i) {
            Node node = parent.kids.get(i);
            if (!node.name.equals(name)) continue;
            return false;
        }
        return true;
    }

    String getValidName(Node parent, String name) {
        int counter = 1;
        String temp = name;
        for (int i = 0; i < parent.kids.size(); ++i) {
            Node node = parent.kids.get(i);
            if (!node.name.equals(temp)) continue;
            temp = name + counter++;
            i = -1;
        }
        return temp;
    }

    DragRenderer makeDragRenderer() {
        int[] rows = this.model.getSelection().getRows();
        if (rows.length == 0 || !this.sameParent(rows)) {
            return null;
        }
        this.dragNodes = new Node[rows.length];
        BImage[] icons = new BImage[rows.length];
        String[] names = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] == 0) {
                return null;
            }
            Node node = (Node)this.model.rowToNode(rows[i]);
            icons[i] = node.icon;
            names[i] = node.name;
            this.dragNodes[i] = node;
        }
        SimpleDragRenderer dr = new SimpleDragRenderer(icons, names);
        dr.font = Theme.table().getCellFont();
        dr.xCursorOffset = 0.0;
        dr.yCursorOffset = 0.0;
        return dr;
    }

    CommandArtifact insertTransferData(TransferContext cx, boolean onSelection) throws Exception {
        int row;
        int[] rows;
        Object target = onSelection ? ((rows = this.model.getSelection().getRows()).length == 0 ? this.model.root : (Node)this.model.rowToNode(rows[0])) : ((row = this.model.getTable().getRowAt(cx.getY())) == -1 && this.model.root == null ? null : (Node)this.model.rowToNode(row == -1 ? 0 : row));
        return this.txSupport.insert((Node)((Object)target), cx);
    }

    String toNodeName(BINavNode nav) {
        int i;
        String n = nav.getNavDisplayName(this.getCurrentContext());
        if (nav instanceof BIFile && (i = n.lastIndexOf(".")) != -1) {
            n = n.substring(0, i);
        }
        return n;
    }

    private void reorder(Node parent, String[] kids, boolean[] sel) {
        parent.setExpanded(true);
        this.model.getSelection().deselectAll();
        for (int i = 0; i < kids.length; ++i) {
            for (int j = 0; j < parent.kids.size(); ++j) {
                Node n = parent.kids.get(j);
                if (!n.name.equals(kids[i])) continue;
                parent.kids.remove((Object)n);
                parent.kids.add(i, n);
                if (!sel[i]) continue;
                this.model.updateTreeTable(false);
                this.model.getSelection().select(this.model.nodeToRow(n));
            }
        }
        this.model.updateTreeTable(true);
        this.setModified();
    }

    static String text(String s) {
        return lex.getText("navFileEditor." + s);
    }

    class Snapshot {
        public String name;
        public BOrd ord;
        public BImage icon;

        public Snapshot(String name, BOrd ord, BImage icon) {
            this.name = name;
            this.ord = ord;
            this.icon = icon;
        }
    }

    class CollapseAllCommand
    extends Command {
        Node node;

        public CollapseAllCommand(BWidget owner, Node node) {
            super(owner, module, "navFileEditor.collapseAll");
            this.node = node;
        }

        public CommandArtifact doInvoke() {
            if (this.node != null) {
                this.collapse(this.node);
            }
            return null;
        }

        public void collapse(Node node) {
            node.setExpanded(false);
            for (int i = 0; i < node.kids.size(); ++i) {
                this.collapse(node.kids.get(i));
            }
        }
    }

    class ExpandAllCommand
    extends Command {
        Node node;

        public ExpandAllCommand(BWidget owner, Node node) {
            super(owner, module, "navFileEditor.expandAll");
            this.node = node;
        }

        public CommandArtifact doInvoke() {
            if (this.node != null) {
                this.expand(this.node);
            }
            return null;
        }

        public void expand(Node node) {
            node.setExpanded(true);
            for (int i = 0; i < node.kids.size(); ++i) {
                this.expand(node.kids.get(i));
            }
        }
    }

    class ReorderArtifact
    implements CommandArtifact {
        String[] path;
        String[] oldOrder;
        String[] newOrder;
        boolean[] oldSel;
        boolean[] newSel;

        public ReorderArtifact(String[] path, String[] oldOrder, String[] newOrder, boolean[] oldSel, boolean[] newSel) {
            this.path = path;
            this.oldOrder = oldOrder;
            this.newOrder = newOrder;
            this.oldSel = oldSel;
            this.newSel = newSel;
        }

        public void undo() throws Exception {
            Node parent = BNavFileEditor.this.findNode(this.path);
            BNavFileEditor.this.reorder(parent, this.oldOrder, this.oldSel);
        }

        public void redo() throws Exception {
            Node parent = BNavFileEditor.this.findNode(this.path);
            BNavFileEditor.this.reorder(parent, this.newOrder, this.newSel);
        }
    }

    class MoveDownCommand
    extends Command {
        public MoveDownCommand(BWidget owner) {
            super(owner, module, "navFileEditor.moveDown");
        }

        public CommandArtifact doInvoke() throws Exception {
            int[] rows = BNavFileEditor.this.model.getSelection().getRows();
            if (BNavFileEditor.this.sameParent(rows)) {
                Node node;
                int i;
                Node parent = (Node)BNavFileEditor.this.model.rowToNode(rows[0]).getParent();
                String[] no = new String[parent.kids.size()];
                String[] oo = new String[parent.kids.size()];
                boolean[] os = new boolean[oo.length];
                boolean[] ns = new boolean[no.length];
                for (i = 0; i < oo.length; ++i) {
                    node = parent.kids.get(i);
                    oo[i] = node.name;
                    no[i] = node.name;
                    ns[i] = false;
                    os[i] = false;
                }
                for (i = rows.length - 1; i >= 0; --i) {
                    node = (Node)BNavFileEditor.this.model.rowToNode(rows[i]);
                    int index = parent.kids.indexOf((Object)node);
                    if (index == parent.kids.size() - 1) {
                        if (i != rows.length - 1) break;
                        return null;
                    }
                    String temp = no[index];
                    no[index] = no[index + 1];
                    no[index + 1] = temp;
                    os[index] = true;
                    ns[index + 1] = true;
                }
                ReorderArtifact art = new ReorderArtifact(BNavFileEditor.this.toPath(parent), oo, no, os, ns);
                art.redo();
                return art;
            }
            return null;
        }
    }

    class MoveUpCommand
    extends Command {
        public MoveUpCommand(BWidget owner) {
            super(owner, module, "navFileEditor.moveUp");
        }

        public CommandArtifact doInvoke() throws Exception {
            int[] rows = BNavFileEditor.this.model.getSelection().getRows();
            if (BNavFileEditor.this.sameParent(rows)) {
                Node node;
                int i;
                Node parent = (Node)BNavFileEditor.this.model.rowToNode(rows[0]).getParent();
                String[] no = new String[parent.kids.size()];
                String[] oo = new String[parent.kids.size()];
                boolean[] os = new boolean[oo.length];
                boolean[] ns = new boolean[no.length];
                for (i = 0; i < oo.length; ++i) {
                    node = parent.kids.get(i);
                    oo[i] = node.name;
                    no[i] = node.name;
                    ns[i] = false;
                    os[i] = false;
                }
                for (i = 0; i < rows.length; ++i) {
                    node = (Node)BNavFileEditor.this.model.rowToNode(rows[i]);
                    int index = parent.kids.indexOf((Object)node);
                    if (index == 0) {
                        if (i != 0) break;
                        return null;
                    }
                    String temp = no[index - 1];
                    no[index - 1] = no[index];
                    no[index] = temp;
                    os[index] = true;
                    ns[index - 1] = true;
                }
                ReorderArtifact art = new ReorderArtifact(BNavFileEditor.this.toPath(parent), oo, no, os, ns);
                art.redo();
                return art;
            }
            return null;
        }
    }

    class EditCommand
    extends Command {
        public EditCommand(BWidget owner) {
            super(owner, module, "navFileEditor.edit");
        }

        public CommandArtifact doInvoke() {
            int[] rows = BNavFileEditor.this.model.getSelection().getRows();
            if (rows.length > 0) {
                Node node = (Node)BNavFileEditor.this.model.rowToNode(rows[0]);
                String title = rows.length == 1 ? BNavFileEditor.text("edit.label") : BNavFileEditor.text("editMultiple");
                BTextField name = new BTextField(node.name, 40);
                BWbFieldEditor ord = BWbFieldEditor.makeFor((BObject)node.ord);
                BWbFieldEditor icon = BWbFieldEditor.makeFor((BObject)node.icon);
                ord.loadValue((BObject)node.ord, (Context)new BasicContext(BNavFileEditor.this.getCurrentContext(), BFacets.make((String)"chooseView", (boolean)true)));
                icon.loadValue((BObject)node.icon, BNavFileEditor.this.getCurrentContext());
                BGridPane grid = new BGridPane(2);
                grid.setHalign(BHalign.left);
                grid.add(null, (BValue)new BLabel(lexName));
                grid.add(null, (BValue)name);
                grid.add(null, (BValue)new BLabel(lexOrd));
                grid.add(null, (BValue)ord);
                grid.add(null, (BValue)new BLabel(lexIcon));
                grid.add(null, (BValue)icon);
                BBorderPane pane = new BBorderPane((BWidget)grid);
                BConstrainedPane cons = new BConstrainedPane((BWidget)pane);
                cons.setMinWidth(700.0);
                if (1 == BDialog.open((BWidget)this.getOwner(), (String)title, (Object)cons, (int)3)) {
                    Node parent = (Node)node.getParent();
                    if (parent != null && !BNavFileEditor.this.isValidName(parent, name.getText()) && !node.name.equals(name.getText())) {
                        BDialog.error((BWidget)this.getOwner(), (String)"", (Object)BNavFileEditor.text("namingError"));
                        return BNavFileEditor.this.editCommand.doInvoke();
                    }
                    try {
                        Snapshot on = new Snapshot(node.name, node.ord, node.icon);
                        Snapshot nn = new Snapshot(name.getText(), (BOrd)ord.saveValue(), (BImage)icon.saveValue());
                        Artifact art = new Artifact(BNavFileEditor.this.toPath(node), on, nn);
                        art.redo();
                        return art;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }

        class Artifact
        implements CommandArtifact {
            String[] oldPath;
            String[] newPath;
            Snapshot oldNode;
            Snapshot newNode;

            public Artifact(String[] path, Snapshot on, Snapshot nn) {
                this.newPath = path;
                this.oldPath = new String[path.length];
                for (int i = 0; i < path.length; ++i) {
                    this.oldPath[i] = path[i];
                }
                this.oldPath[this.oldPath.length - 1] = nn.name;
                this.oldNode = on;
                this.newNode = nn;
            }

            public void undo() throws Exception {
                Node n = BNavFileEditor.this.findNode(this.oldPath);
                n.name = this.oldNode.name;
                n.ord = this.oldNode.ord;
                n.icon = this.oldNode.icon;
                BNavFileEditor.this.model.updateTreeTable(true);
                BNavFileEditor.this.setModified();
            }

            public void redo() throws Exception {
                Node n = BNavFileEditor.this.findNode(this.newPath);
                n.name = this.newNode.name;
                n.ord = this.newNode.ord;
                n.icon = this.newNode.icon;
                BNavFileEditor.this.model.updateTreeTable(true);
                BNavFileEditor.this.setModified();
            }
        }
    }

    class NewCommand
    extends Command {
        private Node parent;
        private Node child;

        public NewCommand(BWidget owner, Node parent) {
            super(owner, module, "navFileEditor.new");
            this.parent = parent;
        }

        public CommandArtifact doInvoke() throws Exception {
            BTextField name = new BTextField(defaultName, 40);
            BWbFieldEditor ord = BWbFieldEditor.makeFor((BObject)defaultOrd);
            BWbFieldEditor icon = BWbFieldEditor.makeFor((BObject)defaultIcon);
            ord.loadValue((BObject)defaultOrd, (Context)new BasicContext(BNavFileEditor.this.getCurrentContext(), BFacets.make((String)"chooseView", (boolean)true)));
            icon.loadValue((BObject)defaultIcon, BNavFileEditor.this.getCurrentContext());
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(lexName));
            grid.add(null, (BValue)name);
            grid.add(null, (BValue)new BLabel(lexOrd));
            grid.add(null, (BValue)ord);
            grid.add(null, (BValue)new BLabel(lexIcon));
            grid.add(null, (BValue)icon);
            BBorderPane pane = new BBorderPane((BWidget)grid);
            if (1 != BDialog.open((BWidget)this.getOwner(), (String)BNavFileEditor.text("new.label"), (Object)pane, (int)3)) {
                return null;
            }
            Node temp = this.parent;
            if (temp == null) {
                int[] rows = BNavFileEditor.this.model.getSelection().getRows();
                temp = rows.length == 0 ? BNavFileEditor.this.model.root : (Node)BNavFileEditor.this.model.rowToNode(rows[0]);
            }
            String n = BNavFileEditor.this.getValidName(temp, name.getText());
            BOrd o = (BOrd)ord.saveValue();
            BImage i = (BImage)icon.saveValue();
            Artifact art = new Artifact(BNavFileEditor.this.toPath(temp), new Snapshot(n, o, i));
            art.redo();
            return art;
        }

        class Artifact
        implements CommandArtifact {
            String[] parent;
            Snapshot snap;

            public Artifact(String[] parent, Snapshot snap) {
                this.parent = parent;
                this.snap = snap;
            }

            public void undo() throws Exception {
                Node p = BNavFileEditor.this.findNode(this.parent);
                for (int i = 0; i < p.kids.size(); ++i) {
                    Node n = p.kids.get(i);
                    if (!n.name.equals(this.snap.name)) continue;
                    p.kids.remove((Object)n);
                    BNavFileEditor.this.model.updateTreeTable(true);
                    BNavFileEditor.this.setModified();
                    return;
                }
            }

            public void redo() throws Exception {
                Node p = BNavFileEditor.this.findNode(this.parent);
                p.kids.add(new Node(p, this.snap.name, this.snap.ord, this.snap.icon));
                p.setExpanded(true);
                BNavFileEditor.this.model.updateTreeTable(true);
                BNavFileEditor.this.setModified();
            }
        }
    }

    class ShowFilesCommand
    extends ToggleCommand {
        public ShowFilesCommand(BWidget owner) {
            super(owner, module, "navFileEditor.showFiles");
        }

        public CommandArtifact doInvoke() {
            BNavFileEditor.this.computeSourceVisible();
            BNavFileEditor.this.source.showFiles(this.isSelected());
            return null;
        }
    }

    class ShowComponentsCommand
    extends ToggleCommand {
        public ShowComponentsCommand(BWidget owner) {
            super(owner, module, "navFileEditor.showComponents");
        }

        public CommandArtifact doInvoke() {
            BNavFileEditor.this.computeSourceVisible();
            BNavFileEditor.this.source.showComponents(this.isSelected());
            return null;
        }
    }

    class OpenTextEditor
    extends Command {
        public OpenTextEditor(BWidget owner) {
            super(owner, lexOpenText);
        }

        public CommandArtifact doInvoke() {
            BOrd ord = BNavFileEditor.this.getWbShell().getActiveOrd();
            ord = BOrd.make((BOrd)ord, (String)"view:workbench:TextFileEditor");
            BNavFileEditor.this.getWbShell().hyperlink(ord);
            return null;
        }
    }

    class Controller
    extends TreeTableController {
        Controller() {
        }

        public void keyPressed(BKeyEvent event) {
            super.keyPressed(event);
            if (event.getKeyCode() == 10 && BNavFileEditor.this.editCommand.isEnabled()) {
                BNavFileEditor.this.editCommand.invoke();
            }
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            if (BNavFileEditor.this.editCommand.isEnabled()) {
                BNavFileEditor.this.editCommand.invoke();
            }
        }

        protected BMenu makePopup(TreeTableSubject subject) {
            BMenu menu = new BMenu();
            Node node = (Node)subject.getActiveNode();
            if (node == null) {
                menu.add(null, (Command)new NewCommand((BWidget)this.getTable(), BNavFileEditor.this.model.root));
                menu.add(null, BNavFileEditor.this.commands.paste);
            } else {
                menu.add(null, (Command)new NewCommand((BWidget)this.getTable(), node));
                menu.add(null, (Command)BNavFileEditor.this.editCommand);
                menu.add(null, (Command)BNavFileEditor.this.moveUpCommand);
                menu.add(null, (Command)BNavFileEditor.this.moveDownCommand);
                menu.add(null, (BValue)new BSeparator());
                menu.add(null, BNavFileEditor.this.commands.cut);
                menu.add(null, BNavFileEditor.this.commands.copy);
                menu.add(null, BNavFileEditor.this.commands.paste);
                menu.add(null, BNavFileEditor.this.commands.duplicate);
                menu.add(null, BNavFileEditor.this.commands.delete);
                menu.add(null, (BValue)new BSeparator());
                menu.add(null, (Command)new ExpandAllCommand((BWidget)this.getTable(), node));
                menu.add(null, (Command)new CollapseAllCommand((BWidget)this.getTable(), node));
            }
            return menu;
        }
    }

    class Selection
    extends TreeTableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            int[] rows = this.getRows();
            boolean a = rows.length > 0;
            boolean b = BNavFileEditor.this.sameParent(rows);
            BNavFileEditor.this.editCommand.setEnabled(a);
            BNavFileEditor.this.model.getTreeTable().setCutEnabled(b);
            BNavFileEditor.this.model.getTreeTable().setCopyEnabled(b);
            BNavFileEditor.this.model.getTreeTable().setDuplicateEnabled(b);
            BNavFileEditor.this.model.getTreeTable().setDeleteEnabled(b);
            BNavFileEditor.this.moveUpCommand.setEnabled(b);
            BNavFileEditor.this.moveDownCommand.setEnabled(b);
            BNavFileEditor.this.repaint();
        }
    }

    class Model
    extends TreeTableModel {
        Node root;

        Model() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            return col == 0 ? lexName : lexOrd;
        }

        public int getRootCount() {
            return this.root == null ? 0 : 1;
        }

        public TreeTableNode getRoot(int index) {
            return this.root;
        }
    }
}

