/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.rpc.BNavMonitorRpc;
import com.tridium.sys.Nre;
import java.security.AccessController;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavListener;
import javax.baja.space.BISpaceNode;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.NavTreeNode;

public final class NavMonitor
extends Thread {
    public static final long SCAN_RATE = AccessController.doPrivileged(() -> Long.getLong("niagara.nav.touch.scanRate", 20000L));
    static NavMonitor monitor;
    static BAbsTime lastScanStart;
    static long lastScanTicks;
    static long minScanTicks;
    static long maxScanTicks;
    static long sumScanTicks;
    static long numScans;
    static Logger log;
    private static final Object lock;

    public static NavMonitor get() {
        if (monitor == null) {
            log.info("*** NavMonitor lazy init ***");
            NavMonitor.init();
        }
        return monitor;
    }

    public static void init() {
        if (monitor == null) {
            monitor = new NavMonitor();
            monitor.start();
            if (log.isLoggable(Level.FINE)) {
                log.fine("NavMonitor thread started.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void touch() {
        NavMonitor monitor = NavMonitor.get();
        if (monitor != null) {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
        }
    }

    private NavMonitor() {
        super(Nre.mainThreadGroup, "Ui:NavMonitor");
        this.setDaemon(true);
        Spy.ROOT.add("navMonitor", (Spy)new MySpy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (SCAN_RATE <= 0L) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("NavMonitor disabled since SCAN_RATE = " + SCAN_RATE);
            }
            return;
        }
        long waitTime = SCAN_RATE - 500L;
        if (waitTime <= 0L) {
            waitTime = SCAN_RATE;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("NavMonitor enabled with SCAN_RATE = " + SCAN_RATE);
        }
        while (true) {
            try {
                while (true) {
                    Object object = lock;
                    synchronized (object) {
                        lock.wait(waitTime);
                    }
                    Thread.sleep(500L);
                    lastScanStart = BAbsTime.now();
                    long scanStartTicks = Clock.ticks();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Performing full TOUCH Scan");
                    }
                    this.scan();
                    Object object2 = lock;
                    synchronized (object2) {
                        lastScanTicks = Clock.ticks() - scanStartTicks;
                        minScanTicks = Math.min(lastScanTicks, minScanTicks);
                        maxScanTicks = Math.max(lastScanTicks, maxScanTicks);
                        sumScanTicks += lastScanTicks;
                        ++numScans;
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Completed full TOUCH Scan in " + lastScanTicks + " ticks");
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Exception in NavMonitor", e);
                continue;
            }
            break;
        }
    }

    void scan() {
        NavListener[] listeners = BNavRoot.INSTANCE.getNavListeners();
        if (listeners == null) {
            return;
        }
        Stream<Object> nodes = Stream.empty();
        for (NavListener listener : listeners) {
            if (listener instanceof BNavTree) {
                nodes = Stream.concat(nodes, NavMonitor.visibleSpaceNodes((BNavTree)listener));
                continue;
            }
            if (!(listener instanceof TableModel)) continue;
            nodes = Stream.concat(nodes, NavMonitor.tableModelSpaceNodes((TableModel)listener));
        }
        BNavMonitorRpc.touchNodes(nodes, null);
    }

    private static Stream<BISpaceNode> visibleSpaceNodes(BNavTree tree) {
        TreeNode[] visibleNodes = tree.getVisibleNodes();
        if (visibleNodes == null) {
            return Stream.empty();
        }
        return Arrays.stream(visibleNodes).map(n -> ((NavTreeNode)((Object)n)).getNavNode()).filter(n -> n instanceof BISpaceNode).map(n -> (BISpaceNode)n);
    }

    private static Stream<BISpaceNode> tableModelSpaceNodes(TableModel model) {
        int rowCount = model.getRowCount();
        return IntStream.range(0, rowCount).boxed().map(arg_0 -> ((TableModel)model).getSubject(arg_0)).filter(o -> o instanceof BINavNode && o instanceof BISpaceNode).map(n -> (BISpaceNode)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) {
        out.startProps();
        out.trTitle((Object)"NavMonitor", 2);
        if (SCAN_RATE <= 0L) {
            out.prop((Object)"SCAN_RATE", (Object)(SCAN_RATE + " (disabled)"));
        } else {
            out.prop((Object)"SCAN_RATE", (Object)(SCAN_RATE + " (" + BRelTime.make((long)SCAN_RATE) + ")"));
        }
        out.prop((Object)"lastScanStart", (Object)lastScanStart);
        Object object = lock;
        synchronized (object) {
            out.prop((Object)"numScans", (Object)("" + numScans));
            out.prop((Object)"lastScanTicks", (Object)(lastScanTicks + " (" + BRelTime.make((long)lastScanTicks) + ")"));
            out.prop((Object)"minScanTicks", (Object)(minScanTicks + " (" + BRelTime.make((long)minScanTicks) + ")"));
            out.prop((Object)"maxScanTicks", (Object)(maxScanTicks + " (" + BRelTime.make((long)maxScanTicks) + ")"));
            if (numScans > 0L) {
                double avgScan = (double)sumScanTicks / (double)numScans;
                out.prop((Object)"avgScanTicks", (Object)(avgScan + " (" + BRelTime.make((long)((long)avgScan)) + ")"));
            }
        }
        out.endProps();
    }

    static {
        lastScanStart = BAbsTime.NULL;
        lastScanTicks = 0L;
        minScanTicks = Long.MAX_VALUE;
        maxScanTicks = Long.MIN_VALUE;
        sumScanTicks = 0L;
        numScans = 0L;
        log = Logger.getLogger("NavMonitor");
        lock = new Object();
    }

    class MySpy
    extends Spy {
        MySpy() {
        }

        public void write(SpyWriter out) {
            NavMonitor.this.spy(out);
        }
    }
}

