/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.file;

import com.tridium.nre.util.InputStreamInfo;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.gx.BInsets;
import javax.baja.gx.RectGeom;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"baja:IDataFile"}, requiredPermissions="r")})
@NiagaraProperty(name="wordWrap", type="boolean", defaultValue="false")
public class BTextFileViewer
extends BWbView {
    @Generated
    public static final Property wordWrap = BTextFileViewer.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTextFileViewer.class);
    static final Log log = Log.getLog((String)"textEditor");
    static final Lexicon lex = Lexicon.make((String)"workbench");
    private static HashMap<BOrd, FileState> fileStates = new HashMap();
    public BTextEditorPane pane = new BTextEditorPane("", 80, 40, true);
    public BTextEditor text = this.pane.getEditor();
    public FileState state;
    public BTextField encodingStatus = new BTextField("", 0, false);
    public ToggleCommand wordWrapCommand;
    BGridPane status = new BGridPane(4);
    BIFile file;
    File localFile;
    boolean zipped;
    String encoding;

    @Generated
    public boolean getWordWrap() {
        return this.getBoolean(wordWrap);
    }

    @Generated
    public void setWordWrap(boolean v) {
        this.setBoolean(wordWrap, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTextFileViewer() {
        this.setContent((BWidget)this.pane);
        this.status.add("encoding", (BValue)this.encodingStatus);
        this.wordWrapCommand = new WordWrapCommand(this);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        String wordWrapStr;
        OrdTarget target;
        ViewQuery viewQuery;
        if (this.getWbShell() != null && (viewQuery = (target = this.getWbShell().getActiveOrdTarget()).getViewQuery()) != null && (wordWrapStr = viewQuery.getParameter("wordWrap", "false")).equals("true")) {
            this.setWordWrap(true);
        }
        this.file = (BIFile)value;
        this.localFile = null;
        if (this.file.getStore() instanceof BLocalFileStore) {
            this.localFile = ((BLocalFileStore)this.file.getStore()).getLocalFile();
        }
        this.pane.setHpolicy(BScrollBarPolicy.asNeeded);
        this.text.setParser((TextParser)new WordWrapTextParser());
        this.text.setModel((TextModel)new WordWrapTextModel());
        this.text.setEditable(false);
        this.text.updateEnableStates();
        this.setTransferWidget((BTransferWidget)this.text);
        this.setCommandEnabled(6, true);
        this.setCommandEnabled(7, true);
        this.setCommandEnabled(8, true);
        this.setCommandEnabled(10, true);
        try (Reader in = this.toReader(this.file.getInputStream());){
            this.text.getModel().read(in);
        }
        if (this.getWbShell() != null) {
            BOrd ord = this.getWbShell().getActiveOrd();
            this.state = fileStates.get(ord);
            if (this.state == null) {
                this.state = new FileState(ord);
                fileStates.put(ord, this.state);
            }
        }
        this.wordWrapCommand.setSelected(this.getWordWrap());
    }

    private Reader toReader(InputStream in) throws Exception {
        InputStreamInfo inputStreamInfo = new InputStreamInfo(in);
        if (inputStreamInfo.isZipped()) {
            this.zipped = true;
        }
        String s = this.encoding = inputStreamInfo.getEncodingTag();
        if (this.zipped) {
            s = "Zip/" + s;
        }
        this.encodingStatus.setText(s);
        this.encodingStatus.setVisibleColumns(s.length());
        return inputStreamInfo.toReader();
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return value;
    }

    public String getDefaultOptionsId() {
        return "textEditor";
    }

    public BToolBar getViewToolBar() {
        BToolBar bar = new BToolBar();
        BNiagaraWbShell shell = (BNiagaraWbShell)this.getWbShell();
        bar.add("find", shell.commands.find);
        bar.add("sep0", (BValue)new BSeparator());
        bar.add("wordWrap", (Command)this.wordWrapCommand);
        return bar;
    }

    @Override
    public BWidget getViewStatusBarSupplement() {
        return this.status;
    }

    @Override
    public CommandArtifact invokeCommand(int id) throws Exception {
        switch (id) {
            case 6: {
                return this.text.doFind();
            }
            case 8: {
                return this.text.doFindNext();
            }
            case 7: {
                return this.text.doFindPrev();
            }
            case 10: {
                return this.text.doGoto();
            }
        }
        return super.invokeCommand(id);
    }

    public String getSelectedText() {
        return this.text.getModel().getSelectedText();
    }

    public void highlight(int line1, int col1, int line2, int col2) {
        Position end = this.text.getModel().getEndPosition();
        Position p1 = new Position(line1 - 1, col1 - 1);
        Position p2 = new Position(line2 - 1, col2 - 1);
        if (p1.compareTo(end) > 0) {
            p1 = end;
        }
        if (p2.compareTo(end) > 0) {
            p2 = end;
        }
        this.state.viewport = null;
        this.text.getSelection().select(p1, p2);
        this.text.moveCaretPosition(p2);
        this.text.requestFocus();
    }

    public void caretMoved(Position pos) {
        this.state.lastPosition = pos;
    }

    @Override
    public void doLayout(BWidget[] kids) {
        super.doLayout(kids);
        this.layoutText();
    }

    @Override
    public void deactivated() {
        super.deactivated();
        if (this.state != null) {
            this.state.viewport = this.pane.getViewport();
        }
    }

    void layoutText() {
        if (this.text.getModel() instanceof WordWrapTextModel) {
            ((WordWrapTextModel)this.text.getModel()).update(this.text.getParser().parse(this.text.getText().toCharArray()));
            this.text.getSelection().deselect();
            this.repaint();
        }
    }

    public class WordWrapTextModel
    extends TextModel {
        double prefWidth;

        protected void update(Line[] lines) {
            super.update(lines);
            BTextEditor editor = this.getEditor();
            boolean singleLine = editor.isSingleLine();
            double pw = this.prefWidth;
            if (!singleLine) {
                this.walkLines();
            }
            if (pw != this.prefWidth && !singleLine) {
                editor.relayout();
            } else {
                editor.repaint();
            }
        }

        private void walkLines() {
            TextRenderer renderer = this.getRenderer();
            double maxw = 10.0;
            for (int ixLines = 0; ixLines < this.getLineCount(); ++ixLines) {
                if (BTextFileViewer.this.getWordWrap()) {
                    Segment[] segments = this.getLine((int)ixLines).segments;
                    for (int ixSegs = 0; ixSegs < segments.length; ++ixSegs) {
                        maxw = Math.max(maxw, renderer.getLineWidth(this.getLine(ixLines), segments[ixSegs].offset, segments[ixSegs].length));
                    }
                    continue;
                }
                maxw = Math.max(maxw, renderer.getLineWidth(this.getLine(ixLines)));
            }
            this.prefWidth = maxw;
        }

        public double getPreferredWidth() {
            return this.prefWidth;
        }

        public double getPreferredHeight() {
            return super.getPreferredHeight() + 5.0;
        }
    }

    class WordWrapTextParser
    extends TextParser {
        WordWrapTextParser() {
        }

        public synchronized Line[] parse(char[] buffer) {
            this.buffer = buffer;
            this.length = buffer.length;
            this.pos = 0;
            this.last = -1;
            this.current = this.length > 0 ? buffer[0] : -1;
            this.next = this.length > 1 ? buffer[1] : -1;
            this.segmentStart = 0;
            this.lineStart = 0;
            double viewWidth = 0.0;
            if (BTextFileViewer.this.getWordWrap() && BTextFileViewer.this.pane != null) {
                viewWidth = BTextFileViewer.this.getWidth();
                boolean vsbShow = false;
                switch (BTextFileViewer.this.pane.getVpolicy().getOrdinal()) {
                    case 0: {
                        vsbShow = true;
                        break;
                    }
                    case 1: {
                        vsbShow = true;
                        break;
                    }
                    case 2: {
                        vsbShow = false;
                    }
                }
                if (vsbShow) {
                    double editorInsets = 20.0;
                    BInsets scrollInsets = Theme.scrollPane().getInsets();
                    double totalInsets = editorInsets + scrollInsets.right() + scrollInsets.left();
                    viewWidth = viewWidth - Theme.scrollBar().getFixedWidth() - totalInsets;
                }
            }
            ArrayList<Line> lines = new ArrayList<Line>();
            ArrayList<Segment> segments = new ArrayList<Segment>();
            while (this.pos < this.length) {
                Segment seg = this.nextSegment();
                segments.add(seg);
                if (seg.type == 3) {
                    int len = this.pos - this.lineStart;
                    if (seg.modifiers == 4) {
                        --len;
                    }
                    lines.add(new Line(buffer, this.lineStart, len, segments));
                    segments.clear();
                    this.lineStart = this.pos;
                } else if (BTextFileViewer.this.getWordWrap()) {
                    int len = this.pos - this.lineStart;
                    Line line = new Line(buffer, this.lineStart, len, segments);
                    if (viewWidth > 0.0 && !seg.isWhitespace() && this.getRenderer().getLineWidth(line) > viewWidth) {
                        segments.remove(seg);
                        this.pos -= seg.length;
                        len = this.pos - this.lineStart;
                        lines.add(new Line(buffer, this.lineStart, len, segments));
                        segments.clear();
                        Segment newSeg = new Segment(seg.type, seg.modifiers, 0, seg.length);
                        segments.add(newSeg);
                        this.lineStart = this.pos;
                        this.pos += newSeg.length;
                    }
                }
                this.segmentStart = this.pos;
            }
            if (segments.size() > 0) {
                lines.add(new Line(buffer, this.lineStart, buffer.length - this.lineStart, segments));
            }
            if (lines.size() == 0) {
                lines.add(new Line(new char[0], new Segment[0]));
            }
            return lines.toArray(new Line[0]);
        }
    }

    public static class FileState {
        public BOrd ord;
        public Position lastPosition = new Position(0, 0);
        public RectGeom viewport;

        public FileState(BOrd ord) {
            this.ord = ord;
        }

        public String toString() {
            return this.ord.toString() + " " + this.lastPosition;
        }
    }

    class WordWrapCommand
    extends ToggleCommand {
        public WordWrapCommand(BWidget owner) {
            super(owner, lex, "TextFileViewer.wordWrap");
        }

        public CommandArtifact doInvoke() throws Exception {
            BTextFileViewer.this.setWordWrap(this.isSelected());
            BTextFileViewer.this.layoutText();
            return null;
        }
    }
}

