/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.file;

import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.list.BList;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="editable", type="boolean", defaultValue="true"), @NiagaraProperty(name="baseDirectoryOrd", type="BOrd", defaultValue="BOrd.DEFAULT")})
public class BSubdirectoryDropDown
extends BTextDropDown {
    @Generated
    public static final Property editable = BSubdirectoryDropDown.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property baseDirectoryOrd = BSubdirectoryDropDown.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSubdirectoryDropDown.class);

    @Generated
    public boolean getEditable() {
        return this.getBoolean(editable);
    }

    @Generated
    public void setEditable(boolean v) {
        this.setBoolean(editable, v, null);
    }

    @Generated
    public BOrd getBaseDirectoryOrd() {
        return (BOrd)this.get(baseDirectoryOrd);
    }

    @Generated
    public void setBaseDirectoryOrd(BOrd v) {
        this.set(baseDirectoryOrd, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSubdirectoryDropDown() {
        this(BOrd.DEFAULT, "");
    }

    public BSubdirectoryDropDown(BOrd baseDirectory) {
        this(baseDirectory, "");
    }

    public BSubdirectoryDropDown(BOrd baseDirectory, String subdirectory) {
        this.setBaseDirectoryOrd(baseDirectory);
        this.getEditor().setText(subdirectory);
        this.loadSubdirectories();
    }

    public BSubdirectoryDropDown(BOrd baseDirectory, String subdirectory, int visibleColumns, boolean editable) {
        this(baseDirectory, subdirectory);
        this.getEditor().setVisibleColumns(visibleColumns);
        this.getEditor().setEditable(editable);
        this.setDropDownEnabled(editable);
        this.setEditable(editable);
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (prop == baseDirectoryOrd) {
            this.loadSubdirectories();
        } else if (prop == editable) {
            this.getEditor().setEditable(this.getEditable());
            this.setDropDownEnabled(this.getEditable());
        }
    }

    private void loadSubdirectories() {
        BObject baseDirectoryObject;
        BList subdirectoryList = this.getList();
        subdirectoryList.removeAllItems();
        try {
            baseDirectoryObject = this.getBaseDirectoryOrd().resolve().get();
        }
        catch (Exception ignore) {
            baseDirectoryObject = null;
        }
        if (baseDirectoryObject instanceof BDirectory) {
            BDirectory baseDirectory = (BDirectory)baseDirectoryObject;
            this.addSubdirectoriesToList(subdirectoryList, baseDirectory, "");
        }
    }

    private void addSubdirectoriesToList(BList subdirectoryList, BDirectory directory, String directoryPrefix) {
        for (BIFile file : directory.listFiles()) {
            if (!file.isDirectory()) continue;
            String subdirectoryName = directoryPrefix + file.getFileName();
            subdirectoryList.addItem((Object)subdirectoryName);
            this.addSubdirectoriesToList(subdirectoryList, (BDirectory)file, subdirectoryName + '/');
        }
    }
}

