/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.event.sources;

import javax.baja.data.BIDataValue;
import javax.baja.event.BEvent;
import javax.baja.event.BEventSource;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeSubscriber;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="typeSpec", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", flags=8, facets={@Facet(value="BFacets.make(BFacets.TARGET_TYPE, BString.make(\"baja:Component\"))")}), @NiagaraProperty(name="events", type="BComponentEventMask", defaultValue="BComponentEventMask.EMPTY")})
public class BComponentTypeEventSource
extends BEventSource {
    @Generated
    public static final Property typeSpec = BComponentTypeEventSource.newProperty((int)8, (BValue)BTypeSpec.DEFAULT, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:Component")));
    @Generated
    public static final Property events = BComponentTypeEventSource.newProperty((int)0, (BValue)BComponentEventMask.EMPTY, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BComponentTypeEventSource.class);
    private EventTypeSubscriber subscriber;

    @Generated
    public BTypeSpec getTypeSpec() {
        return (BTypeSpec)this.get(typeSpec);
    }

    @Generated
    public void setTypeSpec(BTypeSpec v) {
        this.set(typeSpec, (BValue)v, null);
    }

    @Generated
    public BComponentEventMask getEvents() {
        return (BComponentEventMask)this.get(events);
    }

    @Generated
    public void setEvents(BComponentEventMask v) {
        this.set(events, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.subscriber = new EventTypeSubscriber(this.getComponentSpace());
        if (!this.getTypeSpec().isNull()) {
            this.subscriber.subscribe(this.getTypeSpec().getResolvedType(), null);
        }
    }

    public void stopped() {
        this.subscriber.unsubscribeAll();
    }

    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property.equals(typeSpec)) {
                this.subscriber.unsubscribeAll();
                if (!this.getTypeSpec().isNull()) {
                    this.subscriber.subscribe(this.getTypeSpec().getResolvedType(), null);
                }
            }
            if (property.equals(events)) {
                this.subscriber.setMask(this.getEvents());
            }
        }
        super.changed(property, context);
    }

    private class EventTypeSubscriber
    extends TypeSubscriber {
        public EventTypeSubscriber(BComponentSpace space) {
            super(space);
            this.setMask(BComponentTypeEventSource.this.getEvents());
        }

        public void event(BComponentEvent componentEvent) {
            if (BComponentTypeEventSource.this.getEvents().includes(componentEvent.getId())) {
                BEvent event = new BEvent();
                event.setValue((BValue)((BComponentEvent)componentEvent.clone()));
                BOrd sourceNavOrd = componentEvent.getSourceComponent().getNavOrd();
                if (sourceNavOrd != null) {
                    event.setSource(BOrdList.make((BOrd)sourceNavOrd));
                }
                BComponentTypeEventSource.this.process(event);
            }
        }
    }
}

