/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.iotdep.internal;

import com.tridium.cloud.client.iotdep.internal.IAmqpSessionHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.reactor.FlowController;

public abstract class AmqpSenderLinkHandler
extends BaseHandler {
    protected String id;
    protected Sender sender;
    protected String linkAddress;
    private long nextTag;
    protected Map<Symbol, Object> amqpProperties;
    protected IAmqpSessionHandler parentSessionHandler;
    private final byte[] tmpBuffer = new byte[262144];
    protected final Map<Long, CompletableFuture<Delivery>> inFlight;
    private static final Logger log = Logger.getLogger("cloud.iotmsg.amqp");

    protected AmqpSenderLinkHandler(Sender sender, String linkId, IAmqpSessionHandler parent) {
        this.amqpProperties = new HashMap<Symbol, Object>();
        this.amqpProperties.put(Symbol.getSymbol("com.microsoft:api-version"), "2020-05-31-preview");
        this.id = linkId;
        this.sender = sender;
        this.parentSessionHandler = parent;
        this.inFlight = new HashMap<Long, CompletableFuture<Delivery>>();
        BaseHandler.setHandler(sender, (Handler)this);
        this.add(new FlowController());
    }

    void close() {
        if (this.sender.getLocalState() != EndpointState.CLOSED) {
            this.sender.close();
        }
        IOException ex = new IOException("Connection closed");
        for (CompletableFuture<Delivery> future : this.inFlight.values()) {
            future.completeExceptionally(ex);
        }
    }

    @Override
    public void onLinkInit(Event event) {
        log.finest(event.toString());
        Link link = event.getLink();
        Target target = new Target();
        target.setAddress(this.linkAddress);
        link.setTarget(target);
        link.setSenderSettleMode(SenderSettleMode.UNSETTLED);
        link.setProperties(this.amqpProperties);
        link.open();
    }

    @Override
    public void onLinkRemoteOpen(Event event) {
        log.finest(event.toString());
        this.parentSessionHandler.linkOpened(this);
    }

    @Override
    public void onDelivery(Event event) {
        log.finest(event.toString());
        Delivery delivery = event.getDelivery();
        long deliveryTag = Long.parseLong(new String(event.getDelivery().getTag()));
        CompletableFuture<Delivery> future = this.inFlight.remove(deliveryTag);
        if (future == null) {
            log.info("Received acknowledgement for a message that this sender did not send " + deliveryTag);
        } else {
            future.complete(delivery);
        }
        delivery.free();
    }

    @Override
    public void onLinkRemoteClose(Event event) {
        log.finest(event.toString());
        Link link = event.getLink();
        if (link.getLocalState() == EndpointState.ACTIVE) {
            log.config("unexpected remote close of link with id " + this.id);
            this.parentSessionHandler.linkLost(link.getRemoteCondition(), this);
            link.close();
        } else {
            this.parentSessionHandler.close();
        }
    }

    @Override
    public void onLinkLocalClose(Event event) {
        log.finest(event.toString());
        Link link = event.getLink();
        if (link.getRemoteState() == EndpointState.CLOSED) {
            this.parentSessionHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CompletableFuture<Delivery> sendMessage(Message message) {
        if (++this.nextTag == Long.MAX_VALUE) {
            this.nextTag = 0L;
        }
        byte[] deliveryTag = String.valueOf(this.nextTag).getBytes();
        CompletableFuture<Delivery> future = new CompletableFuture<Delivery>();
        Delivery delivery = null;
        try {
            byte[] byArray = this.tmpBuffer;
            synchronized (this.tmpBuffer) {
                int length = message.encode(this.tmpBuffer, 0, this.tmpBuffer.length);
                delivery = this.sender.delivery(deliveryTag);
                int sent = this.sender.send(this.tmpBuffer, 0, length);
                // ** MonitorExit[var7_5] (shouldn't be in output)
                log.finer(() -> "sent " + sent + " bytes to transport");
                this.inFlight.put(this.nextTag, future);
                if (this.sender.advance() && sent == length) return future;
                future.completeExceptionally(new IOException("unable to send message " + message.getMessageId()));
                return future;
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Error sending AMQP message " + message.getMessageId(), ex);
            future.completeExceptionally(ex);
            this.sender.advance();
            if (delivery == null) return future;
            delivery.free();
        }
        return future;
    }
}

