/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.iotdep.internal;

import com.tridium.cloud.client.NiagaraMessageType;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.message.Message;

public class AmqpMessage {
    private NiagaraMessageType niagaraMessageType;
    private CompletableFuture<String> future;
    private final Message message;
    private Delivery delivery;
    public static final byte[] EMPTY_BYTES = new byte[0];

    public AmqpMessage(Message message, Delivery delivery) {
        this.message = message;
        this.delivery = delivery;
    }

    public AmqpMessage(byte[] payload, Map<String, Object> metadata) {
        this.message = Proton.message();
        Binary binary = new Binary(payload);
        Data section = new Data(binary);
        this.message.setBody(section);
        this.message.setApplicationProperties(new ApplicationProperties(metadata));
    }

    public AmqpMessage(byte[] payload) {
        this.message = Proton.message();
        Binary binary = new Binary(payload);
        Data section = new Data(binary);
        this.message.setBody(section);
    }

    public int getLength() {
        Section body = this.message.getBody();
        if (body instanceof Data) {
            Binary payload = ((Data)body).getValue();
            return payload.getLength();
        }
        return 0;
    }

    public byte[] getPayload() {
        Section body = this.message.getBody();
        if (body instanceof Data) {
            Binary payload = ((Data)body).getValue();
            if (payload.getArrayOffset() == 0) {
                return payload.getArray();
            }
            return Arrays.copyOfRange(payload.getArray(), payload.getArrayOffset(), payload.getLength());
        }
        return EMPTY_BYTES;
    }

    public String getMessageId() {
        return String.valueOf(this.getMessage().getMessageId());
    }

    public void setMessageId(String messageId) {
        this.getMessage().setMessageId(messageId);
    }

    public String getCorrelationId() {
        return String.valueOf(this.getMessage().getCorrelationId());
    }

    public void setCorrelationId(String correlationId) {
        this.getMessage().setCorrelationId(correlationId);
    }

    public Map<String, Object> getMetadata() {
        return this.message.getApplicationProperties().getValue();
    }

    public Properties getAmqpProperties() {
        return this.message.getProperties();
    }

    public Delivery getDelivery() {
        return this.delivery;
    }

    public Message getMessage() {
        return this.message;
    }

    public NiagaraMessageType getNiagaraMessageType() {
        return this.niagaraMessageType;
    }

    public void setNiagaraMessageType(NiagaraMessageType niagaraMessageType) {
        this.niagaraMessageType = niagaraMessageType;
    }

    public CompletableFuture<String> getFuture() {
        return this.future;
    }

    public void setFuture(CompletableFuture<String> future) {
        this.future = future;
    }
}

