/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.iotdep.internal;

import com.tridium.cloud.client.iotdep.internal.AmqpClient;
import com.tridium.cloud.client.iotdep.internal.AmqpMessage;
import com.tridium.cloud.client.iotdep.internal.AmqpTelemetryReceiverLinkHandler;
import com.tridium.cloud.client.iotdep.internal.AmqpTelemetrySenderLinkHandler;
import com.tridium.cloud.client.iotdep.internal.IAmqpSessionHandler;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;

public class AmqpDeviceSessionHandler
extends BaseHandler
implements IAmqpSessionHandler {
    private final AmqpClient client;
    private final Session session;
    private AmqpTelemetrySenderLinkHandler senderHandler;
    private AmqpTelemetryReceiverLinkHandler receiverHandler;
    private boolean senderOpen;
    private boolean receiverOpen;
    private static final Logger log = Logger.getLogger("cloud.iotmsg.amqp");

    AmqpDeviceSessionHandler(Session session, AmqpClient client) {
        this.client = client;
        this.session = session;
        BaseHandler.setHandler(session, (Handler)this);
        session.open();
    }

    public CompletableFuture<Delivery> send(AmqpMessage message) {
        return this.senderHandler.sendMessage(message.getMessage());
    }

    @Override
    public void onSessionLocalClose(Event event) {
        log.finest(event.toString());
        log.fine("Amqp device session closed locally");
        this.closeLinks();
    }

    @Override
    public void onSessionRemoteClose(Event event) {
        log.finest(event.toString());
        Session sess = event.getSession();
        if (sess.getLocalState() == EndpointState.ACTIVE) {
            log.config("Amqp device session closed remotely unexpectedly");
            this.client.getCallbackHandler().onConnectionLost(this.client, new IOException(sess.getRemoteCondition().toString()));
            this.session.close();
        }
    }

    public boolean isConnected() {
        return this.session != null && this.session.getLocalState() == EndpointState.ACTIVE && this.session.getRemoteState() == EndpointState.ACTIVE;
    }

    @Override
    public void linkOpened(BaseHandler linkHandler) {
        if (linkHandler == this.senderHandler) {
            this.senderOpen = true;
        } else if (linkHandler == this.receiverHandler) {
            this.receiverOpen = true;
        }
        if (this.senderOpen && this.receiverOpen) {
            this.client.connected();
        }
    }

    @Override
    public void linkLost(ErrorCondition condition, BaseHandler linkHandler) {
        this.close();
        this.client.getCallbackHandler().onConnectionLost(this.client, new IOException(condition.getDescription()));
    }

    @Override
    public void close() {
        this.closeLinks();
        this.session.close();
    }

    @Override
    public AmqpClient getClient() {
        return this.client;
    }

    void openLinks() {
        String linkId = UUID.randomUUID().toString();
        Sender sender = this.session.sender(AmqpTelemetrySenderLinkHandler.getTag(this.client.getConnectionInfo().get("id"), linkId));
        this.senderHandler = new AmqpTelemetrySenderLinkHandler(sender, linkId, this);
        Receiver receiver = this.session.receiver(AmqpTelemetryReceiverLinkHandler.getTag(this.client.getConnectionInfo().get("id"), linkId));
        this.receiverHandler = new AmqpTelemetryReceiverLinkHandler(receiver, linkId, this);
    }

    void closeLinks() {
        if (this.senderHandler != null) {
            this.senderHandler.close();
        }
        if (this.receiverHandler != null) {
            this.receiverHandler.close();
        }
    }
}

