/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.iotdep;

import com.tridium.cloud.client.MessageCallback;
import com.tridium.cloud.client.NiagaraMessageType;
import com.tridium.cloud.client.iotdep.BCompressionMode;
import com.tridium.cloud.client.iotdep.BIotHubTransport;
import com.tridium.cloud.client.iotdep.BMessageQueue;
import com.tridium.cloud.client.iotdep.BTlsVersion;
import com.tridium.cloud.client.iotdep.internal.AmqpClient;
import com.tridium.cloud.client.iotdep.internal.AmqpMessage;
import com.tridium.cloud.client.iotdep.internal.IAmqpCallbacks;
import com.tridium.cloud.client.iothub.BAbstractIotHubConnectorImpl;
import com.tridium.cloud.client.iothub.BMessageClient;
import com.tridium.cloud.client.iothub.MessageClientConnectionState;
import com.tridium.cloud.util.IResettableOutputMemoryStream;
import com.tridium.cloud.util.ResettableDeflaterOutputMemoryStream;
import com.tridium.cloud.util.ResettableGZIPOutputMemoryStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="transport", type="BIotHubTransport", defaultValue="BIotHubTransport.amqps_ws"), @NiagaraProperty(name="messageTimeout", type="BRelTime", defaultValue="BRelTime.make(300000)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(15000)")}), @NiagaraProperty(name="compression", type="BCompressionMode", defaultValue="BCompressionMode.GZip"), @NiagaraProperty(name="highPriorityQueue", type="BMessageQueue", defaultValue="new BMessageQueue()"), @NiagaraProperty(name="lowPriorityQueue", type="BMessageQueue", defaultValue="new BMessageQueue()"), @NiagaraProperty(name="pendingMessageLimit", type="int", defaultValue="50", flags=4, facets={@Facet(name="BFacets.MIN", value="1")}), @NiagaraProperty(name="sentienceMessageRateLimit", type="int", defaultValue="5", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="sslProtocol", type="BTlsVersion", defaultValue="BTlsVersion.TLSv1_2", flags=5), @NiagaraProperty(name="trustAnchors", type="BVector", defaultValue="new BVector()", flags=7)})
@NiagaraAction(name="resetMetrics", flags=128)
public class BIotHubMessageClient
extends BMessageClient
implements IAmqpCallbacks {
    public static final Property transport = BIotHubMessageClient.newProperty((int)0, (BValue)BIotHubTransport.amqps_ws, null);
    public static final Property messageTimeout = BIotHubMessageClient.newProperty((int)0, (BValue)BRelTime.make((long)300000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)15000L)));
    public static final Property compression = BIotHubMessageClient.newProperty((int)0, (BValue)BCompressionMode.GZip, null);
    public static final Property highPriorityQueue = BIotHubMessageClient.newProperty((int)0, (BValue)new BMessageQueue(), null);
    public static final Property lowPriorityQueue = BIotHubMessageClient.newProperty((int)0, (BValue)new BMessageQueue(), null);
    public static final Property pendingMessageLimit = BIotHubMessageClient.newProperty((int)4, (int)50, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Property sentienceMessageRateLimit = BIotHubMessageClient.newProperty((int)0, (int)5, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    public static final Property sslProtocol = BIotHubMessageClient.newProperty((int)5, (BValue)BTlsVersion.TLSv1_2, null);
    public static final Property trustAnchors = BIotHubMessageClient.newProperty((int)7, (BValue)new BVector(), null);
    public static final Action resetMetrics = BIotHubMessageClient.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType(BIotHubMessageClient.class);
    private AmqpClient client;
    private long messagesSentOkTotalCount;
    private long messagesSentOkConnectionCount;
    private long lastMessageSentOkTime;
    private long alarmMessagesSentOkTotalCount;
    private long alarmMessagesSentOkConnectionCount;
    private long historyMessagesSentOkTotalCount;
    private long historyMessagesSentOkConnectionCount;
    private long pointMessagesSentOkTotalCount;
    private long pointMessagesSentOkConnectionCount;
    private long commandMessagesSentOkTotalCount;
    private long commandMessagesSentOkConnectionCount;
    private long otherMessagesSentOkTotalCount;
    private long otherMessagesSentOkConnectionCount;
    private long messagesSendFailureTotalCount;
    private long messagesSendFailureConnectionCount;
    private long lastMessageSendFailureTime;
    private long alarmMessagesSentFailureTotalCount;
    private long alarmMessagesSentFailureConnectionCount;
    private long historyMessagesSentFailureTotalCount;
    private long historyMessagesSentFailureConnectionCount;
    private long pointMessagesSentFailureTotalCount;
    private long pointMessagesSentFailureConnectionCount;
    private long commandMessagesSentFailureTotalCount;
    private long commandMessagesSentFailureConnectionCount;
    private long otherMessagesSentFailureTotalCount;
    private long otherMessagesSentFailureConnectionCount;
    private long messagesReceivedTotalCount;
    private long messagesReceivedConnectionCount;
    private long lastMessageReceivedTime;
    private long messageCompressionFailureCount;
    private long lastMessageCompressionFailureTime;
    private long clientCreationCount;
    private long connectionSuccessCount;
    private long lastConnectionTime;
    private long connectionDropCount;
    private long messageWindowFullConnectionCount;
    private long messageWindowFullTotalCount;
    private long messageWindowFullTime;
    private long bytesSentTotalCount;
    private long bytesSentConnectionCount;
    private long alarmBytesSentTotalCount;
    private long alarmBytesSentConnectionCount;
    private long historyBytesSentTotalCount;
    private long historyBytesSentConnectionCount;
    private long pointBytesSentTotalCount;
    private long pointBytesSentConnectionCount;
    private long commandBytesSentTotalCount;
    private long commandBytesSentConnectionCount;
    private long otherBytesSentTotalCount;
    private long otherBytesSentConnectionCount;
    private long bytesReceivedTotalCount;
    private long bytesReceivedConnectionCount;
    private long lastResetTime;
    private int errorCount;
    private long sasTokenExpiryTime;
    private IResettableOutputMemoryStream compressor;
    private String contentType;
    public static final String MESSAGE_CONTENT_TYPE = "MessageContentType";
    private AtomicInteger pendingMessages = new AtomicInteger(0);
    private int messageWindowCount;
    private long messageCount;
    private long messageWindowEnd;
    private boolean activeMessages;
    private boolean activeManager = false;
    private ExecutorService manager;
    private static final ReentrantLock messageControlLock = new ReentrantLock();
    private static final int compressionCutoff = 150;
    public static final String APPLICATION_JSON = "application/json";
    public static final String COMPRESSION_GZIP = "+gzip";
    public static final String COMPRESSION_DEFLATE = "+deflate";
    private String compressionType;
    private static final int ERROR_COUNT = 10;
    private static final Logger log = Logger.getLogger("cloud.iotmsg");
    private static final Lexicon lex = Lexicon.make(BIotHubMessageClient.class);
    public static final String AMQP_CONNECTION_INFO_NAME = "IoTHub2";
    private final Object metricLock = new Object();
    private static final int AMQP_CONNECTION_TIMEOUT_SEC = 30;

    public BIotHubTransport getTransport() {
        return (BIotHubTransport)this.get(transport);
    }

    public void setTransport(BIotHubTransport v) {
        this.set(transport, (BValue)v, null);
    }

    public BRelTime getMessageTimeout() {
        return (BRelTime)this.get(messageTimeout);
    }

    public void setMessageTimeout(BRelTime v) {
        this.set(messageTimeout, (BValue)v, null);
    }

    public BCompressionMode getCompression() {
        return (BCompressionMode)this.get(compression);
    }

    public void setCompression(BCompressionMode v) {
        this.set(compression, (BValue)v, null);
    }

    public BMessageQueue getHighPriorityQueue() {
        return (BMessageQueue)this.get(highPriorityQueue);
    }

    public void setHighPriorityQueue(BMessageQueue v) {
        this.set(highPriorityQueue, (BValue)v, null);
    }

    public BMessageQueue getLowPriorityQueue() {
        return (BMessageQueue)this.get(lowPriorityQueue);
    }

    public void setLowPriorityQueue(BMessageQueue v) {
        this.set(lowPriorityQueue, (BValue)v, null);
    }

    public int getPendingMessageLimit() {
        return this.getInt(pendingMessageLimit);
    }

    public void setPendingMessageLimit(int v) {
        this.setInt(pendingMessageLimit, v, null);
    }

    public int getSentienceMessageRateLimit() {
        return this.getInt(sentienceMessageRateLimit);
    }

    public void setSentienceMessageRateLimit(int v) {
        this.setInt(sentienceMessageRateLimit, v, null);
    }

    public BTlsVersion getSslProtocol() {
        return (BTlsVersion)this.get(sslProtocol);
    }

    public void setSslProtocol(BTlsVersion v) {
        this.set(sslProtocol, (BValue)v, null);
    }

    public BVector getTrustAnchors() {
        return (BVector)this.get(trustAnchors);
    }

    public void setTrustAnchors(BVector v) {
        this.set(trustAnchors, (BValue)v, null);
    }

    public void resetMetrics() {
        this.invoke(resetMetrics, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.sasTokenExpiryTime = Long.parseLong(System.getProperty("niagara.cloud.sasTokenExpiryTime", "3600"));
        this.setupCompression();
        this.manager = ExecutorUtil.newSingleThreadBackgroundExecutor((String)"iotdep.messageDeliveryManager", (long)1L, (TimeUnit)TimeUnit.MINUTES);
        this.resetTotalCounters();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.compressor != null) {
            this.compressor.close();
            this.compressor = null;
        }
        if (this.manager != null) {
            this.manager.shutdownNow();
            this.manager = null;
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(transport)) {
            this.getImpl().getCloudConnector().reconnectAsync("IotHubMessageClient.changed(transport)");
        }
        if (compression.equals(property)) {
            this.setupCompression();
        }
    }

    public BAbstractIotHubConnectorImpl getImpl() {
        return (BAbstractIotHubConnectorImpl)this.getParent();
    }

    private void clearAlarmsFromQueue() {
        this.getHighPriorityQueue().remove(NiagaraMessageType.alarm);
    }

    public void doResetMetrics() {
        this.resetConnectionCounters();
        this.resetTotalCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        out.startProps("Messaging");
        out.trTitle((Object)"General", 2);
        out.prop((Object)"client", (Object)this.client);
        Object object = this.metricLock;
        synchronized (object) {
            out.prop((Object)"Last Connection Time", (Object)BIotHubMessageClient.toDateTimeString(this.lastConnectionTime));
            out.prop((Object)"Client Creation Count", (double)this.clientCreationCount);
            out.prop((Object)"Connection Success Count", (double)this.connectionSuccessCount);
            out.prop((Object)"Connection Drop Count", (double)this.connectionDropCount);
            out.prop((Object)"Messages Compression Failure Count", (double)this.messageCompressionFailureCount);
            out.prop((Object)"Last Message Compression Failure Time", (Object)BIotHubMessageClient.toDateTimeString(this.lastMessageCompressionFailureTime));
            out.prop((Object)"Total Message Window Full Count", (double)this.messageWindowFullTotalCount);
            out.prop((Object)"Current Connection Message Window Full Count", (double)this.messageWindowFullConnectionCount);
            out.prop((Object)"Last Message Window Full Time", (Object)BIotHubMessageClient.toDateTimeString(this.messageWindowFullTime));
            out.prop((Object)"Metric Count Start Time", (Object)BIotHubMessageClient.toDateTimeString(this.lastResetTime));
            out.trTitle((Object)"Messages Sent", 2);
            out.prop((Object)"Total Messages Sent OK Count", (double)this.messagesSentOkTotalCount);
            out.prop((Object)"Current Connection Messages Sent OK Count", (double)this.messagesSentOkConnectionCount);
            out.prop((Object)"Last Message Sent OK Time", (Object)BIotHubMessageClient.toDateTimeString(this.lastMessageSentOkTime));
            out.prop((Object)"Total Alarm Messages Sent OK Count", (double)this.alarmMessagesSentOkTotalCount);
            out.prop((Object)"Current Connection Alarm Messages Sent OK Count", (double)this.alarmMessagesSentOkConnectionCount);
            out.prop((Object)"Total History Messages Sent OK Count", (double)this.historyMessagesSentOkTotalCount);
            out.prop((Object)"Current Connection History Messages Sent OK Count", (double)this.historyMessagesSentOkConnectionCount);
            out.prop((Object)"Total Point Messages Sent OK Count", (double)this.pointMessagesSentOkTotalCount);
            out.prop((Object)"Current Connection Point Messages Sent OK Count", (double)this.pointMessagesSentOkConnectionCount);
            out.prop((Object)"Total Command Messages Sent OK Count", (double)this.commandMessagesSentOkTotalCount);
            out.prop((Object)"Current Connection Command Messages Sent OK Count", (double)this.commandMessagesSentOkConnectionCount);
            out.prop((Object)"Total Other Messages Sent OK Count", (double)this.otherMessagesSentOkTotalCount);
            out.prop((Object)"Current Connection Other Messages Sent OK Count", (double)this.otherMessagesSentOkConnectionCount);
            out.trTitle((Object)"Message Send Failures", 2);
            out.prop((Object)"Total Messages Send Failure Count", (double)this.messagesSendFailureTotalCount);
            out.prop((Object)"Current Connection Messages Send Failure Count", (double)this.messagesSendFailureConnectionCount);
            out.prop((Object)"Last Message Send Failure Time", (Object)BIotHubMessageClient.toDateTimeString(this.lastMessageSendFailureTime));
            out.prop((Object)"Total Alarm Messages Sent Failure Count", (double)this.alarmMessagesSentFailureTotalCount);
            out.prop((Object)"Current Connection Alarm Messages Sent Failure Count", (double)this.alarmMessagesSentFailureConnectionCount);
            out.prop((Object)"Total History Messages Sent Failure Count", (double)this.historyMessagesSentFailureTotalCount);
            out.prop((Object)"Current Connection History Messages Sent Failure Count", (double)this.historyMessagesSentFailureConnectionCount);
            out.prop((Object)"Total Point Messages Sent Failure Count", (double)this.pointMessagesSentFailureTotalCount);
            out.prop((Object)"Current Connection Point Messages Sent Failure Count", (double)this.pointMessagesSentFailureConnectionCount);
            out.prop((Object)"Total Command Messages Sent Failure Count", (double)this.commandMessagesSentFailureTotalCount);
            out.prop((Object)"Current Connection Command Messages Sent Failure Count", (double)this.commandMessagesSentFailureConnectionCount);
            out.prop((Object)"Total Other Messages Sent Failure Count", (double)this.otherMessagesSentFailureTotalCount);
            out.prop((Object)"Current Connection Other Messages Sent Failure Count", (double)this.otherMessagesSentFailureConnectionCount);
            out.trTitle((Object)"Messages Received", 2);
            out.prop((Object)"Total Messages Received Count", (double)this.messagesReceivedTotalCount);
            out.prop((Object)"Current Connection Messages Received Count", (double)this.messagesReceivedConnectionCount);
            out.prop((Object)"Last Message Received Time", (Object)BIotHubMessageClient.toDateTimeString(this.lastMessageReceivedTime));
            out.trTitle((Object)"Data Usage", 2);
            out.prop((Object)"Total Bytes Sent", (double)this.bytesSentTotalCount);
            out.prop((Object)"Current Connection Bytes Sent", (double)this.bytesSentConnectionCount);
            out.prop((Object)"Total Alarm Bytes Sent", (double)this.alarmBytesSentTotalCount);
            out.prop((Object)"Current Connection Alarm Bytes Sent", (double)this.alarmBytesSentConnectionCount);
            out.prop((Object)"Total History Bytes Sent", (double)this.historyBytesSentTotalCount);
            out.prop((Object)"Current Connection History Bytes Sent", (double)this.historyBytesSentConnectionCount);
            out.prop((Object)"Total Point Bytes Sent", (double)this.pointBytesSentTotalCount);
            out.prop((Object)"Current Connection Point Bytes Sent", (double)this.pointBytesSentConnectionCount);
            out.prop((Object)"Total Command Bytes Sent", (double)this.commandBytesSentTotalCount);
            out.prop((Object)"Current Connection Command Bytes Sent", (double)this.commandBytesSentConnectionCount);
            out.prop((Object)"Total Other Bytes Sent", (double)this.otherBytesSentTotalCount);
            out.prop((Object)"Current Connection Other Bytes Sent", (double)this.otherBytesSentConnectionCount);
            out.prop((Object)"Total Bytes Received", (double)this.bytesReceivedTotalCount);
            out.prop((Object)"Current Connection Bytes Received", (double)this.bytesReceivedConnectionCount);
        }
        out.trTitle((Object)"Options", 2);
        out.prop((Object)"SAS Token Expiry Time", (double)this.sasTokenExpiryTime);
        out.endProps();
        super.spy(out);
    }

    private static String toDateTimeString(long value) {
        return value > 0L ? BAbsTime.make((long)value).encodeToString() : "n/a";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConnectionCounters() {
        Object object = this.metricLock;
        synchronized (object) {
            this.lastConnectionTime = System.currentTimeMillis();
            this.messagesSentOkConnectionCount = 0L;
            this.messagesSendFailureConnectionCount = 0L;
            this.alarmMessagesSentOkConnectionCount = 0L;
            this.historyMessagesSentOkConnectionCount = 0L;
            this.pointMessagesSentOkConnectionCount = 0L;
            this.commandMessagesSentOkConnectionCount = 0L;
            this.otherMessagesSentOkConnectionCount = 0L;
            this.alarmMessagesSentFailureConnectionCount = 0L;
            this.historyMessagesSentFailureConnectionCount = 0L;
            this.pointMessagesSentFailureConnectionCount = 0L;
            this.commandMessagesSentFailureConnectionCount = 0L;
            this.otherMessagesSentFailureConnectionCount = 0L;
            this.messagesReceivedConnectionCount = 0L;
            this.messageWindowFullConnectionCount = 0L;
            this.bytesSentConnectionCount = 0L;
            this.bytesReceivedConnectionCount = 0L;
            this.alarmBytesSentConnectionCount = 0L;
            this.historyBytesSentConnectionCount = 0L;
            this.pointBytesSentConnectionCount = 0L;
            this.commandBytesSentConnectionCount = 0L;
            this.otherBytesSentConnectionCount = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTotalCounters() {
        Object object = this.metricLock;
        synchronized (object) {
            this.lastResetTime = System.currentTimeMillis();
            this.messagesSentOkTotalCount = 0L;
            this.messagesSendFailureTotalCount = 0L;
            this.alarmMessagesSentOkTotalCount = 0L;
            this.historyMessagesSentOkTotalCount = 0L;
            this.pointMessagesSentOkTotalCount = 0L;
            this.commandMessagesSentOkTotalCount = 0L;
            this.otherMessagesSentOkTotalCount = 0L;
            this.alarmMessagesSentFailureTotalCount = 0L;
            this.historyMessagesSentFailureTotalCount = 0L;
            this.pointMessagesSentFailureTotalCount = 0L;
            this.commandMessagesSentFailureTotalCount = 0L;
            this.otherMessagesSentFailureTotalCount = 0L;
            this.messagesReceivedTotalCount = 0L;
            this.messageWindowFullTotalCount = 0L;
            this.bytesSentTotalCount = 0L;
            this.bytesReceivedTotalCount = 0L;
            this.alarmBytesSentTotalCount = 0L;
            this.historyBytesSentTotalCount = 0L;
            this.pointBytesSentTotalCount = 0L;
            this.commandBytesSentTotalCount = 0L;
            this.otherBytesSentTotalCount = 0L;
        }
    }

    private void setupCompression() {
        try {
            if (this.compressor != null) {
                this.compressor.close();
                this.compressor = null;
            }
            if (this.getCompression() == BCompressionMode.None) {
                return;
            }
            if (this.getCompression() == BCompressionMode.GZip) {
                this.compressor = new ResettableGZIPOutputMemoryStream();
                this.contentType = "application/json+gzip";
                this.compressionType = COMPRESSION_GZIP;
            } else {
                this.compressor = new ResettableDeflaterOutputMemoryStream();
                this.contentType = "application/json+deflate";
                this.compressionType = COMPRESSION_DEFLATE;
            }
        }
        catch (IOException ex) {
            log.log(Level.WARNING, lex.getText("compress.error"), ex);
            this.compressor = null;
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public MessageClientConnectionState getConnectionState() throws IllegalStateException {
        if (this.client == null) {
            return MessageClientConnectionState.DISCONNECTED;
        }
        return this.client.isConnected() ? MessageClientConnectionState.CONNECTED : MessageClientConnectionState.DISCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessageReceived(AmqpMessage message, Throwable err) {
        HashMap<String, String> propMap = new HashMap<String, String>(message.getMetadata().size());
        message.getMetadata().forEach((k, v) -> propMap.put(k.toLowerCase(), String.valueOf(v)));
        propMap.put("CorrelationId", String.valueOf(message.getCorrelationId()));
        Iterator iterator = this.metricLock;
        synchronized (iterator) {
            int len = message.getLength();
            this.bytesReceivedTotalCount += (long)len;
            this.bytesReceivedConnectionCount += (long)len;
            ++this.messagesReceivedTotalCount;
            ++this.messagesReceivedConnectionCount;
            this.lastMessageReceivedTime = System.currentTimeMillis();
        }
        this.getImpl().getCloudConnector().pingOk();
        log.info(() -> String.format("Received message[%s]: message id=%s correlation id=%s", this.client, message.getMessageId(), message.getCorrelationId()));
        for (MessageCallback cb : this.getImpl().getMessageCallbacks()) {
            try {
                cb.onMessage(message.getMessageId(), message.getPayload(), propMap);
            }
            catch (Exception exc) {
                log.log(Level.WARNING, "Processing Received Cloud Connector Message " + message.getMessageId(), log.isLoggable(Level.FINE) ? exc : null);
            }
        }
    }

    @Override
    public void onConnectionLost(AmqpClient client, Throwable err) {
        ++this.connectionDropCount;
        if (client == this.client) {
            this.clearAlarmsFromQueue();
            log.fine("BIotHubMessageClient received connection lost notification");
            this.getImpl().getCloudConnector().reconnectAsync("IotHubMessageClient.onConnectionLost()");
        } else {
            log.fine("BIotHubMessageClient received connection lost from unknown source: " + client);
        }
    }

    public void onConnect(String connectionString) throws Exception {
        try {
            if (this.client != null) {
                this.client.disconnect();
                this.client = null;
            }
            AccessController.doPrivileged(() -> {
                this.client = new AmqpClient(this.getTransport().equals((Object)BIotHubTransport.amqps_ws), this.getSslProtocol().getDisplayTag(null));
                Object object = this.metricLock;
                synchronized (object) {
                    ++this.clientCreationCount;
                }
                this.resetConnectionCounters();
                Map connectionInfo = this.getImpl().getConnectionInfo(AMQP_CONNECTION_INFO_NAME);
                this.client.connect(this, connectionInfo).get(30L, TimeUnit.SECONDS);
                log.fine("IotHubMessageClient connected");
                this.getImpl().getCloudConnector().connectOk();
                messageControlLock.lock();
                this.activeMessages = !this.getHighPriorityQueue().isEmpty() || !this.getLowPriorityQueue().isEmpty();
                this.pendingMessages.set(0);
                this.messageCount = 0L;
                messageControlLock.unlock();
                if (this.activeMessages) {
                    this.manager.execute(this::sendToTransport);
                }
                return null;
            });
        }
        catch (PrivilegedActionException err) {
            throw err.getException();
        }
    }

    public void onDisconnect() throws Exception {
        try {
            AmqpClient ac = this.client;
            if (ac != null) {
                AccessController.doPrivileged(() -> {
                    ac.disconnect();
                    return null;
                });
            }
        }
        finally {
            this.client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] payload, Map<String, String> props, CompletableFuture<String> completableFuture) {
        AmqpClient ac = this.client;
        String messageId = UUID.randomUUID().toString();
        log.finer(() -> String.format("MsgClient[%s].sendMessage() called for msgId %s and uncompressed message size %d", ac, messageId, payload.length));
        log.finest(() -> String.format("MsgClient[%s].sendMessage() called for msgId %s with %s -> %s", ac, messageId, props, new String(payload)));
        String msgType = null;
        if (props.containsKey("NiagaraMessageType")) {
            msgType = props.get("NiagaraMessageType");
        }
        String messageType = msgType;
        completableFuture.whenComplete((resp, err) -> {
            if (err != null) {
                Object object = this.metricLock;
                synchronized (object) {
                    ++this.messagesSendFailureTotalCount;
                    ++this.messagesSendFailureConnectionCount;
                    this.lastMessageSendFailureTime = System.currentTimeMillis();
                    if (messageType != null) {
                        switch (NiagaraMessageType.valueOf((String)messageType)) {
                            case alarm: {
                                ++this.alarmMessagesSentFailureTotalCount;
                                ++this.alarmMessagesSentFailureConnectionCount;
                                break;
                            }
                            case history: {
                                ++this.historyMessagesSentFailureTotalCount;
                                ++this.historyMessagesSentFailureConnectionCount;
                                break;
                            }
                            case hiPriPoint: 
                            case loPriPoint: {
                                ++this.pointMessagesSentFailureTotalCount;
                                ++this.pointMessagesSentFailureConnectionCount;
                                break;
                            }
                            case cmdResp: {
                                ++this.commandMessagesSentFailureTotalCount;
                                ++this.commandMessagesSentFailureConnectionCount;
                                break;
                            }
                            default: {
                                ++this.otherMessagesSentFailureTotalCount;
                                ++this.otherMessagesSentFailureConnectionCount;
                                break;
                            }
                        }
                    } else {
                        ++this.otherMessagesSentFailureTotalCount;
                        ++this.otherMessagesSentFailureConnectionCount;
                    }
                }
                log.fine(() -> String.format("MsgClient[%s].sendMessage() failed for msgId %s", ac, messageId));
            } else {
                this.getImpl().getCloudConnector().pingOk();
                log.finer(() -> String.format("MsgClient[%s].sendMessage() succeeded for msgId %s", ac, messageId));
            }
        });
        if (ac == null) {
            completableFuture.completeExceptionally(new IOException("Not connected to IoT Hub"));
        } else {
            byte[] tmpPayload;
            NiagaraMessageType msgTypeValue;
            if (props.containsKey("CorrelationId")) {
                log.info(String.format("Sending message with id %s in response to %s", messageId, props.get("CorrelationId")));
            }
            BMessageQueue queue = this.getLowPriorityQueue();
            if (msgType != null && ((msgTypeValue = NiagaraMessageType.valueOf((String)msgType)) == NiagaraMessageType.cmdResp || msgTypeValue == NiagaraMessageType.alarm || msgTypeValue == NiagaraMessageType.hiPriPoint)) {
                queue = this.getHighPriorityQueue();
                log.finer(() -> String.format("Sending message to high priority queue. %s", messageId));
            }
            if (queue.isFull()) {
                completableFuture.completeExceptionally(new IOException("Queue full, try again later."));
                return;
            }
            boolean compressed = false;
            if (this.compressor == null || payload.length < 150) {
                tmpPayload = Arrays.copyOf(payload, payload.length);
            } else {
                try {
                    byte[] compressedPayload;
                    IResettableOutputMemoryStream iResettableOutputMemoryStream = this.compressor;
                    synchronized (iResettableOutputMemoryStream) {
                        this.compressor.write(payload);
                        this.compressor.finish();
                        compressedPayload = this.compressor.toCompressedByteArray();
                        this.compressor.reset();
                    }
                    if (compressedPayload.length < payload.length) {
                        compressed = true;
                        tmpPayload = compressedPayload;
                        log.finer(() -> String.format("MsgClient[%s].sendMessage() compressing message with msgId %s, compressed message size %d", ac, messageId, compressedPayload.length));
                    } else {
                        tmpPayload = payload;
                    }
                }
                catch (IOException ex) {
                    log.log(Level.WARNING, String.format(lex.getText("compress.error"), messageId), ex);
                    ++this.messageCompressionFailureCount;
                    this.lastMessageCompressionFailureTime = System.currentTimeMillis();
                    tmpPayload = payload;
                }
            }
            props.remove("NiagaraMessageType");
            HashMap<String, Object> msgProps = new HashMap<String, Object>(props);
            Object msgContentType = msgProps.get(MESSAGE_CONTENT_TYPE);
            if (msgContentType == null) {
                msgContentType = APPLICATION_JSON;
            }
            if (compressed) {
                msgProps.put(MESSAGE_CONTENT_TYPE, msgContentType + this.compressionType);
            } else {
                msgProps.put(MESSAGE_CONTENT_TYPE, msgContentType);
            }
            AmqpMessage amqpMessage = new AmqpMessage(tmpPayload, msgProps);
            if (msgType != null) {
                amqpMessage.setNiagaraMessageType(NiagaraMessageType.valueOf((String)msgType));
            }
            amqpMessage.setMessageId(messageId);
            if (props.containsKey("CorrelationId")) {
                amqpMessage.setCorrelationId(props.get("CorrelationId"));
            }
            queue.enqueueMessage(amqpMessage, completableFuture);
            messageControlLock.lock();
            if (!this.activeMessages) {
                this.activeMessages = true;
                messageControlLock.unlock();
                this.manager.execute(this::sendToTransport);
            } else {
                messageControlLock.unlock();
            }
        }
        log.finer(() -> String.format("MsgClient[%s].sendMessage() exiting for msgId %s", ac, messageId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToTransport() {
        if (this.client == null) {
            log.info("sendToTransport called while not connected.");
            return;
        }
        messageControlLock.lock();
        this.activeManager = true;
        messageControlLock.unlock();
        AmqpClient ac = this.client;
        BMessageQueue hpQueue = this.getHighPriorityQueue();
        BMessageQueue lpQueue = this.getLowPriorityQueue();
        int highPriorityWeight = hpQueue.getWeight();
        long totalWeight = (long)lpQueue.getWeight() + (long)highPriorityWeight;
        while (this.pendingMessages.get() < this.getPendingMessageLimit()) {
            BMessageQueue msgQueue;
            AmqpMessage msg;
            if (ac != this.client) {
                log.info("sendToTransport lost connection.");
                messageControlLock.lock();
                this.activeManager = false;
                messageControlLock.unlock();
                return;
            }
            long now = Clock.ticks();
            if (this.messageWindowEnd < now) {
                this.messageWindowEnd = now + 1000L;
                this.messageWindowCount = 0;
            }
            if (this.messageWindowCount >= this.getSentienceMessageRateLimit() && this.getSentienceMessageRateLimit() > 0) {
                try {
                    Object object = this.metricLock;
                    synchronized (object) {
                        ++this.messageWindowFullConnectionCount;
                        ++this.messageWindowFullTotalCount;
                        this.messageWindowFullTime = System.currentTimeMillis();
                    }
                    long sleepTime = this.messageWindowEnd - now;
                    log.fine(() -> "MESSAGE THROTTLING window full, sleeping for " + sleepTime + " ms");
                    Thread.sleep(sleepTime);
                    this.messageWindowEnd += 1000L;
                    this.messageWindowCount = 0;
                }
                catch (InterruptedException e) {
                    messageControlLock.lock();
                    this.activeManager = false;
                    messageControlLock.unlock();
                    return;
                }
            }
            if (this.messageCount % totalWeight < (long)highPriorityWeight) {
                msg = hpQueue.pullMessage();
                msgQueue = hpQueue;
                if (msg == null) {
                    msg = lpQueue.pullMessage();
                    msgQueue = lpQueue;
                }
            } else {
                msg = lpQueue.pullMessage();
                msgQueue = lpQueue;
                if (msg == null) {
                    msg = hpQueue.pullMessage();
                    msgQueue = hpQueue;
                }
            }
            if (msg == null) {
                messageControlLock.lock();
                this.activeMessages = false;
                this.activeManager = false;
                messageControlLock.unlock();
                return;
            }
            Object object = this.metricLock;
            synchronized (object) {
                ++this.messageCount;
                this.pendingMessages.getAndIncrement();
                ++this.messageWindowCount;
            }
            log.finest(() -> "throttling message count at " + this.messageWindowCount);
            AmqpMessage message = msg;
            BMessageQueue queue = msgQueue;
            try {
                AccessController.doPrivileged(() -> {
                    log.finer(() -> String.format("MsgClient[%s]: Sending message id %s", ac, message.getMessageId()));
                    message.getMessage().setExpiryTime(this.getMessageTimeout().getMillis());
                    try {
                        ac.send(message).whenComplete((deliveryResult, error) -> {
                            this.pendingMessages.getAndDecrement();
                            if (!this.activeManager && this.activeMessages && this.pendingMessages.get() <= this.getPendingMessageLimit() / 2) {
                                this.manager.execute(this::sendToTransport);
                            }
                            if (error == null) {
                                queue.dequeueMessage(message.getMessageId(), null);
                                try {
                                    Object object = this.metricLock;
                                    synchronized (object) {
                                        int length = message.getPayload().length;
                                        this.bytesSentConnectionCount += (long)length;
                                        this.bytesSentTotalCount += (long)length;
                                        ++this.messagesSentOkTotalCount;
                                        ++this.messagesSentOkConnectionCount;
                                        this.lastMessageSentOkTime = System.currentTimeMillis();
                                        NiagaraMessageType messageType = message.getNiagaraMessageType();
                                        if (messageType != null) {
                                            switch (messageType) {
                                                case alarm: {
                                                    this.alarmBytesSentTotalCount += (long)length;
                                                    this.alarmBytesSentConnectionCount += (long)length;
                                                    ++this.alarmMessagesSentOkTotalCount;
                                                    ++this.alarmMessagesSentOkConnectionCount;
                                                    break;
                                                }
                                                case history: {
                                                    this.historyBytesSentTotalCount += (long)length;
                                                    this.historyBytesSentConnectionCount += (long)length;
                                                    ++this.historyMessagesSentOkTotalCount;
                                                    ++this.historyMessagesSentOkConnectionCount;
                                                    break;
                                                }
                                                case hiPriPoint: 
                                                case loPriPoint: {
                                                    this.pointBytesSentTotalCount += (long)length;
                                                    this.pointBytesSentConnectionCount += (long)length;
                                                    ++this.pointMessagesSentOkTotalCount;
                                                    ++this.pointMessagesSentOkConnectionCount;
                                                    break;
                                                }
                                                case cmdResp: {
                                                    this.commandBytesSentTotalCount += (long)length;
                                                    this.commandBytesSentConnectionCount += (long)length;
                                                    ++this.commandMessagesSentOkTotalCount;
                                                    ++this.commandMessagesSentOkConnectionCount;
                                                    break;
                                                }
                                                default: {
                                                    this.otherBytesSentTotalCount += (long)length;
                                                    this.otherBytesSentConnectionCount += (long)length;
                                                    ++this.otherMessagesSentOkTotalCount;
                                                    ++this.otherMessagesSentOkConnectionCount;
                                                    break;
                                                }
                                            }
                                        } else {
                                            this.otherBytesSentTotalCount += (long)length;
                                            this.otherBytesSentConnectionCount += (long)length;
                                            ++this.otherMessagesSentOkTotalCount;
                                            ++this.otherMessagesSentOkConnectionCount;
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    log.log(Level.FINE, "Error occurred recording metrics", ex);
                                }
                            } else if (queue == hpQueue) {
                                queue.retryMessage(message.getMessageId());
                            } else {
                                queue.dequeueMessage(message.getMessageId(), new IotHubMessageException("AMQP delivery failed"));
                            }
                        });
                    }
                    catch (Exception ex) {
                        log.warning(() -> String.format("Error passing message %s to IoT Client, %s", message.getMessageId(), ex));
                        if (queue == hpQueue) {
                            queue.retryMessage(message.getMessageId());
                        }
                        queue.dequeueMessage(message.getMessageId(), ex);
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException err) {
                queue.dequeueMessage(message.getMessageId(), err.getException());
            }
        }
        messageControlLock.lock();
        this.activeManager = false;
        messageControlLock.unlock();
    }

    public static final class IotHubMessageException
    extends IOException {
        private static final long serialVersionUID = 4344449008092008254L;

        private IotHubMessageException(String message) {
            super("IoTHub Message exception:" + message);
        }
    }
}

