/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/util/Counter
 */
define(['baja!', 'nmodule/kitControl/rc/baja/KitNumeric', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, KitNumeric, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of a `kitControl:Counter` value.
   *
   * @class
   * @extends {module:nmodule/kitControl/rc/baja/KitNumeric}
   * @alias {module:nmodule/kitControl/rc/baja/util/Counter}
   */
  var Counter = function Counter() {
    KitNumeric.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };
  Counter.prototype = Object.create(KitNumeric.prototype);
  Counter.prototype.constructor = Counter;
  return Counter;
});
