/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/math/Math
 */
define(['baja!', 'baja!control:NumericPoint', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, types, bajaUtils) {
  'use strict';

  var NumericPoint = baja.findCtor('control:NumericPoint'),
    proxySlotFacets = bajaUtils.proxySlotFacets,
    propagateFacets = baja.Facets.make({
      fieldEditor: 'kitControl:PropagateFlagsFE',
      uxFieldEditor: 'kitControl:PropagateFlagsEditor'
    });

  /**
   * BajaScript representation of a `kitControl:Math` value.
   *
   * @class
   * @extends {module:baja/comp/ControlPoint}
   * @alias {module:nmodule/kitControl/rc/baja/math/Math}
   */
  var Math = function Math() {
    NumericPoint.apply(this, arguments);
    proxySlotFacets(this, {
      '^propagateFlags$': propagateFacets
    });
  };
  Math.prototype = Object.create(NumericPoint.prototype);
  Math.prototype.constructor = Math;
  return Math;
});
