/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/logic/Logic
 */
define(['baja!', 'baja!control:BooleanPoint', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, types, bajaUtils) {
  'use strict';

  var BooleanPoint = baja.findCtor('control:BooleanPoint'),
    proxySlotFacets = bajaUtils.proxySlotFacets,
    propagateFacets = baja.Facets.make({
      fieldEditor: 'kitControl:PropagateFlagsFE',
      uxFieldEditor: 'kitControl:PropagateFlagsEditor'
    });

  /**
   * BajaScript representation of a `kitControl:Logic` value.
   *
   * @class
   * @extends {module:baja/comp/ControlPoint}
   * @alias {module:nmodule/kitControl/rc/baja/logic/Logic}
   */
  var Logic = function Logic() {
    BooleanPoint.apply(this, arguments);
    proxySlotFacets(this, {
      '^propagateFlags$': propagateFacets
    });
  };
  Logic.prototype = Object.create(BooleanPoint.prototype);
  Logic.prototype.constructor = Logic;
  return Logic;
});
