/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/StatusNumericToDouble
 */
define(['baja!', 'nmodule/kitControl/rc/baja/conversion/StatusValueToValue', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, StatusValueToValue, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of a `kitControl:StatusNumericToDouble` value.
   *
   * @class
   * @extends {module:nmodule/kitControl/rc/baja/conversion/StatusValueToValue}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/StatusNumericToDouble}
   */
  var StatusNumericToDouble = function StatusNumericToDouble() {
    StatusValueToValue.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };
  StatusNumericToDouble.prototype = Object.create(StatusValueToValue.prototype);
  StatusNumericToDouble.prototype.constructor = StatusNumericToDouble;

  /**
   * Return the value of the `facets` slot.
   *
   * @returns {baja.Facets}
   */
  StatusNumericToDouble.prototype.getOutFacets = function () {
    return this.get('facets');
  };
  return StatusNumericToDouble;
});
