/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/NumericUnitConverter
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
    proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:NumericUnitConverter` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/NumericUnitConverter}
   */
  var NumericUnitConverter = function NumericUnitConverter() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^in$': 'inFacets',
      '^out$': 'outFacets'
    });
  };
  NumericUnitConverter.prototype = Object.create(Component.prototype);
  NumericUnitConverter.prototype.constructor = NumericUnitConverter;
  return NumericUnitConverter;
});
