/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/LoopAlarmAlgorithm
 */
define(['baja!', 'nmodule/alarm/rc/baja/ext/AlarmAlgorithm'], function (baja, AlarmAlgorithm) {
  'use strict';

  /**
   * BajaScript representation of a `kitControl:LoopAlarmAlgorithm` value.
   *
   * @class
   * @extends {module:nmodule/alarm/rc/baja/ext/AlarmAlgorithm}
   * @alias {module:nmodule/kitControl/rc/baja/LoopAlarmAlgorithm}
   */
  var LoopAlarmAlgorithm = function LoopAlarmAlgorithm() {
    AlarmAlgorithm.apply(this, arguments);
  };
  LoopAlarmAlgorithm.prototype = Object.create(AlarmAlgorithm.prototype);
  LoopAlarmAlgorithm.prototype.constructor = LoopAlarmAlgorithm;

  /**
   * For `deadband` and `errorLimit` slots, return the `inputFacets` from the
   * parent `kitControl:LoopPoint`.
   *
   * @param {baja.Slot|String} slot
   * @returns {baja.Facets}
   */
  LoopAlarmAlgorithm.prototype.getFacets = function (slot) {
    var parentPoint = this.getParentPoint();
    //TODO: NCCB-16622
    switch (String(slot)) {
      case 'deadband':
      case 'errorLimit':
        if (baja.lt('kitControl:LoopPoint') && baja.hasType(parentPoint, 'kitControl:LoopPoint')) {
          return parentPoint.get('inputFacets');
        }
        return baja.Facets.DEFAULT;
    }
    return AlarmAlgorithm.prototype.getFacets.apply(this, arguments);
  };
  return LoopAlarmAlgorithm;
});
