/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/fe/WeeklyScheduleEditor
 */
define(['baja!', 'lex!baja', 'bajaux/events', 'bajaux/Properties', 'bajaux/commands/Command', 'bajaux/mixin/subscriberMixIn', 'bajaux/util/CommandButton', 'bajaux/util/SaveCommand', 'jquery', 'Promise', 'nmodule/schedule/rc/baja/fe/BajaWeekEditor', 'nmodule/schedule/rc/baja/model/ScheduleTranslator', 'nmodule/schedule/rc/baja/fe/WeeklySchedulePropertiesBar', 'nmodule/schedule/rc/fe/menu/WeekScheduleContextMenu', 'nmodule/schedule/rc/servlets/ssc', 'nmodule/schedule/rc/util/scheduleUtils', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'css!nmodule/schedule/rc/fe/schedule'], function (baja, lexs, events, Properties, Command, subscribable, CommandButton, SaveCommand, $, Promise, BajaWeekEditor, ScheduleTranslator, WeeklySchedulePropertiesBar, WeekScheduleContextMenu, ssc, scheduleUtils, fe, BaseEditor) {
  'use strict';

  var bajaLex = lexs[0],
    MODIFY_EVENT = events.MODIFY_EVENT,
    getNewBlockValue = scheduleUtils.getNewBlockValue,
    getSnapshot = ssc.getSnapshot,
    save = ssc.save;
  var tpl = function tpl(ed) {
    return "\n    <div class=\"weeklySchedule\">\n      <div class=\"toggleProperties ux-btn-tb\"></div>\n      <div class=\"properties collapsed\"></div>\n      <div class=\"week\"></div>\n    </div>";
  };

  /**
   * @class
   * @alias module:nmodule/schedule/rc/fe/WeeklyScheduleEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @param {Object} params
   */
  var WeeklyScheduleEditor = function WeeklyScheduleEditor(params) {
    var that = this;
    BaseEditor.call(that, $.extend({}, {
      moduleName: 'schedule',
      keyName: 'WeeklyScheduleEditor'
    }, params));
    that.getCommandGroup().add(new Command({
      enabled: false,
      module: 'schedule',
      lex: 'commands.deleteEvent',
      func: function func() {
        var cmd = this,
          dayEds = that.$getWeekEditor().getChildEditors();
        return Promise.all(dayEds.map(function (dayEd) {
          return dayEd.deleteScheduleBlock(dayEd.$getSelectedBlock());
        })).then(function () {
          cmd.setEnabled(false);
        });
      }
    }));
    that.getCommandGroup().add(new SaveCommand());
    subscribable(this);
  };
  WeeklyScheduleEditor.prototype = Object.create(BaseEditor.prototype);
  WeeklyScheduleEditor.prototype.constructor = WeeklyScheduleEditor;
  WeeklyScheduleEditor.prototype.$getDeleteCommand = function () {
    return this.getCommandGroup().get(0);
  };
  WeeklyScheduleEditor.prototype.$getPropertiesElement = function () {
    return this.jq().children('.weeklySchedule').children('.properties');
  };
  WeeklyScheduleEditor.prototype.$getWeekEditor = function () {
    return this.jq().children('.weeklySchedule').children('.week').data('widget');
  };
  WeeklyScheduleEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html(tpl(this));
    dom.on(MODIFY_EVENT, '.weeklySchedule', function () {
      that.setModified(true);
      return true;
    });
    dom.on('selectionChange', function (e, dayEd, block) {
      that.$getDeleteCommand().setEnabled(!!block);
    });
    return fe.buildFor({
      dom: dom.find('.toggleProperties'),
      type: CommandButton,
      value: new Command({
        icon: 'module://icons/x16/gear.png',
        func: function func() {
          that.$getPropertiesElement().toggleClass('collapsed');
        }
      })
    });
  };
  WeeklyScheduleEditor.prototype.doLoad = function (weeklySchedule) {
    var that = this,
      jq = that.jq(),
      weeklyScheduleDiv = jq.children('.weeklySchedule');
    return Promise.all([getSnapshot(weeklySchedule.getNavOrd()), makeTimeLabels()]).spread(function (snapshot, timeLabels) {
      that.$snapshot = snapshot;
      that.$sourceOrd = weeklySchedule.getNavOrd();
      var defaultOutput = snapshot.get('defaultOutput'),
        facets = snapshot.get('facets'),
        translator = that.$translator = new ScheduleTranslator(facets);
      return Promise.all([translator.toModel(snapshot).then(function (weekSchedule) {
        return fe.buildFor({
          dom: weeklyScheduleDiv.children('.week'),
          type: BajaWeekEditor,
          properties: Properties.extend(weeklySchedule.get('facets').toObject(), {
            effectiveValue: getNewBlockValue(defaultOutput, facets),
            firstDayOfWeek: bajaLex.get('weekday.firstDayOfWeek'),
            timeLabels: timeLabels,
            translator: translator,
            sourceOrd: that.$sourceOrd
          }),
          value: weekSchedule
        });
      }).then(function (ed) {
        new WeekScheduleContextMenu(ed).arm();
      }), fe.buildFor({
        dom: weeklyScheduleDiv.children('.properties'),
        type: WeeklySchedulePropertiesBar,
        value: snapshot
      })]);
    });
  };
  WeeklyScheduleEditor.prototype.doSave = function () {
    var that = this;
    return Promise.all([that.$getWeekEditor().read().then(function (weekSchedule) {
      return that.$translator.fromModel(weekSchedule);
    }), that.getChildEditors().saveAll()]).spread(function (weekSchedule) {
      that.$snapshot.get('schedule').set({
        slot: 'week',
        value: weekSchedule
      });
      return save(that.value().getNavOrd(), that.$snapshot);
    });
  };
  WeeklyScheduleEditor.prototype.doDestroy = function () {
    return this.getChildWidgets().destroyAll();
  };
  function makeTimeLabels() {
    return Promise.all([3, 6, 9, 12, 15, 18, 21].map(function (hour) {
      return baja.Time.make({
        hour: hour
      }).toTimeString();
    }));
  }
  return WeeklyScheduleEditor;
});
