function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/baja/util/bindDayEditorToTimeSchedule
 */
define(['baja!schedule:TimeSchedule', 'bajaux/events', 'jquery', 'Promise', 'underscore', 'nmodule/js/rc/log/Log'], function (types, events, $, Promise, _, Log) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;

  /**
   * This class provides a binding between a BajaDayEditor and a
   * TimeScheduleEditor. Whenever a schedule block in the day editor is selected
   * or changed, that block's value will be loaded into the TimeScheduleEditor.
   * And when the TimeScheduleEditor is changed by the user, the selected block
   * will be updated in the BajaDayEditor. This allows quick inline editing of
   * the individual blocks in the BajaDayEditor.
   *
   * @alias module:nmodule/schedule/rc/baja/util/bindDayEditorToTimeSchedule
   * @param {Function.<module:nmodule/schedule/rc/baja/fe/BajaDayEditor>} getDayEditor when
   * a modify event is triggered from the time schedule editor, use this
   * function to retrieve the corresponding day editor
   * @param {Function.<module:nmodule/schedule/rc/baja/fe/TimeScheduleEditor>} getTimeScheduleEditor when
   * a modify event is triggered from the day editor, use this function to
   * retrieve the corresponding time schedule editor
   * @param {baja.Component} defaultTimeSchedule the default
   * `schedule:TimeSchedule` to load in when no schedule block is selected
   * @param {jQuery} dom parent element to listen for events from both editors
   * @param {module:bajaux/commands/Command} editEventCommand (optional) command used to pop up an edit dialog.
   *  This command is enabled when a schedule block is selected, and disabled when no schedule blocks
   *  are selected.
   */
  function bindDayEditorToTimeSchedule(getDayEditor, getTimeScheduleEditor, defaultTimeSchedule, dom, editEventCommand) {
    dom.on(['selectionChange', MODIFY_EVENT].join(' '), '.DayEditor', function (e, dayEd) {
      selectedBlockChanged(dayEd, getTimeScheduleEditor(), defaultTimeSchedule, editEventCommand)["catch"](Log.error);
    });
    dom.on(MODIFY_EVENT, '.TimeScheduleEditor', function (ed, timeScheduleEd) {
      timeScheduleChanged(getDayEditor(), timeScheduleEd)["catch"](Log.error);
    });
  }

  /**
   * When the user selects a new block, or makes changes to the selected block,
   * apply those changes to the TimeSchedule editor.
   * @private
   * @returns {Promise}
   */
  function selectedBlockChanged(dayEd, timeScheduleEd, defaultTimeSchedule, editEventCommand) {
    var blockEd = dayEd.$getSelectedBlockEditor(),
      translator = dayEd.$getTranslator(),
      facets = dayEd.$getFacets();
    if (!timeScheduleEd) {
      return Promise.resolve();
    }
    timeScheduleEd.properties().add("shouldValidate", !!blockEd);
    if (!blockEd) {
      //deselected all
      if (editEventCommand) {
        editEventCommand.setEnabled(false);
      }
      return Promise.all([timeScheduleEd.setReadonly(true), timeScheduleEd.load(defaultTimeSchedule)]);
    }
    if (editEventCommand) {
      editEventCommand.setEnabled(true);
    }
    timeScheduleEd.properties().add("dayEditor", dayEd);
    timeScheduleEd.properties().add("editedBlock", blockEd.value());
    return blockEd.read().then(function (scheduleBlock) {
      return Promise.all([translator.fromModel(scheduleBlock), readTimeSchedule(timeScheduleEd)]);
    }).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        timeSchedule = _ref2[0],
        existingTimeSchedule = _ref2[1];
      if (existingTimeSchedule && timeSchedule.getStart().equivalent(existingTimeSchedule.getStart()) && timeSchedule.getFinish().equivalent(existingTimeSchedule.getFinish()) && timeSchedule.get("effectiveValue").equivalent(existingTimeSchedule.get("effectiveValue"))) {
        //This handles NCCB-29451: where timeScheduleEd is no longer improperly readonly
        return timeScheduleEd.setReadonly(dayEd.isReadonly());
      }
      timeSchedule.setFacets({
        slot: 'effectiveValue',
        facets: facets
      });
      return Promise.all([timeScheduleEd.setReadonly(dayEd.isReadonly()),
      //TODO: ComplexCompositeEditor#load does not update the result of getComplex()
      Promise.all(['start', 'finish', 'effectiveValue'].map(function (slot) {
        var kid = timeScheduleEd.getBuilder().getEditorFor(slot);
        return kid.load(timeSchedule.get(slot));
      }))]).then(function () {
        _.each(timeScheduleEd.jq().find('.editor'), function (el) {
          var widget = $(el).data('widget');
          widget.$modified = true;
          widget.properties().add("shouldValidate", true);
        });
      });
    });
  }
  function readTimeSchedule(timeScheduleEd) {
    return timeScheduleEd.read().then(function (diff) {
      return diff.apply(timeScheduleEd.value().newCopy(true));
    })["catch"](function () {
      return null;
    });
  }

  /**
   * When the user makes a change to the TimeSchedule editor, apply those
   * changes back to the selected schedule block.
   * @private
   * @returns {Promise}
   */
  function timeScheduleChanged(dayEd, timeScheduleEd) {
    var selectedBlock = dayEd.$getSelectedBlockEditor();
    return timeScheduleEd.validate().then(function (diff) {
      return diff.apply(timeScheduleEd.value().newCopy(true));
    }).then(function (timeSchedule) {
      return dayEd.$loadTimeScheduleIntoBlock(selectedBlock, timeSchedule);
    }).then(function () {
      return dayEd.setModified(true);
    })["catch"](function (ignore) {});
  }
  return bindDayEditorToTimeSchedule;
});
