/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/schedule/rc/baja/fe/WeekdayScheduleEnumSetEditor', 'nmodule/schedule/rc/baja/fe/WeekOfMonthScheduleEnumSetEditor', 'nmodule/schedule/rc/baja/fe/MonthScheduleEnumSetEditor'], function (CompositeEditor, CompositeBuilder, WeekdayScheduleEnumSetEditor, WeekOfMonthScheduleEnumSetEditor, MonthScheduleEnumSetEditor) {
  'use strict';

  var tpl = function tpl(ed) {
    return "\n    <div class=\"composite-schedule-editor simple-schedule-editor\">\n      <div class=\"weekdays-schedule-editor\"></div>\n      <div class=\"weeksOfMonth-schedule-editor\"></div>\n      <div class=\"months-schedule-editor\"></div>\n    </div>";
  };

  /**
   * Editor for a `schedule:WeekAndDaySchedule`.
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/WeekAndDayScheduleEditor
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */
  var WeekAndDayScheduleEditor = function WeekAndDayScheduleEditor() {
    CompositeEditor.apply(this, arguments);
  };
  WeekAndDayScheduleEditor.prototype = Object.create(CompositeEditor.prototype);
  WeekAndDayScheduleEditor.prototype.constructor = WeekAndDayScheduleEditor;
  WeekAndDayScheduleEditor.prototype.doInitialize = function (dom) {
    dom.html(tpl(this));
    return CompositeEditor.prototype.doInitialize.apply(this, arguments);
  };
  WeekAndDayScheduleEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getKeys = function () {
      return ['weekdays', 'weeksOfMonth', 'months'];
    };
    builder.getDomFor = function (key) {
      return that.jq().find('.' + key + '-schedule-editor');
    };
    builder.getValueFor = function (key) {
      var weekAndDaySchedule = this.getDataSource();
      return weekAndDaySchedule.get(key).get('set');
    };
    var editorTypeForKey = {
      'weekdays': WeekdayScheduleEnumSetEditor,
      'weeksOfMonth': WeekOfMonthScheduleEnumSetEditor,
      'months': MonthScheduleEnumSetEditor
    };
    builder.getConfigFor = function (key) {
      var weekAndDaySchedule = this.getDataSource(),
        formFactor = that.getFormFactor();
      return {
        complex: weekAndDaySchedule.get(key),
        slot: 'set',
        type: editorTypeForKey[key],
        formFactor: formFactor,
        properties: {
          singleSelection: true,
          includeGroups: key === 'months'
        }
      };
    };
    return builder;
  };
  return WeekAndDayScheduleEditor;
});
