function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/baja/fe/TriggerTimesToAddEditor
 */
define(['baja!', 'lex!schedule', 'bajaux/events', 'Promise', 'nmodule/js/rc/log/Log', 'nmodule/schedule/rc/fe/templates', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor'], function (baja, lexs, events, Promise, Log, templates, ComplexCompositeEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    scheduleLex = _lexs[0],
    MODIFY_EVENT = events.MODIFY_EVENT,
    lexLabel = templates.lexLabel;
  var tpl = function tpl(ed) {
    return "\n    <div class=\"time\"></div>\n    <div class=\"isRange\"></div>\n    <table class=\"rangeInfo hide-table\">\n      <tr>\n        <td>".concat(lexLabel('trigger.rangeEnd'), "</td>\n        <td><span class=\"rangeEnd\"></span></td>\n      </tr>\n      <tr>\n        <td>").concat(lexLabel('trigger.rangeInterval'), "</td>\n        <td><span class=\"interval\"></span></td>\n      </tr>\n    </table>");
  };

  /**
   * Editor for the user-configurable settings for adding a time or range of
   * times to the list of trigger times on a `TriggerSchedule`.
   *
   * This editor expects a certain configured component to be loaded - when
   * calling `load()`, give it the result of
   * `TriggerTimesToAddEditor.makeComponent()`.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   * @alias module:nmodule/schedule/rc/baja/fe/TriggerTimesToAddEditor
   */
  var TriggerTimesToAddEditor = function TimesToAddEditor() {
    ComplexCompositeEditor.apply(this, arguments);
  };
  TriggerTimesToAddEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  TriggerTimesToAddEditor.prototype.constructor = TriggerTimesToAddEditor;

  /**
   * @param {jQuery} dom
   * @returns {Promise}
   */
  TriggerTimesToAddEditor.prototype.doInitialize = function (dom) {
    var _this = this;
    dom.html(tpl(this));
    dom.on(MODIFY_EVENT, '.isRange', function (e, ed) {
      ed.read().then(function (isRange) {
        return Promise.all([_this.getBuilder().getEditorFor('rangeEnd').setEnabled(isRange), _this.getBuilder().getEditorFor('interval').setEnabled(isRange), _this.$showRange(isRange)]);
      })["catch"](Log.error);
    });
    return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
  };
  TriggerTimesToAddEditor.prototype.$showRange = function (show) {
    this.jq().find('.rangeInfo').toggleClass('hide-table', !show);
  };

  /**
   * Reads out the desired list of trigger times. If the range checkbox is not
   * checked, returns only the entered time; otherwise, calculates all trigger
   * times in the configured range.
   *
   * @returns {Promise.<Array.<baja.Time>>} times to add to the trigger list
   */
  TriggerTimesToAddEditor.prototype.doRead = function () {
    var builder = this.getBuilder(),
      keys = builder.getKeys();
    return Promise.all(keys.map(function (k) {
      return builder.getEditorFor(k).read();
    })).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 4),
        time = _ref2[0],
        isRange = _ref2[1],
        rangeEnd = _ref2[2],
        interval = _ref2[3];
      if (isRange) {
        return TriggerTimesToAddEditor.$getTriggerTimes(time, rangeEnd, interval);
      } else {
        return [time];
      }
    });
  };
  TriggerTimesToAddEditor.prototype.getSlotFilter = function () {
    return function (slot) {
      var config = {
        properties: {
          showSeconds: false
        }
      };
      switch (slot.getName()) {
        case 'rangeEnd':
        case 'interval':
          config.enabled = false;
          break;
      }
      return config;
    };
  };
  TriggerTimesToAddEditor.prototype.$buildSubEditorDom = function (key) {
    return this.jq().find('.' + key);
  };

  /**
   * Get all trigger times within the configured start, end, and repeat interval.
   *
   * @private
   * @param {baja.Time} startTime
   * @param {baja.Time} endTime (inclusive)
   * @param {baja.RelTime} interval
   * @returns {Array.<baja.Time>}
   */
  TriggerTimesToAddEditor.$getTriggerTimes = function (startTime, endTime, interval) {
    if (interval.getMillis() <= 0) {
      return [startTime];
    }
    var t = startTime,
      times = [];
    do {
      times.push(t);
      var next = plusInterval(t, interval);
      if (!next.isAfter(t)) {
        return times; //we've looped
      }
      t = next;
    } while (!t.isAfter(endTime));
    return times;
  };

  /**
   * @returns {baja.Component} a component to be loaded into this editor
   */
  TriggerTimesToAddEditor.makeComponent = function () {
    var comp = baja.$('baja:Component', {
        time: baja.Time.make({
          hour: 0,
          min: 0
        }),
        isRange: false,
        rangeEnd: baja.Time.make({
          hour: 23,
          min: 59
        }),
        interval: baja.RelTime.make({
          hours: 1
        })
      }),
      rangeText = scheduleLex.get('trigger.range');
    comp.setFacets({
      slot: 'isRange',
      facets: baja.Facets.make({
        trueText: rangeText,
        falseText: rangeText
      })
    });
    comp.setFacets({
      slot: 'interval',
      facets: baja.Facets.make({
        max: baja.RelTime.make({
          hours: 12
        }),
        min: baja.RelTime.make({
          hours: 0
        })
      })
    });
    return comp;
  };

  //TODO: add to baja.Time
  function plusInterval(time, relTime) {
    return baja.Time.make(time.getTimeOfDayMillis() + relTime.getMillis());
  }
  return TriggerTimesToAddEditor;
});
