function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/baja/fe/TimeScheduleEditor
 */
define(['lex!schedule', 'Promise', 'underscore', 'nmodule/schedule/rc/fe/templates', 'nmodule/schedule/rc/model/TimeOfDay', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor'], function (lexs, Promise, _, templates, TimeOfDay, ComplexCompositeEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    scheduleLex = _lexs[0],
    lexLabel = templates.lexLabel;
  var SLOTS = ['start', 'finish', 'effectiveValue'];
  var tpl = function tpl(ed) {
    return "\n    <div class=\"ux-table-row\">".concat(lexLabel('day.start'), "<div class=\"js-start\"></div></div>\n    <div class=\"ux-table-row\">").concat(lexLabel('day.finish'), "<div class=\"js-finish\"></div></div>\n    <div class=\"ux-table-row\">").concat(lexLabel('day.output'), "<div class=\"js-effectiveValue\"></div></div>\n  ");
  };

  /**
   * Editor for editing the `start`, `finish`, and `effectiveValue` slots of a
   * `schedule:TimeSchedule`.
   *
   * The use case for this will probably be changing the properties of the
   * `TimeSchedule` represented by one selected draggable block on a
   * `DayEditor`. In this case, it will validate that the entered time range
   * does not overlap with any other blocks in that day. To do this, pass the
   * following `bajaux` `Properties`:
   *
   * - `dayEditor`: the `DayEditor` containing the edited block (will compare
   *   against the other blocks in this day)
   * - `editedBlock`: the `ScheduleBlock` being edited (so we don't do the
   *   overlap check against ourselves)
   *
   * @class
   * @alias module:nmodule/schedule/rc/baja/fe/TimeScheduleEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   */
  var TimeScheduleEditor = function TimeScheduleEditor() {
    var _this = this;
    ComplexCompositeEditor.apply(this, arguments);
    var toTimesOfDay = function toTimesOfDay(diff) {
      var timeSchedule = _this.value();
      return Promise.all([diff.getValue(timeSchedule, 'start'), diff.getValue(timeSchedule, 'finish')]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          s = _ref2[0],
          f = _ref2[1];
        return [new TimeOfDay(s), new TimeOfDay(f)];
      });
    };
    var startBeforeFinish = function startBeforeFinish(diff) {
      return toTimesOfDay(diff).then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
          start = _ref4[0],
          finish = _ref4[1];
        var startMs = start.getTimeOfDayMillis(),
          finishMs = finish.getTimeOfDayMillis();
        if (finishMs && finishMs <= startMs) {
          throw new Error('start must be before finish');
        }
      });
    };
    var noOverlap = function noOverlap(diff) {
      var props = _this.properties(),
        dayEditor = props.getValue('dayEditor'),
        editedBlock = props.getValue('editedBlock');
      if (!dayEditor) {
        return;
      }
      return Promise.all([toTimesOfDay(diff), dayEditor.readScheduleBlocks()]).then(function (_ref5) {
        var _ref6 = _slicedToArray(_ref5, 2),
          _ref6$ = _slicedToArray(_ref6[0], 2),
          start = _ref6$[0],
          finish = _ref6$[1],
          blocks = _ref6[1];
        blocks.forEach(function (b) {
          if (b !== editedBlock && b.overlaps(start, finish)) {
            throw new Error(scheduleLex.get({
              key: 'scheduleBlock.timeRangeOverlaps',
              args: [start, finish, b.getStart(), b.getFinish()]
            }));
          }
        });
      });
    };
    var validators = this.validators();
    validators.add(startBeforeFinish);
    validators.add(noOverlap);
  };
  TimeScheduleEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  TimeScheduleEditor.prototype.constructor = TimeScheduleEditor;

  //TODO: why not just a slotFilter Property?
  TimeScheduleEditor.prototype.getSlotFilter = function () {
    var _this2 = this;
    return function (slot) {
      if (_.contains(SLOTS, slot.getName())) {
        return {
          properties: _.extend({
            showSeconds: false
          }, _this2.properties().toValueMap())
        };
      }
    };
  };
  TimeScheduleEditor.prototype.$buildSubEditorDom = function (slot) {
    return this.jq().find('.js-' + slot);
  };
  TimeScheduleEditor.prototype.doInitialize = function (dom) {
    dom.addClass('TimeScheduleEditor').html(tpl(this));
    return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
  };
  TimeScheduleEditor.prototype.doDestroy = function () {
    this.jq().removeClass('TimeScheduleEditor');
    return ComplexCompositeEditor.prototype.doDestroy.apply(this, arguments);
  };
  return TimeScheduleEditor;
});
