/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['lex!schedule', 'Promise', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/schedule/rc/baja/fe/DateScheduleEditor', 'nmodule/schedule/rc/util/scheduleUtils'], function (lexs, Promise, ComplexCompositeEditor, DateScheduleEditor, scheduleUtils) {
  'use strict';

  var scheduleLex = lexs[0],
    checkValidDateRange = scheduleUtils.checkValidDateRange;

  /**
   * Editor for a `schedule:DateRangeSchedule`.
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/DateRangeScheduleEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   */
  var DateRangeScheduleEditor = function DateRangeScheduleEditor() {
    var that = this;
    ComplexCompositeEditor.apply(that, arguments);
    that.validators().add(function () {
      if (!that.value()) {
        return;
      }
      var builder = that.getBuilder();
      return Promise.all([builder.getEditorFor('start').read(), builder.getEditorFor('end').read()]).spread(function (start, end) {
        if (!checkValidDateRange(start, end)) {
          throw new Error(scheduleLex.get('daterange.startAfterEnd'));
        }
      });
    });
  };
  DateRangeScheduleEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  DateRangeScheduleEditor.prototype.constructor = DateRangeScheduleEditor;

  /**
   * Use the default editors for the `start` and `end` `DateRangeSchedule`s,
   * using the same form factor as the `DateRangeScheduleEditor` itself.
   *
   * @returns {Array.<Object>}
   */
  DateRangeScheduleEditor.prototype.getSlotFilter = function () {
    var formFactor = this.getFormFactor();
    return [{
      slot: 'start',
      formFactor: formFactor,
      type: DateScheduleEditor
    }, {
      slot: 'end',
      formFactor: formFactor,
      type: DateScheduleEditor
    }];
  };
  return DateRangeScheduleEditor;
});
