/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnetOws/rc/wb/mgr/BacnetOwsDeviceUxManager
 */
define(['baja!',
        'underscore',
        'nmodule/bacnet/rc/wb/mgr/BacnetDeviceUxManager',
        'nmodule/bacnetOws/rc/wb/mgr/commands/GetEnrollmentSummaryCommand',
        'nmodule/bacnetOws/rc/wb/mgr/commands/GetEventInformationCommand',
        'nmodule/webEditors/rc/wb/mgr/mgrUtils',
        'baja!bacnetOws:BacnetOwsNetwork,bacnetOws:BacnetOwsDeviceFolder'], function (
        baja,
        _,
        BacnetDeviceUxManager,
        GetEnrollmentSummaryCommand,
        GetEventInformationCommand,
        mgrUtils) {

  'use strict';

  var BACNET_OWS_FOLDER_TYPE = baja.lt('bacnetOws:BacnetOwsDeviceFolder');

////////////////////////////////////////////////////////////////
// BacnetOwsDeviceUxManager
////////////////////////////////////////////////////////////////

  /**
   * BacnetOwsDeviceUxManager constructor.
   *
   * @class
   * @alias module:nmodule/bacnetOws/rc/wb/mgr/BacnetOwsDeviceUxManager
   * @extends module:nmodule/bacnet/rc/wb/mgr/BacnetDeviceUxManager
   * @param {Object} params
   */
  var BacnetOwsDeviceUxManager = function BacnetOwsDeviceUxManager(params) {
    BacnetDeviceUxManager.call(this, _.extend({
      moduleName: 'bacnetOws',
      keyName: 'BacnetOwsDeviceUxManager',
      folderType: BACNET_OWS_FOLDER_TYPE
    }, params));
  };

  BacnetOwsDeviceUxManager.prototype = Object.create(BacnetDeviceUxManager.prototype);
  BacnetOwsDeviceUxManager.prototype.constructor = BacnetOwsDeviceUxManager;

  /**
   * Return the commands for the manager. The OWS manager adds the enrollment summary
   * and event information commands to those of the base BACnet device manager.
   *
   * @returns {Array.<module:bajaux/commands/Command>}
   */
  BacnetOwsDeviceUxManager.prototype.makeCommands = function () {
    var cmds = BacnetDeviceUxManager.prototype.makeCommands.apply(this, arguments);

    return cmds.concat([ new GetEventInformationCommand(this),
                         new GetEnrollmentSummaryCommand(this) ]);
  };

  /**
   * Function called when the list selection on the main db table is changed.
   * This overrides the base class to enable or disable the commmands added by
   * this view.
   *
   * @private
   * @param {module:nmodule/webEditors/rc/util/ListSelection} selection
   */
  BacnetOwsDeviceUxManager.prototype.onMainTableSelectionChanged = function (selection) {
    var enSummaryCmd = mgrUtils.findCommand(this, GetEnrollmentSummaryCommand),
        evInfoCmnd = mgrUtils.findCommand(this, GetEventInformationCommand),
        enable = this.isSingleDeviceSelected();

    evInfoCmnd.setEnabled(enable);
    enSummaryCmd.setEnabled(enable);

    BacnetDeviceUxManager.prototype.onMainTableSelectionChanged.call(this, selection);
  };

  return BacnetOwsDeviceUxManager;
});
