function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/util/EditStationCommand
 */
define(['log!nmodule.saml.rc.util.EditStationCommand', 'lex!saml', 'Promise', 'baja!', 'bajaux/commands/Command', 'dialogs', 'nmodule/saml/rc/fe/CircleOfTrustManager', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/fe/feDialogs', 'baja!saml:StationServiceProvider', 'css!nmodule/js/rc/dialogs/dialogs'], function (log, lexs, Promise, baja, Command, dialogs, CircleOfTrustManager, compUtils, PropertySheet, Row, feDialogs) {
  'use strict';

  var samlLex = lexs[0];
  //  const logSevere = log.severe.bind(log);

  var StationServiceProviderPropertySheet = /*#__PURE__*/function (_PropertySheet) {
    function StationServiceProviderPropertySheet() {
      _classCallCheck(this, StationServiceProviderPropertySheet);
      return _callSuper(this, StationServiceProviderPropertySheet, arguments);
    }
    _inherits(StationServiceProviderPropertySheet, _PropertySheet);
    return _createClass(StationServiceProviderPropertySheet, [{
      key: "doLoad",
      value: function doLoad(complex) {
        var _this = this;
        return _superPropGet(StationServiceProviderPropertySheet, "doLoad", this, 3)([complex]).then(function () {
          _this.getChildEditors().forEach(function (editor) {
            if (_this.value().getFromNiagaraNetwork() === true && editor.getKey() !== 'useEncryption') {
              editor.setReadonly(true);
            }
          });
        });
      }
    }, {
      key: "getSlotFilter",
      value: function getSlotFilter() {
        return [{
          slot: 'certificate'
        }, {
          slot: 'issuerUrl'
        }, {
          slot: 'useEncryption'
        }];
      }
    }]);
  }(PropertySheet);

  /**
   * Command associated with manager `Edit Station` command button, to edit an existing
   * station (StationServiceProvider) in circle of trust.
   *
   * @class
   * @alias module:nmodule/saml/rc/util/EditStationCommand
   * @extends module:bajaux/commands/Command
   */
  return /*#__PURE__*/function (_Command) {
    /**
     * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
     */
    function EditStationCommand(manager) {
      var _this2;
      _classCallCheck(this, EditStationCommand);
      return _this2 = _callSuper(this, EditStationCommand, [{
        module: 'saml',
        lex: 'CircleOfTrust.command.edit.station',
        enabled: false,
        func: function func() {
          return _this2.$editStation(manager);
        }
      }]);
    }

    /**
     * Handles editing a station in Circle of Trust.
     *
     * @private
     * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
     * @returns {Promise}
     */
    _inherits(EditStationCommand, _Command);
    return _createClass(EditStationCommand, [{
      key: "$editStation",
      value: function $editStation(manager) {
        var selectedRow = manager.getMainTable().getSelectedRows()[0],
          station = selectedRow.getSubject(),
          stationName = station.get('name'),
          serviceProviders = manager.value().getServiceProviders(),
          stationServiceProvider = serviceProviders.get(stationName);
        if (!stationServiceProvider) {
          throw new Error(samlLex.get('CircleOfTrust.commands.edit.station.error'));
        }
        return manager.getOrdBase().then(function (ordBase) {
          return feDialogs.showFor({
            value: stationServiceProvider,
            type: StationServiceProviderPropertySheet,
            properties: {
              showHeader: false,
              showControls: false,
              ordBase: ordBase
            },
            formFactor: 'mini',
            title: samlLex.get('CircleOfTrust.command.edit.station.title', stationName)
          });
        }).then(function (complexDiff) {
          if (complexDiff) {
            return stationServiceProvider;
          } else {
            return null;
          }
        });
      }
    }]);
  }(Command);
});
