function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/util/AddStationCommand
 */
define(['log!nmodule.saml.rc.util.AddStationCommand', 'lex!saml', "lex!webEditors", 'Promise', 'baja!', 'bajaux/commands/Command', 'dialogs', 'nmodule/saml/rc/fe/CircleOfTrustManager', 'nmodule/saml/rc/util/circleOfTrustUtils', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/fe/feDialogs', 'baja!baja:X509Certificate', 'baja!saml:StationServiceProvider', 'css!nmodule/js/rc/dialogs/dialogs'], function (log, lexs, lexWebEditors, Promise, baja, Command, dialogs, CircleOfTrustManager, circleOfTrustUtils, PropertySheet, Row, feDialogs) {
  'use strict';

  var samlLex = lexs[0];
  //  const logSevere = log.severe.bind(log);

  var StationServiceProviderPropertySheet = /*#__PURE__*/function (_PropertySheet) {
    function StationServiceProviderPropertySheet() {
      _classCallCheck(this, StationServiceProviderPropertySheet);
      return _callSuper(this, StationServiceProviderPropertySheet, arguments);
    }
    _inherits(StationServiceProviderPropertySheet, _PropertySheet);
    return _createClass(StationServiceProviderPropertySheet, [{
      key: "getSlotFilter",
      value: function getSlotFilter() {
        return [{
          slot: 'stationName'
        }, {
          slot: 'certificate'
        }, {
          slot: 'issuerUrl'
        }, {
          slot: 'useEncryption'
        }];
      }
    }]);
  }(PropertySheet);

  /**
   * Command associated with manager `Add Station` command button, to add a new
   * station (StationServiceProvider) to circle of trust manually.
   *
   * @class
   * @alias module:nmodule/saml/rc/util/AddStationCommand
   * @extends module:bajaux/commands/Command
   */
  return /*#__PURE__*/function (_Command) {
    /**
     * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
     */
    function AddStationCommand(manager) {
      var _this;
      _classCallCheck(this, AddStationCommand);
      return _this = _callSuper(this, AddStationCommand, [{
        module: 'saml',
        lex: 'CircleOfTrust.command.add.station',
        enabled: true,
        func: function func() {
          return _this.$addStation(manager);
        }
      }]);
    }

    /**
     * Assigns a base station name for the default value in the dialog.
     *
     * @param {string} baseStationName
     */
    _inherits(AddStationCommand, _Command);
    return _createClass(AddStationCommand, [{
      key: "assignBaseStationName",
      value: function assignBaseStationName(baseStationName) {
        this.$baseStationName = baseStationName;
      }

      /**
       * Handles adding a station to Circle of Trust.
       *
       * @private
       * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
       * @returns {Promise}
       */
    }, {
      key: "$addStation",
      value: function $addStation(manager) {
        var _this2 = this;
        var stationServiceProvider = this.$createStationServiceProviderTemplate(manager.value());
        return manager.getOrdBase().then(function (ordBase) {
          return feDialogs.showFor({
            value: stationServiceProvider,
            type: StationServiceProviderPropertySheet,
            properties: {
              showHeader: false,
              showControls: false,
              ordBase: ordBase
            },
            formFactor: 'mini',
            title: samlLex.get('CircleOfTrust.command.add.station')
          });
        }).then(function (complexDiff) {
          if (!complexDiff) {
            return null;
          }
          return _this2.$continueToAddStation(manager, stationServiceProvider);
        })["catch"](function (err) {
          feDialogs.error(err);
          throw err;
        });
      }

      /**
       * Handles adding a station to Circle of Trust.
       *
       * @private
       * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
       * @param {saml:StationServiceProvider} stationServiceProvider
       * @returns {Promise}
       */
    }, {
      key: "$continueToAddStation",
      value: function $continueToAddStation(manager, stationServiceProvider) {
        var circleOfTrust = manager.value();
        var displayName = stationServiceProvider.get('stationName');
        var name = baja.SlotPath.escape(displayName);
        stationServiceProvider.remove('stationName');
        stationServiceProvider.setFromNiagaraNetwork(false);
        if (displayName.trim() === '') {
          throw new Error(samlLex.get('CircleOfTrust.commands.dialog.enterValidName'));
        } else if (this.$checkForDuplicateStationName(circleOfTrust, name)) {
          throw new Error(samlLex.get('CircleOfTrust.commands.dialog.nameAlreadyExists'));
        } else {
          return circleOfTrust.getServiceProviders().add({
            slot: name,
            value: stationServiceProvider
          }).then(function () {
            var station = baja.$('baja:Component', {
              name: name,
              displayName: displayName,
              selected: true,
              fromNiagaraNetwork: false,
              category: 'station'
            });
            var row = new Row(station);
            return manager.getModel().insertRows([row]);
          }).then(function () {
            return manager.reSort();
          });
        }
      }

      /**
       * Check for duplicate station names when adding a new StationServiceProvider.
       *
       * @private
       * @param {baja.Component} circleOfTrust a `saml:CircleOfTrust` instance
       * @param {string} name of station being added
       * @returns {boolean} true = `Duplicate`, false = `Unique`
       */
    }, {
      key: "$checkForDuplicateStationName",
      value: function $checkForDuplicateStationName(circleOfTrust, name) {
        return circleOfTrust.getServiceProviders().getSlots().is("saml:StationServiceProvider").toArray().some(function (serviceProvider) {
          return serviceProvider.getName() === name;
        });
      }

      /**
       * Create a StationServiceProvider Template to be edited when adding a new StationServiceProvider.
       *
       * @private
       * @param {baja.Component} circleOfTrust a `saml:CircleOfTrust` instance
       * @returns {baja.Component} StationServiceProvider
       */
    }, {
      key: "$createStationServiceProviderTemplate",
      value: function $createStationServiceProviderTemplate(circleOfTrust) {
        var stationName = '';
        if (this.$baseStationName && this.$baseStationName.trim().length > 0) {
          stationName = circleOfTrust.getServiceProviders().getUniqueName(this.$baseStationName);
        }
        return baja.$('saml:StationServiceProvider', {
          stationName: stationName,
          certificate: baja.$('baja:X509Certificate'),
          issuerUrl: 'https://jace.domain.com:443/saml/',
          useEncryption: true,
          fromNiagaraNetwork: false
        });
      }
    }]);
  }(Command);
});
