function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/fe/CircleOfTrustTabsWidget
 */
define(['log!nmodule.saml.rc.fe.CircleOfTrustTabsWidget', 'baja!', "lex!webEditors", 'Promise', 'jquery', 'underscore', 'dialogs', 'bajaux/events', 'bajaux/Widget', 'bajaux/util/CommandButtonGroup', 'bajaux/commands/ToggleCommandGroup', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/saml/rc/fe/CircleOfTrustManager', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/saml/rc/util/circleOfTrustUtils', 'css!nmodule/js/rc/dialogs/dialogs', 'css!nmodule/saml/rc/saml'], function (log, baja, lexs, Promise, $, _, dialogs, events, Widget, CommandButtonGroup, ToggleCommandGroup, StringEditor, BaseWidget, fe, CircleOfTrustManager, mgrUtils, circleOfTrustUtils) {
  'use strict';

  var tpl = function tpl() {
    return "\n    <div class=\"CircleOfTrustToggleCommandGroup\">\n    </div>\n    <div class=\"CircleOfTrustToolbar\">\n      <div class=\"CircleOfTrustFilter\">\n      </div>\n    </div>\n    <div class=\"CircleOfTrustManager\">\n    </div>\n  ";
  };
  var webEditorsLex = lexs[0],
    logSevere = log.severe.bind(log),
    MODIFY_EVENT = events.MODIFY_EVENT;

  /**
  * Shows information about circle of trust.
  *
  * @class
  * @alias module:nmodule/saml/rc/fe/CircleOfTrustTabsWidget
  * @extends module:nmodule/webEditors/rc/fe/BaseWidget
  */
  return /*#__PURE__*/function (_BaseWidget) {
    function CircleOfTrustTabsWidget() {
      _classCallCheck(this, CircleOfTrustTabsWidget);
      return _callSuper(this, CircleOfTrustTabsWidget, arguments);
    }
    _inherits(CircleOfTrustTabsWidget, _BaseWidget);
    return _createClass(CircleOfTrustTabsWidget, [{
      key: "doInitialize",
      value:
      /**
       * Adds `CircleOfTrustTabsWidget` class.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
      function doInitialize(dom) {
        var _this = this;
        dom.html(tpl());
        this.$toggleCommandGroup = this.$buildToggleCommandGroup();
        this.$circleOfTrustFilter = new StringEditor({
          properties: {
            placeholder: 'filter list'
          }
        });
        this.$circleOfTrustManager = new CircleOfTrustManager();
        return Promise.all([fe.buildFor({
          dom: $('.CircleOfTrustToggleCommandGroup', dom),
          type: CommandButtonGroup,
          value: this.$getToggleCommandGroup(),
          initializeParams: {
            toggleGroup: true
          }
        }), this.$circleOfTrustFilter.initialize(dom.find('.CircleOfTrustFilter')), this.$circleOfTrustManager.initialize(dom.find('.CircleOfTrustManager'))]).then(function () {
          _this.$circleOfTrustFilterValues = [];
          var debounceFilterModified = _.debounce(function () {
            _this.$handleFilterModified();
          }, 250);
          dom.on(MODIFY_EVENT, '.CircleOfTrustFilter', function () {
            debounceFilterModified();
            return false;
          });
        });
      }

      /**
       * Loads circle of trust manager
       *
       * @param {baja.Component} circleOfTrust
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(circleOfTrust) {
        var _this2 = this;
        var manager = this.$circleOfTrustManager;
        return Promise.all([manager.load(circleOfTrust).then(function () {
          manager.sort(circleOfTrustUtils.getAlphabeticSort());
          manager.getMainTable().sort = function (column, desc) {
            var sortFunction = circleOfTrustUtils.getAlphabeticSort();
            if (desc) {
              sortFunction = circleOfTrustUtils.getReverseAlphabeticSort();
            }
            manager.sort(sortFunction);
          };
          return manager.getModel().setRowFilter(function (row) {
            return row.getSubject().get('category') === circleOfTrustUtils.getCategory(circleOfTrustUtils.STATION_INDEX);
          });
        }).then(function () {
          return _this2.$setCurrentTabValue(circleOfTrustUtils.STATION_INDEX);
        }).then(function () {
          return _this2.$toggleCommandGroup.get(circleOfTrustUtils.STATION_INDEX).setSelected(true);
        }).then(function () {
          _this2.$updateUnseenOfSelectedColumn(circleOfTrustUtils.STATION_INDEX);
          manager.afterLoad();
        }), this.$circleOfTrustFilter.load('')]);
      }

      /**
       * Removes `CircleOfTrustTabs` class.
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('CircleOfTrustTabs');
        return this.getChildWidgets().destroyAll();
      }

      /**
       * Builds the toggle command group used to tab between stations/users/authSchemes.
       *
       * @private
       */
    }, {
      key: "$buildToggleCommandGroup",
      value: function $buildToggleCommandGroup() {
        var _this3 = this;
        return new ToggleCommandGroup({
          onChange: function onChange(value) {
            return _this3.$applyManagerFilter(value, true);
          },
          commands: [{
            module: "saml",
            lex: "CircleOfTrust.commands.toggle.stations",
            value: circleOfTrustUtils.STATION_INDEX
          }, {
            module: "saml",
            lex: "CircleOfTrust.commands.toggle.users",
            value: circleOfTrustUtils.USER_INDEX
          }, {
            module: "saml",
            lex: "CircleOfTrust.commands.toggle.authSchemes",
            value: circleOfTrustUtils.AUTH_SCHEME_INDEX
          }, {
            module: "saml",
            lex: "CircleOfTrust.commands.toggle.prototypes",
            value: circleOfTrustUtils.PROTOTYPES_INDEX
          }]
        });
      }

      /**
       * Handles filtering the display list when the manager filter is modified.
       *
       * @private
       */
    }, {
      key: "$handleFilterModified",
      value: function $handleFilterModified() {
        this.$applyManagerFilter(this.$currentTabValue, true)["catch"](logSevere);
      }

      /**
       * Returns the toggle command group used to tab between stations/users/authSchemes.
       *
       * @private
       *
       * @returns {ToggleCommandGroup}
       */
    }, {
      key: "$getToggleCommandGroup",
      value: function $getToggleCommandGroup() {
        return this.$toggleCommandGroup;
      }

      /**
       * Handles filtering data values displayed in manager table on tab selection event and search.  Optionally
       * displays a confirmation dialog to save modifications prior to changing tab selection.
       *
       * @private
       *
       * @param {number} value
       * @param {boolean} showDialog - optional parameter skipping dialog when false
       * @returns {Promise}
       */
    }, {
      key: "$applyManagerFilter",
      value: function $applyManagerFilter(value) {
        var _this4 = this;
        var showDialog = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        if (!this.$circleOfTrustManager.isModified()) {
          return this.$continueManagerFilter(value);
        }
        if (!showDialog) {
          return this.save().then(function () {
            return _this4.$continueManagerFilter(value);
          }).then(function () {
            return _this4.$circleOfTrustManager.trigger(circleOfTrustUtils.CIRCLE_OF_TRUST_MANAGER_SAVE_EVENT);
          });
        }
        dialogs.showYesNoCancel(webEditorsLex.get('saveChanges')).yes(function () {
          return _this4.$circleOfTrustManager.save({
            currentTabValue: _this4.$currentTabValue
          }).then(function () {
            _this4.$circleOfTrustManager.setModified(false);
            return _this4.$continueManagerFilter(value);
          }).then(function () {
            return _this4.$circleOfTrustManager.trigger(circleOfTrustUtils.CIRCLE_OF_TRUST_MANAGER_SAVE_EVENT);
          });
        }).no(function () {
          _this4.$circleOfTrustManager.setModified(false);
          return _this4.$circleOfTrustManager.reset(_this4.$currentTabValue).then(function () {
            return _this4.$continueManagerFilter(value);
          }).then(function () {
            return _this4.$circleOfTrustManager.trigger(circleOfTrustUtils.CIRCLE_OF_TRUST_MANAGER_RESET_EVENT);
          });
        }).cancel(function () {
          var currentFilterValue = _this4.$circleOfTrustFilterValues[_this4.$currentTabValue] || '';
          return _this4.$circleOfTrustFilter.load(currentFilterValue).then(function () {
            _this4.$toggleCommandGroup.get(_this4.$currentTabValue).setSelected(true);
            if (value !== _this4.$currentTabValue) {
              _this4.$toggleCommandGroup.get(value).setSelected(false);
            }
          });
        });
        return Promise.resolve();
      }

      /**
       * Handles filtering of data values displayed in manager table on tab selection event and search.
       *
       * @private
       *
       * @param {number} tabIndex
       * @returns {Promise}
       */
    }, {
      key: "$continueManagerFilter",
      value: function $continueManagerFilter(tabIndex) {
        var _this5 = this;
        this.$updateUnseenOfSelectedColumn(tabIndex);
        return this.$circleOfTrustFilter.read().then(function (filterValue) {
          _this5.$circleOfTrustFilterValues[_this5.$currentTabValue] = filterValue;
          return _this5.$setCurrentTabValue(tabIndex);
        }).then(function () {
          var tabFilterValue = _this5.$circleOfTrustFilterValues[_this5.$currentTabValue] || '';
          return _this5.$circleOfTrustFilter.load(tabFilterValue).then(function () {
            var regExp = _this5.$buildRowFilterRegExp(tabFilterValue);
            var rowFilter = _this5.$buildRowFilter(circleOfTrustUtils.getCategory(tabIndex), regExp);
            if (_this5.$circleOfTrustManager.getModel()) {
              return _this5.$circleOfTrustManager.getModel().setRowFilter(rowFilter);
            } else {
              return null;
            }
          });
        });
      }

      /**
       * Hide the selected checkbox column on the prototypes tab.
       * @param tabIndex
       */
    }, {
      key: "$updateUnseenOfSelectedColumn",
      value: function $updateUnseenOfSelectedColumn(tabIndex) {
        var mgr = this.$circleOfTrustManager,
          model = mgr.getModel();
        if (model) {
          if (tabIndex === circleOfTrustUtils.PROTOTYPES_INDEX) {
            model.getColumn('selected').setUnseen(true);
          } else {
            model.getColumn('selected').setUnseen(false);
          }
        }
      }

      /**
       * Returns wildcard regular expression for filter test
       *
       * @private
       *
       * @param {String} filterString
       * @returns {RegExp} - circle of trust filter regular expression
       */
    }, {
      key: "$buildRowFilterRegExp",
      value: function $buildRowFilterRegExp(filterString) {
        return new RegExp((filterString || '').replace('$', '\\$').replace(/\*/g, '.*').replace(/\?/g, '.'), 'i');
      }
    }, {
      key: "$buildRowFilter",
      value:
      /**
       * Returns row filter
       *
       * @private
       *
       * @param {Object} category
       * @param {RegExp} regExp
       * @returns {function} - circle of trust filter function
       */
      function $buildRowFilter(category, regExp) {
        return function (row) {
          return row.getSubject().get('category') === category && regExp.test(row.getSubject().get('displayName') || '');
        };
      }
    }, {
      key: "$setCurrentTabValue",
      value:
      /**
       * Sets current tab value ... here and on manager
       *
       * @private
       *
       * @param {number} tabValue
       * @returns {Promise}
       */
      function $setCurrentTabValue(tabValue) {
        this.$currentTabValue = tabValue;
        return this.$circleOfTrustManager.currentTabValueChanged(this.$currentTabValue);
      }
    }]);
  }(BaseWidget);
});
