function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/fe/CircleOfTrustManager
 */
define(['log!nmodule.saml.rc.fe.CircleOfTrustManager', 'baja!', 'dialogs', 'Promise', 'underscore', 'bajaux/events', 'bajaux/Widget', 'lex!saml', 'nmodule/saml/rc/fe/BooleanCheckboxEditor', 'nmodule/saml/rc/fe/SelectedMgrColumn', 'nmodule/saml/rc/util/circleOfTrustUtils', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils', 'nmodule/webEditors/rc/wb/mgr/Manager', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/source/ArrayComponentSource', 'nmodule/saml/rc/util/AddPrototypeCommand', 'nmodule/saml/rc/util/AddStationCommand', 'nmodule/saml/rc/util/EditPrototypeCommand', 'nmodule/saml/rc/util/EditStationCommand', 'nmodule/saml/rc/util/DeletePrototypeCommand', 'nmodule/saml/rc/util/DeleteStationCommand', 'baja!saml:CircleOfTrust', 'baja!saml:StationServiceProvider', 'css!nmodule/saml/rc/saml'], function (log, baja, dialogs, Promise, _, events, Widget, lexs, BooleanCheckboxEditor, SelectedMgrColumn, circleOfTrustUtils, BooleanEditor, DepthSubscriber, spaceUtils, subscriberUtils, Manager, MgrTypeInfo, MgrModel, mgrUtils, IconMgrColumn, NameMgrColumn, PropertyMgrColumn, TypeMgrColumn, Column, ArrayComponentSource, AddPrototypeCommand, AddStationCommand, EditPrototypeCommand, EditStationCommand, DeletePrototypeCommand, DeleteStationCommand) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT,
    logSevere = log.severe.bind(log);
  var samlLex = lexs[0],
    resolveService = spaceUtils.resolveService,
    leaseWhenNeeded = subscriberUtils.leaseWhenNeeded,
    EDITABLE = Column.flags.EDITABLE,
    READONLY = Column.flags.READONLY;

  /**
   * Shows information about circle of trust.
   *
   * @class
   * @alias module:nmodule/saml/rc/fe/CircleOfTrustManager
   * @extends module:nmodule/webEditors/rc/wb/mgr/Manager
   */
  return /*#__PURE__*/function (_Manager) {
    function CircleOfTrustManager() {
      var _this;
      _classCallCheck(this, CircleOfTrustManager);
      _this = _callSuper(this, CircleOfTrustManager, [{
        moduleName: 'saml',
        keyName: 'CircleOfTrustManager'
      }]);
      _this.$leaseIdpServiceWhenNeeded = leaseWhenNeeded(_.partial(resolveService, 'saml:SAMLIdPService'));
      _this.$subscriber = new DepthSubscriber(2);
      return _this;
    }

    /**
     * Initializes `CircleOfTrustManager` event handling.
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */
    _inherits(CircleOfTrustManager, _Manager);
    return _createClass(CircleOfTrustManager, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        this.$addStationCommand = new AddStationCommand(this);
        this.$editStationCommand = new EditStationCommand(this);
        this.$deleteStationCommand = new DeleteStationCommand(this);
        this.$addPrototypeCommand = new AddPrototypeCommand(this);
        this.$editPrototypeCommand = new EditPrototypeCommand(this);
        this.$deletePrototypeCommand = new DeletePrototypeCommand(this);
        this.$addPrototypeCommand.setEnabled(true);
        dom.on(MODIFY_EVENT, '.bajaux-initialized', function () {
          _this2.setModified(true);
          return false;
        });
        dom.on('dblclick', '.mainTable tr', function () {
          switch (_this2.$currentTabValue) {
            case circleOfTrustUtils.STATION_INDEX:
              if (_this2.$editStationCommand.isEnabled()) {
                if (_this2.getMainTable().getSelectedRows()[0].getSubject().get('selected') === true) {
                  _this2.$editStationCommand.invoke();
                } else {
                  var stationName = _this2.getMainTable().getSelectedRows()[0].getSubject().get('name');
                  dialogs.showOk({
                    title: samlLex.get('CircleOfTrust.commands.dialog.edit.untrusted.title', stationName),
                    content: samlLex.getSafe('CircleOfTrust.commands.dialog.edit.untrusted.content', stationName)
                  });
                }
              }
              break;
            case circleOfTrustUtils.USER_INDEX:
              break;
            case circleOfTrustUtils.AUTH_SCHEME_INDEX:
              break;
            case circleOfTrustUtils.PROTOTYPES_INDEX:
              if (_this2.$editPrototypeCommand.isEnabled()) {
                _this2.$editPrototypeCommand.invoke();
              }
              break;
          }
        });
        return _superPropGet(CircleOfTrustManager, "doInitialize", this, 3)([dom]);
      }

      /**
       * Calls super.doLoad to initialize and load the main table with the `MgrModel`, then initializes
       * details specific to the circle of trust manager.
       *
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad() {
        var _this3 = this;
        return _superPropGet(CircleOfTrustManager, "doLoad", this, 3)([]).then(function () {
          return _this3.$createAndInitializeSelectAll(_this3.getMainTable().jq().find('thead th:first-child'));
        }).then(function () {
          _this3.$registerSelectAllOnModifyEventHandler();
          _this3.$registerSelectOnModifyEventHandler();
          _this3.$registerTheadUpdatedEventHandler();
          _this3.$registerTbodyUpdatedEventHandler();
        });
      }
    }, {
      key: "afterLoad",
      value: function afterLoad() {
        var _this4 = this;
        var selection = mgrUtils.getMainTableSelection(this);
        selection.on('changed', function () {
          var selectedRows = _this4.getMainTable().getSelectedRows();
          switch (_this4.$currentTabValue) {
            case circleOfTrustUtils.STATION_INDEX:
              var serviceProviders = _this4.value().getServiceProviders();
              _this4.$editStationCommand.setEnabled(selectedRows && selectedRows.length === 1 && serviceProviders.get(selectedRows[0].getSubject().get('name')) !== null && serviceProviders.get(selectedRows[0].getSubject().get('name')) !== undefined);
              _this4.$deleteStationCommand.setEnabled(selectedRows && selectedRows.length === 1 && selectedRows[0].getSubject().get('fromNiagaraNetwork') === false);
              break;
            case circleOfTrustUtils.USER_INDEX:
              break;
            case circleOfTrustUtils.AUTH_SCHEME_INDEX:
              break;
            case circleOfTrustUtils.PROTOTYPES_INDEX:
              _this4.$editPrototypeCommand.setEnabled(selectedRows && selectedRows.length === 1);
              _this4.$deletePrototypeCommand.setEnabled(selectedRows && selectedRows.length === 1);
              break;
          }
        });
      }

      /**
       * Destroy the main view table / unsubscribe
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('CircleOfTrustManager');
        return Promise.all([this.$subscriber.unsubscribeAll(), this.getChildWidgets().destroyAll()]);
      }
    }, {
      key: "doSave",
      value:
      /**
       * Saves `CircleOfTrustManager` value(s).
       *
       * @param {*} validValue The value to be used for saving. This value will have
       * been read from the widget using `read()` and validated using `validate()`.
       * @param {Object} params
       * @param {number} params.currentTabValue the value of the selected tab
       * @returns {Promise} An optional promise that's resolved once
       * the widget has saved.
       */
      function doSave(validValue, params) {
        switch (params.currentTabValue) {
          case circleOfTrustUtils.STATION_INDEX:
            return this.$saveStations();
          case circleOfTrustUtils.USER_INDEX:
            return this.$saveUsers();
          case circleOfTrustUtils.AUTH_SCHEME_INDEX:
            return this.$saveAuthSchemes();
          case circleOfTrustUtils.PROTOTYPES_INDEX:
            return this.$savePrototypes();
        }
      }

      /**
       * Creates model for Circle of Trust Stations.
       *
       * @param {baja.Component} component
       * @returns {Promise} model
       */
    }, {
      key: "makeModel",
      value: function makeModel(component) {
        var _this5 = this;
        var container = [];
        return component.getServiceProviders().loadSlots().then(function () {
          return Promise.all([_this5.$addStationsToContainer(container, component), _this5.$addUsersToContainer(container, component), _this5.$addAuthenticationSchemesToContainer(container, component), _this5.$addPrototypesToContainer(container, component)]);
        }).then(function () {
          return MgrTypeInfo.make(['saml:StationServiceProvider']);
        }).then(function (newTypes) {
          return new MgrModel({
            componentSource: new ArrayComponentSource({
              container: container
            }),
            newTypes: newTypes,
            columns: _this5.makeColumns()
          });
        });
      }

      /**
       * Specifies columns to display for Circle of Trust Stations.
       *
       * @returns {Array} columns
       */
    }, {
      key: "makeColumns",
      value: function makeColumns() {
        var displayNameColumn = new PropertyMgrColumn('displayName', {
          displayName: samlLex.get('CircleOfTrustManager.table.column.displayName'),
          flags: READONLY
        });
        displayNameColumn.setHidable(false);
        var trustedColumn = new SelectedMgrColumn('selected', {
          displayName: samlLex.get('CircleOfTrustManager.table.column.selected'),
          flags: EDITABLE
        });
        trustedColumn.setSortable(false);
        trustedColumn.setHidable(false);
        return [trustedColumn, displayNameColumn];
      }

      /**
       * Sets manager state based current tab value
       *
       * @param {number} tabValue
       * @returns {Promise}
       */
    }, {
      key: "currentTabValueChanged",
      value: function currentTabValueChanged(tabValue) {
        this.$currentTabValue = tabValue;
        var commandGroup = this.getCommandGroup();
        commandGroup.removeAll();
        switch (tabValue) {
          case circleOfTrustUtils.STATION_INDEX:
            commandGroup.add(this.$addStationCommand);
            commandGroup.add(this.$editStationCommand);
            commandGroup.add(this.$deleteStationCommand);
            break;
          case circleOfTrustUtils.USER_INDEX:
            break;
          case circleOfTrustUtils.AUTH_SCHEME_INDEX:
            break;
          case circleOfTrustUtils.PROTOTYPES_INDEX:
            commandGroup.add(this.$addPrototypeCommand);
            commandGroup.add(this.$editPrototypeCommand);
            commandGroup.add(this.$deletePrototypeCommand);
            break;
        }
        return this.$getCommandButtonGroup().load(commandGroup);
      }

      /**
       * Resets unsaved manager value(s) based of currect tab.
       *
       * @param {number} currentTabValue
       * @returns {Promise}
       */
    }, {
      key: "reset",
      value: function reset(currentTabValue) {
        switch (currentTabValue) {
          case circleOfTrustUtils.STATION_INDEX:
            var trustedStations = _.map(this.value().getServiceProviders().getSlots().is("saml:StationServiceProvider").toArray(), function (serviceProvider) {
              return serviceProvider.getName();
            });
            this.getModel().getRows().forEach(function (row) {
              var subject = row.getSubject();
              var stationName = subject.get('name');
              var indexInTrustedStations = trustedStations.indexOf(stationName);
              subject.set({
                slot: subject.getSlot('selected'),
                value: indexInTrustedStations >= 0
              });
            });
            break;
          case circleOfTrustUtils.USER_INDEX:
            var trustedUsers = !this.value().getUsers() ? [] : this.value().getUsers().replace(/([\s])|(^[,\s]+)|([,\s]+$)/g, '').split(',');
            this.getModel().getRows().forEach(function (row) {
              var subject = row.getSubject();
              var userName = subject.get('name');
              var indexInTrustedUsers = trustedUsers.indexOf(userName);
              subject.set({
                slot: subject.getSlot('selected'),
                value: indexInTrustedUsers >= 0
              });
            });
            break;
          case circleOfTrustUtils.AUTH_SCHEME_INDEX:
            var trustedAuthSchemes = !this.value().getAuthenticationSchemes() ? [] : this.value().getAuthenticationSchemes().replace(/([\s])|(^[,\s]+)|([,\s]+$)/g, '').split(',');
            this.getModel().getRows().forEach(function (row) {
              var subject = row.getSubject();
              var authSchemeName = subject.get('name');
              var indexInTrustedAuthSchemes = trustedAuthSchemes.indexOf(authSchemeName);
              subject.set({
                slot: subject.getSlot('selected'),
                value: indexInTrustedAuthSchemes >= 0
              });
            });
            break;
        }
        return this.$updateSelectAllStatus(this.getMainTable().jq().find('tbody'));
      }

      /**
       * Sort manager table model and save current sort function.
       *
       * @param {function} sortFunction
       */
    }, {
      key: "sort",
      value: function sort(sortFunction) {
        this.$sortFunction = sortFunction;
        this.getModel().sort(this.$sortFunction);
      }

      /**
       * Sort manager table model with the current sort function.
       */
    }, {
      key: "reSort",
      value: function reSort() {
        this.getModel().sort(this.$sortFunction);
      }

      /**
       * Refresh manager table.
       *
       * @returns {Promise}
       */
    }, {
      key: "refresh",
      value: function refresh() {
        return this.$updateSelectAllStatus(this.getMainTable().jq().find('tbody'));
      }

      /**
       * Saves trusted station value(s) to Circle of Trust.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$saveStations",
      value: function $saveStations() {
        var _this6 = this;
        var serviceProviders = this.value().getServiceProviders();
        var trustedStations = _.map(serviceProviders.getSlots().is("saml:StationServiceProvider").toArray(), function (serviceProvider) {
          return serviceProvider.getName();
        });
        var rows = this.getModel().getRows();
        return Promise.all(rows.map(function (row) {
          var station = row.getSubject().get('name'),
            stationIsTrusted = row.getSubject().get('selected') === true,
            indexInTrustedStations = trustedStations.indexOf(station);
          if (stationIsTrusted) {
            if (indexInTrustedStations < 0) {
              return _this6.$getSAMLIdPService()
              // TODO NCCB-43510 - Auto-fill BStationServiceProvider info given a hostname (actually station name?)
              .then(function (samlIdPService) {
                return samlIdPService.buildStationServiceProvider(row.getSubject().get('name'));
              }).then(function (stationServiceProvider) {
                return serviceProviders.add({
                  slot: row.getSubject().get('name'),
                  value: stationServiceProvider
                });
              });
            }
          } else {
            if (indexInTrustedStations >= 0) {
              return serviceProviders.remove(station).then(function () {
                if (!row.getSubject().get('fromNiagaraNetwork')) {
                  return _this6.getModel().removeRows([row]);
                }
              });
            }
          }
        }).filter(function (promise) {
          return promise !== undefined;
        }));
      }

      /**
       * Saves trusted user value(s) to Circle of Trust.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$saveUsers",
      value: function $saveUsers() {
        var trustedUsers = !this.value().getUsers() ? [] : this.value().getUsers().replace(/([\s])|(^[,\s]+)|([,\s]+$)/g, '').split(',');
        this.getModel().getRows().forEach(function (row) {
          var userHandle = row.getSubject().get('name'),
            userIsTrusted = row.getSubject().get('selected') === true,
            indexInTrustedUsers = trustedUsers.indexOf(userHandle);
          if (userIsTrusted) {
            if (indexInTrustedUsers < 0) {
              trustedUsers.push(userHandle);
            }
          } else {
            if (indexInTrustedUsers >= 0) {
              trustedUsers.splice(indexInTrustedUsers, 1);
            }
          }
        });
        return this.value().setUsers(trustedUsers.join(','));
      }

      /**
       * Saves trusted authentication scheme value(s) to Circle of Trust.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$saveAuthSchemes",
      value: function $saveAuthSchemes() {
        // Remove white space and leading/trailing commas
        var trustedAuthSchemes = !this.value().getAuthenticationSchemes() ? [] : this.value().getAuthenticationSchemes().replace(/([\s])|(^[,\s]+)|([,\s]+$)/g, '').split(',');
        this.getModel().getRows().forEach(function (row) {
          var authScheme = row.getSubject().get('name');
          var authSchemeIsTrusted = row.getSubject().get('selected') === true;
          var indexInTrustedAuthSchemes = trustedAuthSchemes.indexOf(authScheme);
          if (authSchemeIsTrusted) {
            if (indexInTrustedAuthSchemes < 0) {
              trustedAuthSchemes.push(authScheme);
            }
          } else {
            if (indexInTrustedAuthSchemes >= 0) {
              trustedAuthSchemes.splice(indexInTrustedAuthSchemes, 1);
            }
          }
        });
        return this.value().setAuthenticationSchemes(trustedAuthSchemes.join(','));
      }

      /**
       * Saves trusted prototype value(s) to Circle of Trust.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$savePrototypes",
      value: function $savePrototypes() {
        // Remove white space and leading/trailing commas
        var currentPrototypes = !this.value().getPrototypes() ? [] : this.value().getPrototypes().replace(/([\s])|(^[,\s]+)|([,\s]+$)/g, '').split(',');
        this.getModel().getRows().filter(circleOfTrustUtils.getPrototypesRowFilter()).forEach(function (row) {
          var prototypeName = row.getSubject().get('name');
          if (currentPrototypes.indexOf(prototypeName) === -1) {
            currentPrototypes.push(prototypeName);
          }
        });
        return this.value().setPrototypes(currentPrototypes.join(','));
      }

      /**
       * Adds stations to container for Circle of Trust manager model.
       *
       * @private
       *
       * @param {Array} container
       * @param {baja.Component} circleOfTrust a `saml:CircleOfTrust` instance
       * @returns {Promise}
       */
    }, {
      key: "$addStationsToContainer",
      value: function $addStationsToContainer(container, circleOfTrust) {
        var _this7 = this;
        var nonNetworkServiceProviders = [],
          serviceProviders = circleOfTrust.getServiceProviders();
        return Promise.all(_.map(serviceProviders.getSlots().is("saml:StationServiceProvider").toArray(), function (slot) {
          var serviceProvider = serviceProviders.get(slot.getName());
          return serviceProvider.loadSlots().then(function () {
            if (!serviceProvider.getFromNiagaraNetwork()) {
              nonNetworkServiceProviders.push(slot);
            }
            return slot.getName();
          });
        })).then(function (trustedStations) {
          return _this7.$getSAMLIdPService().then(function (samlIdPService) {
            return samlIdPService.getStations();
          }).then(function (stationJson) {
            JSON.parse(stationJson).forEach(function (stationFromNetwork) {
              var trusted = trustedStations.indexOf(stationFromNetwork.name) >= 0;
              var station = baja.$('baja:Component', {
                name: stationFromNetwork.name,
                displayName: stationFromNetwork.displayName,
                selected: trusted,
                fromNiagaraNetwork: true,
                category: 'station'
              });
              container.push(station);
            });
            nonNetworkServiceProviders.forEach(function (slot) {
              var station = baja.$('baja:Component', {
                name: slot.getName(),
                displayName: serviceProviders.getDisplayName(slot.getName()),
                selected: true,
                fromNiagaraNetwork: false,
                category: 'station'
              });
              container.push(station);
            });
          })["catch"](logSevere);
        });
      }

      /**
       * Adds users to container for Circle of Trust manager model.
       *
       * @private
       *
       * @param {Array} container
       * @param {baja.Component} circleOfTrust a `saml:CircleOfTrust` instance
       * @returns {Promise}
       */
    }, {
      key: "$addUsersToContainer",
      value: function $addUsersToContainer(container, circleOfTrust) {
        var trustedUsers = circleOfTrust.getUsers().split(',');
        return this.$getSAMLIdPService().then(function (samlIdPService) {
          return samlIdPService.getUsers();
        }).then(function (userJson) {
          JSON.parse(userJson).forEach(function (userFromService) {
            var trusted = trustedUsers.indexOf(userFromService.handleOrd) >= 0;
            var user = baja.$('baja:Component', {
              name: userFromService.handleOrd,
              displayName: userFromService.displayName,
              selected: trusted,
              category: 'user'
            });
            container.push(user);
          });
        })["catch"](logSevere);
      }

      /**
       * Adds authentication schemes to container for Circle of Trust manager model.
       *
       * @private
       *
       * @param {Array} container
       * @param {baja.Component} circleOfTrust a `saml:CircleOfTrust` instance
       * @returns {Promise}
       */
    }, {
      key: "$addAuthenticationSchemesToContainer",
      value: function $addAuthenticationSchemesToContainer(container, circleOfTrust) {
        var trustedAuthenticationScheme = circleOfTrust.getAuthenticationSchemes().split(',');
        return this.$getSAMLIdPService().then(function (samlIdPService) {
          return samlIdPService.getAuthSchemes();
        }).then(function (authSchemeJson) {
          JSON.parse(authSchemeJson).forEach(function (authSchemeFromService) {
            var trusted = trustedAuthenticationScheme.indexOf(authSchemeFromService.handleOrd) >= 0;
            var authenticationScheme = baja.$('baja:Component', {
              name: authSchemeFromService.handleOrd,
              displayName: authSchemeFromService.displayName,
              selected: trusted,
              category: 'authScheme'
            });
            container.push(authenticationScheme);
          });
        })["catch"](logSevere);
      }

      /**
       * Adds Circle Of Trust's prototypes to the container for Circle of Trust manager model.
       *
       * @private
       *
       * @param {Array} container
       * @param {baja.Component} circleOfTrust a `saml:CircleOfTrust` instance
       * @returns {Promise}
       */
    }, {
      key: "$addPrototypesToContainer",
      value: function $addPrototypesToContainer(container, circleOfTrust) {
        var prototypes = circleOfTrust.getPrototypes();
        if (prototypes.length !== 0) {
          return prototypes.loadSlots().then(function () {
            var currentPrototypes = prototypes.getSlots().toArray();
            _(currentPrototypes).each(function (prototype) {
              var prototypeItem = baja.$('baja:Component', {
                name: prototype.getName(),
                displayName: prototypes.getDisplayName(prototype.getName()),
                selected: true,
                category: 'prototypes'
              });
              container.push(prototypeItem);
            });
          });
        } else {
          return Promise.resolve();
        }
      }

      /**
       * Returns SAMLIdPService.
       *
       * @private
       *
       * @returns {Promise}
       */
    }, {
      key: "$getSAMLIdPService",
      value: function $getSAMLIdPService() {
        var _this8 = this;
        if (!this.$samlIdPService) {
          return this.getOrdBase().then(this.$leaseIdpServiceWhenNeeded).then(function (samlIdpService) {
            _this8.$samlIdPService = samlIdpService;
            return samlIdpService;
          });
        }
        return Promise.resolve(this.$samlIdPService);
      }

      /**
       * Return the 'AddStationCommand' instance from the command group. This is used
       * to add a new station to the Circle of Trust.
       *
       * @private
       * @returns {module:nmodule/saml/rc/util/AddStationCommand}
       */
    }, {
      key: "$getAddStationCommand",
      value: function $getAddStationCommand() {
        return this.$addStationCommand;
      }

      /**
       * Return the 'EditStationCommand' instance from the command group. This is used
       * to add a new station to the Circle of Trust.
       *
       * @private
       * @returns {module:nmodule/saml/rc/util/EditStationCommand}
       */
    }, {
      key: "$getEditStationCommand",
      value: function $getEditStationCommand() {
        return this.$editStationCommand;
      }

      /**
       * Return the 'DeleteStationCommand' instance from the command group. This is used
       * to delete a station from the Circle of Trust.
       *
       * @private
       * @returns {module:nmodule/saml/rc/util/DeleteStationCommand}
       */
    }, {
      key: "$getDeleteStationCommand",
      value: function $getDeleteStationCommand() {
        return this.$deleteStationCommand;
      }

      /**
       * Return the 'AddPrototypeCommand' instance from the command group. This is used
       * to add a new prototype to the Circle of Trust.
       *
       * @private
       * @returns {module:nmodule/saml/rc/util/AddPrototypeCommand}
       */
    }, {
      key: "$getAddPrototypeCommand",
      value: function $getAddPrototypeCommand() {
        return this.$addPrototypeCommand;
      }

      /**
       * Return the 'EditPrototypeCommand' instance from the command group. This is used
       * to edit a selected prototype in the Circle of Trust.
       *
       * @private
       * @returns {module:nmodule/saml/rc/util/EditPrototypeCommand}
       */
    }, {
      key: "$getEditPrototypeCommand",
      value: function $getEditPrototypeCommand() {
        return this.$editPrototypeCommand;
      }

      /**
       * Return the 'DeletePrototypeCommand' instance from the command group. This is used
       * to delete a selected prototype from the Circle of Trust.
       *
       * @private
       * @returns {module:nmodule/saml/rc/util/DeletePrototypeCommand}
       */
    }, {
      key: "$getDeletePrototypeCommand",
      value: function $getDeletePrototypeCommand() {
        return this.$deletePrototypeCommand;
      }

      /**
       * Handles `Select All' events for trusted entities in the manager view.
       *
       * @private
       */
    }, {
      key: "$handleSelectAll",
      value: function $handleSelectAll() {
        var _this9 = this;
        this.$circleOfTrustSelectAll.read().then(function (value) {
          var numberOfChangedSelections = _this9.$changeAllSelections(value);
          if (numberOfChangedSelections > 0) {
            _this9.setModified(true);
          }
        })["catch"](logSevere);
      }

      /**
       * Selects/UnSelects all manager value(s) based of current tab.
       *
       * @private
       * @param {boolean} value
       * @returns {number}
       */
    }, {
      key: "$changeAllSelections",
      value: function $changeAllSelections(value) {
        var numberOfChangedSelections = 0;
        this.getModel().getRows().forEach(function (row) {
          var subject = row.getSubject();
          var selected = subject.get('selected');
          if (selected === !value) {
            subject.set({
              slot: subject.getSlot('selected'),
              value: value
            });
            numberOfChangedSelections++;
          }
        });
        this.getMainTable().jq().find('tr td:first-child input').prop("checked", value);
        return numberOfChangedSelections;
      }

      /**
       * Registers Select MODIFY_EVENT handler.
       *
       * @private
       */
    }, {
      key: "$registerSelectOnModifyEventHandler",
      value: function $registerSelectOnModifyEventHandler() {
        var _this10 = this;
        this.jq().on(MODIFY_EVENT, 'tr td:first-child', function () {
          _this10.$updateSelectAllStatus(_this10.getMainTable().jq().find('tbody'))["catch"](logSevere);
          return false;
        });
      }

      /**
       * Registers SelectAll MODIFY_EVENT handler.
       *
       * @private
       */
    }, {
      key: "$registerSelectAllOnModifyEventHandler",
      value: function $registerSelectAllOnModifyEventHandler() {
        var _this11 = this;
        this.$circleOfTrustSelectAll.jq().on(MODIFY_EVENT, null, function () {
          _this11.setModified(true);
          _this11.$handleSelectAll();
          return false;
        });
      }

      /**
       * Registers thead updated handler.
       *
       * @private
       */
    }, {
      key: "$registerTheadUpdatedEventHandler",
      value: function $registerTheadUpdatedEventHandler() {
        var _this12 = this;
        this.getMainTable().on('theadUpdated', function (thead) {
          _this12.$circleOfTrustSelectAll.destroy().then(function () {
            return _this12.$createAndInitializeSelectAll(thead.find('th:first-child'));
          }).then(function () {
            return _this12.$updateSelectAllStatus(_this12.getMainTable().jq().find('tbody'));
          }).then(function () {
            return _this12.$registerSelectAllOnModifyEventHandler();
          })["catch"](logSevere);
        });
      }

      /**
       * Registers thead updated handler.
       *
       * @private
       */
    }, {
      key: "$registerTbodyUpdatedEventHandler",
      value: function $registerTbodyUpdatedEventHandler() {
        var _this13 = this;
        this.getMainTable().on('tbodyUpdated', function (tbody) {
          _this13.$updateSelectAllStatus(tbody)["catch"](logSevere);
        });
      }

      /**
       * Create and initialize SelectAll.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$createAndInitializeSelectAll",
      value: function $createAndInitializeSelectAll(th) {
        this.$circleOfTrustSelectAll = new BooleanCheckboxEditor({
          properties: {
            trueText: ' ',
            falseText: ' '
          }
        });
        return this.$circleOfTrustSelectAll.initialize(th);
      }

      /**
       * Updates Selects All status do to manager state changes.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$updateSelectAllStatus",
      value: function $updateSelectAllStatus(tbody) {
        var _this14 = this;
        var SELECT_ALL_UNCHECKED = 0;
        var SELECT_ALL_CHECKED = 1;
        var SELECT_ALL_INDETERMINATE = 2;
        var rowCount = tbody.find('tr').length;
        var selectedRowCount = tbody.find('tr td:first-child input:checked').length;
        var status = SELECT_ALL_INDETERMINATE;
        if (selectedRowCount === 0) {
          status = SELECT_ALL_UNCHECKED;
        }
        if (selectedRowCount === rowCount) {
          status = SELECT_ALL_CHECKED;
        }
        switch (status) {
          case SELECT_ALL_UNCHECKED:
            return this.$circleOfTrustSelectAll.load(false).then(function () {
              return _this14.$circleOfTrustSelectAll.jq().find('input').prop("indeterminate", false);
            });
          case SELECT_ALL_CHECKED:
            return this.$circleOfTrustSelectAll.load(true).then(function () {
              return _this14.$circleOfTrustSelectAll.jq().find('input').prop("indeterminate", false);
            });
          case SELECT_ALL_INDETERMINATE:
            return this.$circleOfTrustSelectAll.load(true).then(function () {
              return _this14.$circleOfTrustSelectAll.jq().find('input').prop("indeterminate", true);
            });
        }
      }
    }]);
  }(Manager);
});
