/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/hierarchy/rc/fe/RoleHierarchiesEditor
 */
define(['baja!',
        'nmodule/webEditors/rc/fe/baja/BaseEditor',
        'bajaux/mixin/subscriberMixIn',
        'bajaux/Widget',
        'bajaux/events',
        'jquery',
        'underscore',
        'Promise',
        'nmodule/webEditors/rc/fe/fe',
        'lex!hierarchy'], function (
         baja,
         BaseEditor,
         subscriberMixIn,
         Widget,
         events,
         $,
         _,
         Promise,
         fe,
         lexs) {

  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;

  /**
   * A field editor for working with hierarchy:RoleHierarchies
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/hierarchy/rc/fe/RoleHierarchiesEditor
   */
  var RoleHierarchiesEditor = function RoleHierarchiesEditor(params) {
    var that = this;

    BaseEditor.call(that, $.extend(true, {
      keyName: 'RoleHierarchiesEditor'
    }, params));

    subscriberMixIn(that);
  };

  RoleHierarchiesEditor.prototype = Object.create(BaseEditor.prototype);
  RoleHierarchiesEditor.prototype.constructor = RoleHierarchiesEditor;

  /**
   * Creates a Permissions element.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  RoleHierarchiesEditor.prototype.doInitialize = function (dom) {
    var that = this;

    //if a row is modified, set myself modified
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });

    that.getSubscriber().attach('changed', _.bind(that.$update, that));

    return fe.buildFor({
      dom:  $('<span class="hierarchyNames"/>').appendTo(dom),
      value: '', // default value, the actual value will be loaded in doLoad.
      formFactor: 'mini',
      readonly: true
    });
  };

  /**
   * Loads the given hierarchy:RoleHierarchies component into the editor.
   *
   * @param {Component} roleHierarchies (hierarchy:RoleHierarchies)
   * @returns {Promise}
   */
  RoleHierarchiesEditor.prototype.doLoad = function (roleHierarchies) {
    return this.$update();
  };

  /**
   * update the editor
   *
   * @private
   * @returns {Promise}
   */
  RoleHierarchiesEditor.prototype.$update = function () {
    var that = this;
    return that.$getHierarchyNamesEditor().load(
      that.value().getHierarchyNamesDisplay()
    );
  };

  RoleHierarchiesEditor.prototype.$isOnAdminRole = function () {
    return baja.hasType(this.value().getParent(), 'baja:AdminRole');
  };

  /**
   * Return the Hierarchy Names editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/StringEditor}
   */
  RoleHierarchiesEditor.prototype.$getHierarchyNamesEditor = function () {
    var that = this;
    return Widget.in(that.jq().find('.hierarchyNames'));
  };

  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */
  RoleHierarchiesEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };

  return RoleHierarchiesEditor;
});
