/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/hierarchy/rc/bs/levelElemMenuAgent
 */
define(['bajaux/commands/Command',
        'bajaux/commands/CommandGroup',
        'Promise',
        'nmodule/webEditors/rc/wb/menu/menuUtils'], function (
         Command,
         CommandGroup,
         Promise,
         menuUtils) {

  'use strict';
  
  var ifAllowedByProfile = menuUtils.ifAllowedByProfile,
      makeViewsGroup = menuUtils.makeViewsGroup,
      makeActionsGroup = menuUtils.makeActionsGroup;
  
  /**
   * Asynchronously require the appropriate command modules and instantiate
   * the `CommandGroup`. Assign the appropriate enabled/disabled status for
   * the different commands depending on the write/invoke permissions on this
   * component.
   *
   * @inner
   * @param {module:bajaux/Widget} widget
   * @param {baja.Component} comp
   * @returns {Promise}
   */
  function makeGroup(widget, comp, rootComp) {
    var group = new CommandGroup();

    return Promise.join(
       ifAllowedByProfile('viewSelection', function () {
         return makeViewsGroup(comp.getNavOrd());
       }),
      makeActionsGroup(rootComp)
    )
      .spread(function (viewsGroup, actionGroup) {
        if(viewsGroup){
          group.add(viewsGroup);
        }
        group.add(actionGroup);

        return group;
      });
    // return makeActionsGroup(rootComp);
  }

  /**
   * Create a command group that can be used to construct a context menu. Note
   * that the component, if mounted, will be leased at this time so any
   * dynamic actions can be included in the menu.
   *
   * @alias module:nmodule/hierarchy/rc/bs/levelElemMenuAgent
   * @param {module:bajaux/Widget} widget
   * @param {baja.Component} comp
   * @returns {Promise} promise to be resolved with a `CommandGroup`
   * for the given component
   */
  var levelElemMenuAgent = function componentMenuAgent(widget, comp) {
    return comp.getNavOrd().resolve({ lease: true }).then(function (target) {
      return makeGroup(widget, comp, target.getComponent());
    });
  };

  return levelElemMenuAgent;
});
