function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/model/Item
 */
define(['nmodule/nss/rc/model/Entity', 'nmodule/nss/rc/model/Severity', 'lex!nss'], function (Entity, Severity, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    nssLex = _lexs[0];

  /**
   * Class representing an Item , e.g. "you have a log level set to FINE"
   *
   * @class
   * @alias module:nmodule/nss/rc/model/Item
   * @param {object} params
   * @param {module:nmodule/nss/rc/model/Entity} params.sourceEntity source entity of an item
   * @param {string} params.summary item summary
   * @param {string} params.description item description
   * @param {module:nmodule/nss/rc/model/Severity} params.severity item severity level
   * @throws {Error} if sourceEntity , summary or severity is missing
   */
  return /*#__PURE__*/function () {
    function Item() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        sourceEntity = _ref.sourceEntity,
        summary = _ref.summary,
        description = _ref.description,
        severity = _ref.severity;
      _classCallCheck(this, Item);
      if (!(sourceEntity instanceof Entity)) {
        throw new Error(nssLex.get('SecurityDashboardView.item.sourceEntity.error'));
      }
      if (typeof summary !== 'string') {
        throw new Error(nssLex.get('SecurityDashboardView.item.summary.error'));
      }
      if (!(severity instanceof Severity)) {
        throw new Error(nssLex.get('SecurityDashboardView.item.severity.error'));
      }
      this.$sourceEntity = sourceEntity;
      this.$summary = summary;
      this.$description = description || '';
      this.$severity = severity;
    }

    /**
     * @returns {module:nmodule/nss/rc/model/Entity} source Entity of the item
     */
    return _createClass(Item, [{
      key: "getSourceEntity",
      value: function getSourceEntity() {
        return this.$sourceEntity;
      }

      /**
       * @returns {string} summary of the item
       */
    }, {
      key: "getSummary",
      value: function getSummary() {
        return this.$summary;
      }

      /**
       * @returns {string} description of the item
       */
    }, {
      key: "getDescription",
      value: function getDescription() {
        return this.$description;
      }

      /**
       * @returns {module:nmodule/nss/rc/model/Severity} severity of the item
       */
    }, {
      key: "getSeverity",
      value: function getSeverity() {
        return this.$severity;
      }
    }]);
  }();
});
