function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/model/Entity
 */
define(['lex!nss'], function (lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    nssLex = _lexs[0];

  /**
   * Class representing an Entity, e.g. "User Service" or
   * "Fox Service".
   *
   * @class
   * @alias module:nmodule/nss/rc/model/Entity
   * @param {object} params
   * @param {string} params.displayName entity display name
   * @param {string} params.ord entity ord
   * @param {string[]} [params.icon=[]] array of strings that define an icon
   * for this entity
   * @throws {Error} if displayName or ord is missing
   */
  return /*#__PURE__*/function () {
    function Entity() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        name = _ref.name,
        _ref$displayName = _ref.displayName,
        displayName = _ref$displayName === void 0 ? name : _ref$displayName,
        ord = _ref.ord,
        icon = _ref.icon;
      _classCallCheck(this, Entity);
      if (typeof name !== 'string') {
        throw new Error(nssLex.get('SecurityDashboardView.entity.displayName.error'));
      }
      if (!(typeof ord === 'string' || ord)) {
        throw new Error(nssLex.get('SecurityDashboardView.entity.ord.error'));
      }
      this.$displayName = displayName;
      this.$name = name;
      this.$ord = String(ord);
      this.$icon = icon || [];
    }

    /**
     * @returns {string} entity display name
     */
    return _createClass(Entity, [{
      key: "getDisplayName",
      value: function getDisplayName() {
        return this.$displayName;
      }

      /**
       * @returns {string} entity name
       */
    }, {
      key: "getName",
      value: function getName() {
        return this.$name;
      }

      /**
       * @returns {string} entity ord
       */
    }, {
      key: "getOrd",
      value: function getOrd() {
        return this.$ord;
      }

      /**
       * @returns {string[]} entity icon
       */
    }, {
      key: "getIcon",
      value: function getIcon() {
        return this.$icon;
      }

      /**
       * Checks for equality between this Entity and another.
       * 
       * @param {module:nmodule/nss/rc/model/Entity} srcEntity 
       * @returns {boolean} true if the other object is equal to this one.
       */
    }, {
      key: "equals",
      value: function equals(srcEntity) {
        return srcEntity.getName() === this.getName();
      }
    }]);
  }();
});
