function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/SourceOverviewWidget
 * */
define(['baja!', 'jquery', 'Promise', 'bajaux/events', 'log!nmodule.nss.rc.fe.SourceOverviewWidget', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/nss/rc/fe/CountsBySeverityWidget', 'nmodule/webChart/rc/donut/DonutChartWidget', 'nmodule/nss/rc/model/SourceCollection', 'nmodule/nss/rc/model/ItemCollection', 'nmodule/nss/rc/model/Entity', 'nmodule/nss/rc/util/securityDashboardUtil', 'lex!nss', 'css!nmodule/nss/rc/nss'], function (baja, $, Promise, events, log, Widget, BaseWidget, IconEditor, CountsBySeverityWidget, DonutChartWidget, SourceCollection, ItemCollection, Entity, securityDashboardUtil, lexicon) {
  'use strict';

  var _lexicon = _slicedToArray(lexicon, 1),
    nssLex = _lexicon[0];
  var sourceOverviewWidgetHtml = function sourceOverviewWidgetHtml() {
    return "\n  <div class=\"sourceOverview-entity\">\n    <span class=\"icon\"></span>\n    <span class=\"displayName\"></span> \n  </div>\n  <div class=\"sourceOverview-bottom\">\n    <span class=\"donutChart\"></span>\n    <span class=\"CountsBySeverityWidget\"></span>\n  </div>\n ";
  };

  /**
   * Shows information about SourceCollection on a Donut Chart, CountsBySeverityWidget and Entity element.
   *
   * @class
   * @alias module:nmodule/nss/rc/fe/SourceOverviewWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */
  return /*#__PURE__*/function (_BaseWidget) {
    function SourceOverviewWidget() {
      _classCallCheck(this, SourceOverviewWidget);
      return _callSuper(this, SourceOverviewWidget, arguments);
    }
    _inherits(SourceOverviewWidget, _BaseWidget);
    return _createClass(SourceOverviewWidget, [{
      key: "doInitialize",
      value:
      /**
       * Adds `SourceOverviewWidget` class to the dom.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
      function doInitialize(dom) {
        var _this = this;
        dom.html(sourceOverviewWidgetHtml()).addClass('SourceOverviewWidget');
        var countBySevWidget = new CountsBySeverityWidget({
          properties: {
            horizontal: true
          }
        });
        this.$getDashboardService().onItemCollectionUpdated(function (itemCollection) {
          _this.value().updateItemCollection(itemCollection);
          return _this.$refresh();
        });
        return Promise.all([securityDashboardUtil.getSeverityColors().then(function (color) {
          return new DonutChartWidget({
            properties: {
              label: nssLex.get('SecurityDashboardView.donutChartWidget.label.text'),
              color: color,
              countYOffset: 0
            }
          }).initialize(_this.$getDonutChartElement());
        }), countBySevWidget.initialize(this.$getCountsBySeverityElement()), new IconEditor().initialize(this.$getIconElement())]);
      }

      /**
       * Creates the SourceOverviewWidget for the input SourceCollection
       * @param {module:nmodule/nss/rc/model/SourceCollection} sourceCollection
       * @returns {Promise} Rendered SourceOverviewWidget wrapped as a Promise
       * @throws {Error} if the input is not a SourceCollection type.
       */
    }, {
      key: "doLoad",
      value: function doLoad(sourceCollection) {
        if (!(sourceCollection instanceof SourceCollection)) {
          throw new Error(nssLex.get('SecurityDashboardView.sourceCollection.type.required.error'));
        }
        return this.$refresh();
      }
    }, {
      key: "$refresh",
      value: function $refresh() {
        var _this2 = this;
        var sourceCollection = this.value();
        return Promise.all([this.$getDonutChartWidget().load(securityDashboardUtil.getTypeAndCountForSeverity(sourceCollection.getCountsBySeverity())), this.$getCountsBySeverityWidget().load(sourceCollection.getCountsBySeverity()), this.$getIconWidget().load(sourceCollection.getSourceEntity().getIcon())]).then(function () {
          _this2.jq().find('.sourceOverview-entity .displayName').text(sourceCollection.getSourceEntity().getDisplayName());
        });
      }

      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('SourceOverviewWidget');
        return this.getChildWidgets().destroyAll();
      }
    }, {
      key: "$getIconElement",
      value:
      /**
       * @private
       * @returns {JQuery}
       */
      function $getIconElement() {
        return this.jq().find('.sourceOverview-entity .icon');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getIconWidget",
      value: function $getIconWidget() {
        return Widget["in"](this.$getIconElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getCountsBySeverityElement",
      value: function $getCountsBySeverityElement() {
        return this.jq().find('.CountsBySeverityWidget');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getCountsBySeverityWidget",
      value: function $getCountsBySeverityWidget() {
        return Widget["in"](this.$getCountsBySeverityElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getDonutChartElement",
      value: function $getDonutChartElement() {
        return this.jq().find('.sourceOverview-bottom .donutChart');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getDonutChartWidget",
      value: function $getDonutChartWidget() {
        return Widget["in"](this.$getDonutChartElement());
      }

      /**
       * @private
       * @returns {module:nmodule/nss/rc/rpc/rpc.IDashboardService}
       */
    }, {
      key: "$getDashboardService",
      value: function $getDashboardService() {
        return this.properties().getValue('dashboardService');
      }
    }]);
  }(BaseWidget);
});
