/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/mgr/EmailPasswordColumn
 */
define(['baja!', 'baja!email:IncomingAccount,email:OutgoingAccount', 'Promise', 'nmodule/webEditors/rc/servlets/password', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn'], function (baja, types, Promise, password, PropertyMgrColumn) {
  'use strict';

  /**
   * Manager column for the `transport` property.
   *
   * @class
   * @alias module:nmodule/email/rc/mgr/EmailPasswordColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn
   */
  var EmailPasswordColumn = function EmailPasswordColumn() {
    PropertyMgrColumn.apply(this, arguments);
  };
  EmailPasswordColumn.prototype = Object.create(PropertyMgrColumn.prototype);
  EmailPasswordColumn.prototype.constructor = EmailPasswordColumn;
  EmailPasswordColumn.prototype.commit = function (value, row) {
    var account = row.getSubject(),
      slot = account.getSlot('password'),
      pwd = value.encodeToString();
    return account.isMounted() && password.setPassword(pwd, slot, account) || PropertyMgrColumn.prototype.commit.apply(this, arguments);
  };
  return EmailPasswordColumn;
});
