/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/mgr/EmailAuthenticationColumn
 */
define(['baja!', 'Promise', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn'], function (baja, Promise, PropertyMgrColumn) {
  'use strict';

  /**
   * Manager column for the `useAuthentication` property.
   *
   * @class
   * @alias module:nmodule/email/rc/mgr/EmailAuthenticationColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn
   */
  var EmailAuthenticationColumn = function EmailAuthenticationColumn() {
    PropertyMgrColumn.apply(this, arguments);
  };
  EmailAuthenticationColumn.prototype = Object.create(PropertyMgrColumn.prototype);
  EmailAuthenticationColumn.prototype.constructor = EmailAuthenticationColumn;

  /**
   * Override to always return true for an email:Incoming account and the corresponding boolean property
   * for an email:Outgoing Account
   * @param row
   * @returns {Boolean} Boolean indicating whether the account should use authentication
   */
  EmailAuthenticationColumn.prototype.getValueFor = function (row) {
    var account = row.getSubject();
    return baja.hasType(account, 'email:OutgoingAccount') ? account.getUseAuthentication() : true;
  };
  return EmailAuthenticationColumn;
});
