function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _wrapNativeSuper(t) { var r = "function" == typeof Map ? new Map() : void 0; return _wrapNativeSuper = function _wrapNativeSuper(t) { if (null === t || !_isNativeFunction(t)) return t; if ("function" != typeof t) throw new TypeError("Super expression must either be null or a function"); if (void 0 !== r) { if (r.has(t)) return r.get(t); r.set(t, Wrapper); } function Wrapper() { return _construct(t, arguments, _getPrototypeOf(this).constructor); } return Wrapper.prototype = Object.create(t.prototype, { constructor: { value: Wrapper, enumerable: !1, writable: !0, configurable: !0 } }), _setPrototypeOf(Wrapper, t); }, _wrapNativeSuper(t); }
function _construct(t, e, r) { if (_isNativeReflectConstruct()) return Reflect.construct.apply(null, arguments); var o = [null]; o.push.apply(o, e); var p = new (t.bind.apply(t, o))(); return r && _setPrototypeOf(p, r.prototype), p; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _isNativeFunction(t) { try { return -1 !== Function.toString.call(t).indexOf("[native code]"); } catch (n) { return "function" == typeof t; } }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/dashboard/rc/ux/DashboardPane
 */
define(['baja!', 'Promise', 'lex!dashboard', 'jquery', 'underscore', 'bajaux/spandrel', 'nmodule/webEditors/rc/wb/profile/profileUtils', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/dashboard/rc/dashboard', 'log!nmodule.dashboard.rc.ux.DashboardPane', 'css!nmodule/dashboard/rc/dashboard'], function (baja, Promise, lexs, $, _, spandrel, profileUtils, NullWidget, dashboard, log) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    dashboardLex = _lexs[0],
    logSevere = log.severe.bind(log);
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-DashboardPane',
        id: baja.Format.make('%ord%;%viewId%;%widgetOrd%;%jsOrd%')
      }
    };
  };
  var getOrdWithoutViewQuery = profileUtils.getOrdWithoutViewQuery,
    resolveCurrentViewId = profileUtils.resolveCurrentViewId;

  /**
   * 
   * @private
   * @class
   * @alias module:nmodule/dashboard/rc/ux/DashboardPane~DashboardPaneError
   * @extends Error 
   */
  var DashboardPaneError = /*#__PURE__*/function (_Error) {
    function DashboardPaneError() {
      _classCallCheck(this, DashboardPaneError);
      return _callSuper(this, DashboardPaneError, arguments);
    }
    _inherits(DashboardPaneError, _Error);
    return _createClass(DashboardPaneError);
  }(/*#__PURE__*/_wrapNativeSuper(Error));
  /**
   * `bajaux` implementation of `DashboardPane`.
   *
   * @class
   * @alias module:nmodule/dashboard/rc/ux/DashboardPane
   * @extends module:bajaux/Widget
   */
  return /*#__PURE__*/function (_spandrel) {
    function DashboardPane(params) {
      _classCallCheck(this, DashboardPane);
      return _callSuper(this, DashboardPane, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @private
     * @returns {module:nmodule/bajaui/rc/ux/WebWidget}
     */
    _inherits(DashboardPane, _spandrel);
    return _createClass(DashboardPane, [{
      key: "$getWebWidget",
      value: function $getWebWidget() {
        return this.queryWidget('0');
      }

      /**
      * Try to fetch any saved dashboard data and update the spandrel config
      * 
      * @private
      * @param {module:nmodule/bajaui/rc/model/UxModel} model
       @return {Promise}
      */
    }, {
      key: "$getConfig",
      value: function $getConfig(model) {
        var _this = this;
        var webWidgetModel = model.getKids()[0];
        if (webWidgetModel.getType() === NullWidget) {
          return Promise.reject(new DashboardPaneError(dashboardLex.get('dashboardPane.addToContent')));
        }
        // Add the hidden 'dashboard' property
        var dashboardProp = {
          dashboard: {
            hidden: true,
            name: 'dashboard',
            value: true,
            readonly: true,
            "transient": true,
            typeSpec: 'baja:Boolean'
          }
        };
        return resolveId(model).then(function (dashboardId) {
          var id = dashboardId;
          return _this.$getDashboardData(id).then(function (dashboardData) {
            var hasDashboardData = !_.isEmpty(dashboardData);
            Object.assign(webWidgetModel.getProperties(), dashboardProp, dashboardData);
            var config = webWidgetModel.toSpandrel('<div class="ignorePreferredSize"></div>');
            Object.assign(config, {
              hooks: {
                postLoad: function postLoad(widget) {
                  var content = widget.$getContentWidget();
                  if (content) {
                    dashboard.initialize(content.jq(), id, hasDashboardData);
                    // postLoad of the WebWidget will not be called if there is no binding
                    // which means the toolbar will not get loaded for a dashboard pane
                    // The code below ensures toolbar is always added for the DashboardPane
                    if (content.properties().getValue('hideCommandBar')) {
                      return;
                    }
                    return widget.$getToolbar().load(content.getCommandGroup());
                  }
                }
              }
            });
            return [config];
          });
        });
      }

      /**
       * Read dashboard data saved to the station
       *
       * @private
       * @param {String} id
       * @return {Promise}
       */
    }, {
      key: "$getDashboardData",
      value: function $getDashboardData(id) {
        return getDashboardService().then(function (service) {
          return service.readDashboard(id).then(function (data) {
            var dashboardData = {};
            if (data) {
              dashboardData = JSON.parse(data);
            }
            return dashboardData;
          });
        })["catch"](function () {
          throw new DashboardPaneError(dashboardLex.get('dashboardPane.errorStarting'));
        });
      }
    }]);
  }(spandrel(function (model) {
    return this.$getConfig(model)["catch"](function (err) {
      if (err instanceof DashboardPaneError) {
        return [spandrel.jsx("label", null, err.message)];
      } else {
        logSevere(err);
      }
    });
  }));

  /**
   * This function resolves to a unique identifier used to read/save any configuration data
   * saved on the station.
   * Although it is a configurable property of the DashboardPane (id property), the
   * only format accepted is baja.Format.make('%ord%;%viewId%;%widgetOrd%;%jsOrd%')
   * 
   * @private
   * @inner
   * @param {module:nmodule/bajaui/rc/model/UxModel} model 
   * @returns {Promise.<String>}
   */
  function resolveId(model) {
    var webWidgetModel = model.getKids()[0];
    var _model$getProperties = model.getProperties(),
      id = _model$getProperties.id;
    var _webWidgetModel$getPr = webWidgetModel.getProperties(),
      js = _webWidgetModel$getPr.js,
      $widgetOrd = _webWidgetModel$getPr.$widgetOrd;
    var _ord = getOrdWithoutViewQuery();
    return resolveCurrentViewId().then(function (_viewId) {
      //swap the viewId if its for a BPxFile within the HxProfile.
      if (_viewId === "hx:HxPxView") {
        _viewId = "workbench:WbPxView";
      }
      return id.format({
        object: {
          ord: function ord() {
            return baja.SlotPath.escape(_ord.relativizeToSession().toString());
          },
          viewId: function viewId() {
            return baja.SlotPath.escape(_viewId);
          },
          widgetOrd: function widgetOrd() {
            return baja.SlotPath.escape($widgetOrd.toString());
          },
          jsOrd: function jsOrd() {
            return baja.SlotPath.escape(js.toString());
          }
        }
      });
    });
  }

  /**
   * Return a promise that resolves to the Station Dashboard Service.
   *
   * @private
   * @inner
   * 
   * @returns {Promise} A promise that resolves to the Dashboard Service.
   */
  function getDashboardService() {
    return baja.Ord.make("service:dashboard:DashboardService").get({
      lease: true
    });
  }
});
